/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.telemetry.exporter.http;

import com.google.common.base.Preconditions;
import io.confluent.telemetry.client.Credentials;
import io.confluent.telemetry.client.ProxyConfig;
import io.confluent.telemetry.client.TelemetryHttpClient;
import io.confluent.telemetry.exporter.ExporterConfig;
import io.confluent.telemetry.exporter.http.HttpClientConfig;
import io.confluent.telemetry.exporter.http.HttpConfigUtils;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.SslConfigs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpExporterConfig
extends ExporterConfig {
    private static final Logger log = LoggerFactory.getLogger(HttpExporterConfig.class);
    public static final String API_KEY = "api.key";
    public static final String API_KEY_DOC = "The API key used to authenticate the requests made by HttpExporter. However, if a named exporter client is configured, this value should not be set";
    public static final String API_SECRET = "api.secret";
    public static final String API_SECRET_DOC = "The API secret used to authenticate requests made by HttpExporter. However, if a named exporter client is configured, this value should not be set";
    public static final String BUFFER_MAX_BATCH_DURATION_MS = "buffer.batch.duration.max.ms";
    public static final String BUFFER_MAX_BATCH_DURATION_MS_DOC = "The maximum duration (in millis) to buffer items before sending them upstream. However, if a named exporter client is configured, this value should not be set";
    public static final String BUFFER_MAX_BATCH_SIZE = "buffer.batch.items.max";
    public static final String BUFFER_MAX_BATCH_SIZE_DOC = "The maximum number of items to buffer into a batch before sending them upstream. However, if a named exporter client is configured, this value should not be set";
    public static final String BUFFER_MAX_PENDING_BATCHES = "buffer.pending.batches.max";
    public static final String BUFFER_MAX_PENDING_BATCHES_DOC = "The maximum number of pending batches. If more than this number of batches are pending(i.e. there is backpressure) then the oldest batches will be dropped. However, if a named exporter client is configured, this value should not be set";
    public static final String BUFFER_MAX_INFLIGHT_SUBMISSIONS = "buffer.inflight.submissions.max";
    public static final String BUFFER_MAX_INFLIGHT_SUBMISSIONS_DOC = "The maximum number of in-flight calls to the HTTP service. However, if a named exporter client is configured, this value should not be set";
    public static final String CLIENT_BASE_URL = "client.base.url";
    public static final String CLIENT_BASE_URL_DOC = "The base URL for the telemetry receiver (i.e. https://host:port). However, if a named exporter client is configured, this value should not be set";
    public static final String CLIENT_METRICS_PATH = "client.metrics.path.override";
    public static final String CLIENT_METRICS_PATH_DOC = "The URL path to post metrics to for metrics (i.e. /v1/metrics_override). However, if a named exporter client is configured, this value should not be set";
    public static final String CLIENT_METRICS_PATH_DEFAULT = "/v1/metrics";
    public static final String CLIENT_REQUEST_TIMEOUT_MS = "client.request.timeout.ms";
    public static final String CLIENT_REQUEST_TIMEOUT_MS_DOCS = "The request timeout in milliseconds. However, if a named exporter client is configured, this value should not be set";
    public static final String CLIENT_CONNECT_TIMEOUT_MS = "client.connect.timeout.ms";
    public static final String CLIENT_CONNECT_TIMEOUT_MS_DOC = "The connect timeout in milliseconds. However, if a named exporter client is configured, this value should not be set";
    public static final String CLIENT_MAX_ATTEMPTS = "client.attempts.max";
    public static final String CLIENT_MAX_ATTEMPTS_DOC = "The maximum number of delivery attempts. However, if a named exporter client is configured, this value should not be set";
    public static final String CLIENT_RETRY_DELAY_SEC = "client.retry.delay.seconds";
    public static final String CLIENT_RETRY_DELAY_SEC_DOC = "The delay, in seconds, between retry attempts. However, if a named exporter client is configured, this value should not be set";
    public static final String CLIENT_COMPRESSION = "client.compression";
    public static final String CLIENT_COMPRESSION_DOC = "HTTP Compression algorithm to use. Either gzip, lz4, or zstd. However, if a named exporter client is configured, this value should not be set";
    public static final String PROXY_URL = "proxy.url";
    public static final String PROXY_URL_DOC = "The URL for an explicit (i.e. not transparent) forward HTTP proxy. However, if a named exporter client is configured, this value should not be set";
    public static final String PROXY_USERNAME = "proxy.username";
    public static final String PROXY_USERNAME_DOC = "The username credential for the forward HTTP proxy. However, if a named exporter client is configured, this value should not be set";
    public static final String PROXY_PASSWORD = "proxy.password";
    public static final String PROXY_PASSWORD_DOC = "The password credential for the forward HTTP proxy. However, if a named exporter client is configured, this value should not be set";
    public static final String CONNECTION_SSL_CONFIG_PREFIX = "https.";
    public static final Set<String> RECONFIGURABLE_CONFIGS = Set.of("api.key", "api.secret", "proxy.url", "proxy.username", "proxy.password");
    private static final ConfigDef CONFIG = new ConfigDef().define("api.key", ConfigDef.Type.STRING, null, ConfigDef.Importance.HIGH, "The API key used to authenticate the requests made by HttpExporter. However, if a named exporter client is configured, this value should not be set").define("api.secret", ConfigDef.Type.PASSWORD, null, ConfigDef.Importance.HIGH, "The API secret used to authenticate requests made by HttpExporter. However, if a named exporter client is configured, this value should not be set").define("buffer.batch.duration.max.ms", ConfigDef.Type.LONG, null, ConfigDef.Importance.LOW, "The maximum duration (in millis) to buffer items before sending them upstream. However, if a named exporter client is configured, this value should not be set").define("buffer.batch.items.max", ConfigDef.Type.INT, null, ConfigDef.Importance.LOW, "The maximum number of items to buffer into a batch before sending them upstream. However, if a named exporter client is configured, this value should not be set").define("buffer.pending.batches.max", ConfigDef.Type.INT, null, ConfigDef.Importance.LOW, "The maximum number of pending batches. If more than this number of batches are pending(i.e. there is backpressure) then the oldest batches will be dropped. However, if a named exporter client is configured, this value should not be set").define("buffer.inflight.submissions.max", ConfigDef.Type.INT, null, ConfigDef.Importance.LOW, "The maximum number of in-flight calls to the HTTP service. However, if a named exporter client is configured, this value should not be set").define("client.base.url", ConfigDef.Type.STRING, null, (ConfigDef.Validator)new HttpConfigUtils.URIValidator(), ConfigDef.Importance.LOW, "The base URL for the telemetry receiver (i.e. https://host:port). However, if a named exporter client is configured, this value should not be set").defineInternal("client.metrics.path.override", ConfigDef.Type.STRING, (Object)"/v1/metrics", ConfigDef.Importance.LOW, "The URL path to post metrics to for metrics (i.e. /v1/metrics_override). However, if a named exporter client is configured, this value should not be set").define("client.compression", ConfigDef.Type.STRING, null, ConfigDef.Importance.LOW, "HTTP Compression algorithm to use. Either gzip, lz4, or zstd. However, if a named exporter client is configured, this value should not be set").define("client.request.timeout.ms", ConfigDef.Type.INT, null, ConfigDef.Importance.LOW, "The request timeout in milliseconds. However, if a named exporter client is configured, this value should not be set").define("client.connect.timeout.ms", ConfigDef.Type.INT, null, ConfigDef.Importance.LOW, "The connect timeout in milliseconds. However, if a named exporter client is configured, this value should not be set").define("client.attempts.max", ConfigDef.Type.INT, null, ConfigDef.Importance.LOW, "The maximum number of delivery attempts. However, if a named exporter client is configured, this value should not be set").define("client.retry.delay.seconds", ConfigDef.Type.INT, null, ConfigDef.Importance.LOW, "The delay, in seconds, between retry attempts. However, if a named exporter client is configured, this value should not be set").define("proxy.url", ConfigDef.Type.STRING, null, (ConfigDef.Validator)new HttpConfigUtils.URIValidator(), ConfigDef.Importance.LOW, "The URL for an explicit (i.e. not transparent) forward HTTP proxy. However, if a named exporter client is configured, this value should not be set").define("proxy.username", ConfigDef.Type.STRING, null, ConfigDef.Importance.LOW, "The username credential for the forward HTTP proxy. However, if a named exporter client is configured, this value should not be set").define("proxy.password", ConfigDef.Type.PASSWORD, null, ConfigDef.Importance.LOW, "The password credential for the forward HTTP proxy. However, if a named exporter client is configured, this value should not be set");
    private final HttpClientConfig clientConfig;

    public static void main(String[] args) {
        System.out.println(CONFIG.toRst());
    }

    public HttpExporterConfig(String name, Map<String, ?> originals) {
        this(name, originals, true);
    }

    public HttpExporterConfig(String name, Map<String, ?> originals, boolean doLog) {
        this(name, originals, null, doLog);
    }

    public HttpExporterConfig(String name, Map<String, ?> originals, HttpClientConfig clientConfig, boolean doLog) {
        super(name, CONFIG, originals, doLog);
        this.clientConfig = clientConfig;
        if (this.hasNamedClient()) {
            if (this.hasNativeClientConfigs()) {
                throw new ConfigException("Exporter " + name + " is using both native client configs and named client");
            }
            Preconditions.checkNotNull((Object)((Object)clientConfig), (Object)"Using named client but HttpClientConfig is null");
            Preconditions.checkArgument((boolean)Objects.equals(clientConfig.getName(), this.getClientName()), (Object)"HttpClientConfig does not match the configured client");
            log.info("Configuring named client {} for exporter {}", (Object)this.getClientName(), (Object)name);
        }
    }

    public HttpClientConfig getClientConfig() {
        return this.clientConfig;
    }

    public String getClientName() {
        return this.getString("client");
    }

    public String getClientMetricsPath() {
        return this.clientConfig != null ? this.clientConfig.getClientMetricsPath() : HttpConfigUtils.getClientMetricsPath(this);
    }

    public Credentials getCredentials() {
        return this.clientConfig != null ? this.clientConfig.getCredentials() : HttpConfigUtils.getCredentials(this);
    }

    public ProxyConfig getProxyConfig() {
        return this.clientConfig != null ? this.clientConfig.getProxyConfig() : HttpConfigUtils.getProxyConfig(this);
    }

    public <T, S> TelemetryHttpClient.Builder<T, S> configureClientDefaults(TelemetryHttpClient.Builder<T, S> builder) {
        return this.clientConfig != null ? this.clientConfig.configureClientDefaults(builder) : HttpConfigUtils.configureClientDefaults(builder, this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HttpExporterConfig that = (HttpExporterConfig)((Object)o);
        return Objects.equals((Object)this.clientConfig, (Object)that.clientConfig);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.clientConfig});
    }

    private boolean hasNamedClient() {
        return !Objects.equals(this.getClientName(), "");
    }

    private boolean hasNativeClientConfigs() {
        return !this.originalsWithPrefix("api.").isEmpty() || !this.originalsWithPrefix("buffer.").isEmpty() || !this.originalsWithPrefix("client.").isEmpty() || !this.originalsWithPrefix("proxy.").isEmpty();
    }

    public Map<String, Object> sslConfigs() {
        ConfigDef sslConfigDef = new ConfigDef();
        SslConfigs.addClientSslSupport((ConfigDef)sslConfigDef);
        return sslConfigDef.parse(this.originalsWithPrefix(CONNECTION_SSL_CONFIG_PREFIX));
    }
}

