/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.telemetry.exporter.http;

import com.google.common.base.Preconditions;
import io.confluent.telemetry.client.BufferingAsyncClient;
import io.confluent.telemetry.client.BufferingAsyncTelemetryHttpClient;
import io.confluent.telemetry.client.BufferingAsyncTelemetryHttpClientBatchResult;
import io.confluent.telemetry.client.Credentials;
import io.confluent.telemetry.client.ProxyConfig;
import io.confluent.telemetry.client.TelemetryHttpClient;
import io.confluent.telemetry.exporter.ExportableMetric;
import io.confluent.telemetry.exporter.http.HttpExporterConfig;
import io.confluent.telemetry.exporter.http.SslFactory;
import io.opentelemetry.proto.collector.metrics.v1.ExportMetricsServiceRequest;
import io.opentelemetry.proto.collector.metrics.v1.ExportMetricsServiceResponse;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.kafka.common.config.AbstractConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpExporterConfigWrapper {
    private static final Logger log = LoggerFactory.getLogger(HttpExporterConfigWrapper.class);
    private final HttpExporterConfig config;
    private final Supplier<Credentials> credentialsSupplier;
    private final Supplier<ProxyConfig> proxyConfigSupplier;

    HttpExporterConfigWrapper(HttpExporterConfig config, Supplier<Credentials> credentialsSupplier, Supplier<ProxyConfig> proxyConfigSupplier) {
        Preconditions.checkNotNull((Object)((Object)config), (Object)"HttpExporterConfig cannot be null");
        Preconditions.checkNotNull(credentialsSupplier, (Object)"Credentials supplier cannot be null");
        Preconditions.checkNotNull(proxyConfigSupplier, (Object)"ProxyConfig supplier cannot be null");
        this.config = config;
        this.credentialsSupplier = credentialsSupplier;
        this.proxyConfigSupplier = proxyConfigSupplier;
    }

    HttpExporterConfig getConfig() {
        return this.config;
    }

    BufferingAsyncClient<ExportableMetric, ExportMetricsServiceResponse> createBufferingClient() {
        TelemetryHttpClient.Builder clientBuilder = this.config.getClientConfig() != null ? this.config.getClientConfig().configureClientDefaults(new TelemetryHttpClient.Builder()) : this.config.configureClientDefaults(new TelemetryHttpClient.Builder());
        TelemetryHttpClient client = clientBuilder.setRequestSerializer((outputStream, message) -> message.writeTo(outputStream)).setResponseDeserializer(ExportMetricsServiceResponse::parseFrom).setEndpoint(this.config.getClientConfig() != null ? this.config.getClientConfig().getClientMetricsPath() : this.config.getClientMetricsPath()).setCredentialsSupplier(this.credentialsSupplier).setProxyConfigSupplier(this.proxyConfigSupplier).setSslContext(new SslFactory(this.config.sslConfigs()).getSslContext()).build();
        BufferingAsyncTelemetryHttpClient bufferingClient = this.getBufferingAsyncClientBuilder().setClient(client).setCreateRequestFn(ExportableMetric::buildRequest).build();
        bufferingClient.getBatchResults().doOnNext(this::trackMetricResponses);
        return bufferingClient;
    }

    private BufferingAsyncTelemetryHttpClient.Builder<ExportableMetric, ExportMetricsServiceRequest, ExportMetricsServiceResponse> getBufferingAsyncClientBuilder() {
        AbstractConfig configToUse = this.config.getClientConfig() != null ? this.config.getClientConfig() : this.config;
        BufferingAsyncTelemetryHttpClient.Builder builder = BufferingAsyncTelemetryHttpClient.newBuilder();
        Optional.ofNullable(configToUse.getLong("buffer.batch.duration.max.ms")).map(Duration::ofMillis).ifPresent(arg_0 -> ((BufferingAsyncTelemetryHttpClient.Builder)builder).setMaxBatchDuration(arg_0));
        Optional.ofNullable(configToUse.getInt("buffer.batch.items.max")).ifPresent(arg_0 -> ((BufferingAsyncTelemetryHttpClient.Builder)builder).setMaxBatchSize(arg_0));
        Optional.ofNullable(configToUse.getInt("buffer.pending.batches.max")).ifPresent(arg_0 -> ((BufferingAsyncTelemetryHttpClient.Builder)builder).setMaxPendingBatches(arg_0));
        Optional.ofNullable(configToUse.getInt("buffer.inflight.submissions.max")).ifPresent(arg_0 -> ((BufferingAsyncTelemetryHttpClient.Builder)builder).setMaxInflightSubmissions(arg_0));
        return builder;
    }

    private void trackMetricResponses(BufferingAsyncTelemetryHttpClientBatchResult<ExportableMetric, ExportMetricsServiceResponse> batchResult) {
        if (!batchResult.isSuccess()) {
            log.error("Confluent Telemetry Metrics Failure", batchResult.getThrowable());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpExporterConfigWrapper that = (HttpExporterConfigWrapper)o;
        return Objects.equals((Object)this.config, (Object)that.config);
    }

    public int hashCode() {
        return Objects.hashCode((Object)this.config);
    }
}

