/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.telemetry.exporter.kafka;

import io.confluent.telemetry.exporter.CloseableReferenceTracker;
import io.confluent.telemetry.exporter.ReferenceTrackingProxy;
import io.confluent.telemetry.exporter.kafka.ProducerClientConfig;
import io.opentelemetry.proto.metrics.v1.MetricsData;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaClientFactory {
    private static final KafkaClientFactory INSTANCE = new KafkaClientFactory();
    private static final Logger log = LoggerFactory.getLogger(KafkaClientFactory.class);
    private final ConcurrentMap<String, CloseableReferenceTracker<ProducerClientConfig, Producer<byte[], MetricsData>>> kafkaProducerClients = new ConcurrentHashMap<String, CloseableReferenceTracker<ProducerClientConfig, Producer<byte[], MetricsData>>>();

    public static KafkaClientFactory getInstance() {
        return INSTANCE;
    }

    public synchronized Producer<byte[], MetricsData> get(ProducerClientConfig producerConfig, Properties properties) {
        if (producerConfig != null) {
            CloseableReferenceTracker tracker = this.kafkaProducerClients.computeIfAbsent(producerConfig.getName(), this::createTracker);
            tracker.setConfig(producerConfig);
            return (Producer)ReferenceTrackingProxy.createProxy(tracker);
        }
        log.info("Creating new non-static producer client");
        return new KafkaProducer(Objects.requireNonNull(properties));
    }

    private CloseableReferenceTracker<ProducerClientConfig, Producer<byte[], MetricsData>> createTracker(String clientName) {
        log.info("Creating new CloseableReferenceTracker for config " + clientName);
        return new CloseableReferenceTracker<ProducerClientConfig, Producer<byte[], MetricsData>>(clientName, conf -> new KafkaProducer(conf.getProducerProperties()));
    }
}

