/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.telemetry.exporter.kafka;

import com.google.common.annotations.VisibleForTesting;
import io.confluent.telemetry.emitter.ContextExportableMetric;
import io.confluent.telemetry.exporter.AbstractExporter;
import io.confluent.telemetry.exporter.ExportableMetric;
import io.confluent.telemetry.exporter.kafka.KafkaClientFactory;
import io.confluent.telemetry.exporter.kafka.KafkaExporterConfig;
import io.confluent.telemetry.metrics.Keyed;
import io.opentelemetry.proto.metrics.v1.MetricsData;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.time.Clock;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.errors.InterruptException;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.metrics.CompoundStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Meter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaExporter
extends AbstractExporter {
    private static final Logger log = LoggerFactory.getLogger(KafkaExporter.class);
    private static final int ERROR_LOG_INTERVAL_MS = 5000;
    public static final String VERSION_HEADER_KEY = "v";
    public static final byte[] V1_HEADER_BYTES = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putInt(1).array();
    private static final Header V1_HEADER = new Header(){

        public String key() {
            return KafkaExporter.VERSION_HEADER_KEY;
        }

        public byte[] value() {
            return V1_HEADER_BYTES;
        }
    };
    private static final Iterable<Header> V1_HEADERS = Collections.singleton(V1_HEADER);
    private static final KafkaClientFactory KAFKA_CLIENT_FACTORY = KafkaClientFactory.getInstance();
    private boolean isTopicCreated = false;
    private final Properties adminClientProperties;
    private final String topicName;
    private final boolean createTopic;
    private final int topicReplicas;
    private final int topicPartitions;
    private final Map<String, String> topicConfig;
    private final Producer<byte[], MetricsData> producer;
    private final AtomicLong droppedEventCount = new AtomicLong();
    private final AtomicReference<Exception> droppedEventException = new AtomicReference();
    private long lastLoggedTimestamp = 0L;
    private long lastLoggedCount = 0L;
    private volatile boolean isClosed = false;
    private SelfMetrics selfMetrics;

    public KafkaExporter(Builder builder) {
        super(Optional.ofNullable(builder.metricsPredicate).orElse(k -> true), builder.name);
        this.adminClientProperties = Objects.requireNonNull(builder.adminClientProperties);
        this.topicName = Objects.requireNonNull(builder.topicName);
        this.topicConfig = Objects.requireNonNull(builder.topicConfig);
        this.createTopic = builder.createTopic;
        this.topicReplicas = builder.topicReplicas;
        this.topicPartitions = builder.topicPartitions;
        this.producer = builder.producer;
    }

    /*
     * Exception decompiling
     */
    boolean ensureTopic() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    AdminClient createAdminClient() {
        return AdminClient.create((Properties)this.adminClientProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doEmit(ContextExportableMetric metric) {
        try {
            if (!this.maybeCreateTopic()) {
                return;
            }
            Producer<byte[], MetricsData> producer = this.producer;
            synchronized (producer) {
                long now;
                long droppedCount;
                long droppedDelta;
                if (!Thread.currentThread().isInterrupted() && !this.isClosed) {
                    log.trace("Generated metric message : {}", (Object)metric);
                    this.producer.send(new ProducerRecord(this.topicName, null, null, (Object)ExportableMetric.buildMetricsData(metric), V1_HEADERS), (metadata, exception) -> {
                        if (exception != null) {
                            this.selfMetrics.droppedRecordsSensor.record();
                            this.droppedEventCount.incrementAndGet();
                            this.droppedEventException.compareAndSet(null, exception);
                        } else {
                            this.selfMetrics.sentRecordsSensor.record();
                        }
                    });
                }
                if ((droppedDelta = (droppedCount = this.droppedEventCount.get()) - this.lastLoggedCount) > 0L && this.lastLoggedTimestamp + 5000L < (now = Clock.systemUTC().millis())) {
                    log.warn("Failed to produce {} metrics messages", (Object)droppedDelta, this.droppedEventException.getAndSet(null));
                    this.lastLoggedTimestamp = now;
                    this.lastLoggedCount = droppedCount;
                }
            }
        }
        catch (InterruptException interruptException) {
            // empty catch block
        }
    }

    private synchronized boolean maybeCreateTopic() {
        if (this.createTopic) {
            if (!this.isTopicCreated) {
                this.isTopicCreated = this.ensureTopic();
            }
            return this.isTopicCreated;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        if (this.producer != null) {
            Producer<byte[], MetricsData> producer = this.producer;
            synchronized (producer) {
                this.isClosed = true;
                this.producer.close(Duration.ofMillis(0L));
            }
        }
    }

    @VisibleForTesting
    public Producer<byte[], MetricsData> getProducer() {
        return this.producer;
    }

    @Override
    public void setMetricsRegistry(Metrics metrics) {
        this.selfMetrics = new SelfMetrics(metrics);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(KafkaExporterConfig config) {
        Builder builder = new Builder().setCreateTopic(config.isCreateTopic()).setTopicConfig(config.getTopicConfig()).setTopicName(config.getTopicName()).setTopicReplicas(config.getTopicReplicas()).setTopicPartitions(config.getTopicPartitions()).setAdminClientProperties(config.getProducerProperties());
        log.info("Kafka Exporter " + config.getName() + " getting producer client " + config.getClientName());
        builder.setProducer(KAFKA_CLIENT_FACTORY.get(config.getClientConfig(), config.getProducerProperties()));
        return builder;
    }

    public static final class Builder {
        private Predicate<Keyed> metricsPredicate;
        private String name;
        private Properties adminClientProperties;
        private String topicName;
        private boolean createTopic;
        private int topicReplicas;
        private int topicPartitions;
        private Map<String, String> topicConfig;
        private Producer<byte[], MetricsData> producer;

        private Builder() {
        }

        public Builder setMetricsPredicate(Predicate<Keyed> metricsPredicate) {
            this.metricsPredicate = metricsPredicate;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setAdminClientProperties(Properties adminClientProperties) {
            this.adminClientProperties = adminClientProperties;
            return this;
        }

        public Builder setTopicName(String topicName) {
            this.topicName = topicName;
            return this;
        }

        public Builder setCreateTopic(boolean createTopic) {
            this.createTopic = createTopic;
            return this;
        }

        public Builder setTopicReplicas(int topicReplicas) {
            this.topicReplicas = topicReplicas;
            return this;
        }

        public Builder setTopicPartitions(int topicPartitions) {
            this.topicPartitions = topicPartitions;
            return this;
        }

        public Builder setTopicConfig(Map<String, String> topicConfig) {
            this.topicConfig = topicConfig;
            return this;
        }

        public Builder setProducer(Producer<byte[], MetricsData> producer) {
            this.producer = producer;
            return this;
        }

        public KafkaExporter build() {
            return new KafkaExporter(this);
        }
    }

    private class SelfMetrics {
        private static final String GROUP = "KafkaExporter";
        final Sensor droppedRecordsSensor;
        final Sensor sentRecordsSensor;

        SelfMetrics(Metrics metrics) {
            Map<String, String> tags = Collections.singletonMap("exporterName", KafkaExporter.this.getName());
            String sensorSuffix = "(name=" + KafkaExporter.this.getName() + ")";
            this.droppedRecordsSensor = metrics.sensor("dropped-records" + sensorSuffix);
            this.droppedRecordsSensor.add((CompoundStat)new Meter(metrics.metricName("dropped-records-rate", GROUP, tags), metrics.metricName("dropped-records-total", GROUP, tags)));
            this.sentRecordsSensor = metrics.sensor("sent-records" + sensorSuffix);
            this.sentRecordsSensor.add((CompoundStat)new Meter(metrics.metricName("sent-records-rate", GROUP, tags), metrics.metricName("sent-records-total", GROUP, tags)));
        }
    }
}

