/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.telemetry.exporter.kafka;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import io.confluent.telemetry.ConfigPropertyTranslater;
import io.confluent.telemetry.exporter.ExporterConfig;
import io.confluent.telemetry.exporter.kafka.ProducerClientConfig;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.record.TimestampType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaExporterConfig
extends ExporterConfig {
    private static final Logger log = LoggerFactory.getLogger(KafkaExporterConfig.class);
    public static final String PREFIX_PRODUCER = "producer.";
    public static final String BOOTSTRAP_SERVERS_CONFIG = "producer.bootstrap.servers";
    public static final String BOOTSTRAP_SERVERS_DOC = "Bootstrap servers for the Kafka cluster telemetry will be published to. The target cluster may be different from the cluster(s) whose telemetry is being collected. Several production Kafka clusters can publish to a single target Kafka cluster, for example. However, if a named exporter client is configured, this value should not be set";
    public static final String BOOTSTRAP_SERVERS_DEFAULT = "";
    public static final String PREFIX_TOPIC = "topic.";
    public static final String TOPIC_NAME_CONFIG = "topic.name";
    public static final String TOPIC_NAME_DOC = "Topic to which metrics data will be written.";
    public static final String DEFAULT_TOPIC_NAME = "_confluent-telemetry-metrics";
    public static final String TOPIC_CREATE_CONFIG = "topic.create";
    public static final String TOPIC_CREATE_DOC = "Create the metrics topic if it does not exist.";
    public static final boolean DEFAULT_TOPIC_CREATE = true;
    public static final String TOPIC_PARTITIONS_CONFIG = "topic.partitions";
    public static final String TOPIC_PARTITIONS_DOC = "Number of partitions in the metrics topic.";
    public static final int DEFAULT_TOPIC_PARTITIONS = 12;
    public static final String TOPIC_REPLICAS_CONFIG = "topic.replicas";
    public static final String TOPIC_REPLICAS_DOC = "Number of replicas in the metric topic. It must not be higher than the number of brokers in the destination Kafka cluster.";
    public static final int DEFAULT_TOPIC_REPLICAS = 3;
    public static final String TOPIC_RETENTION_MS_CONFIG = "topic.retention.ms";
    public static final String TOPIC_RETENTION_MS_DOC = "Retention time for the metrics topic.";
    public static final long DEFAULT_TOPIC_RETENTION_MS = TimeUnit.DAYS.toMillis(3L);
    public static final String TOPIC_RETENTION_BYTES_CONFIG = "topic.retention.bytes";
    public static final String TOPIC_RETENTION_BYTES_DOC = "Retention bytes for the metrics topic.";
    public static final long DEFAULT_TOPIC_RETENTION_BYTES = -1L;
    public static final String TOPIC_ROLL_MS_CONFIG = "topic.roll.ms";
    public static final String TOPIC_ROLL_MS_DOC = "Log rolling time for the metrics topic.";
    public static final long DEFAULT_TOPIC_ROLL_MS = TimeUnit.HOURS.toMillis(4L);
    public static final String TOPIC_MAX_MESSAGE_BYTES_CONFIG = "topic.max.message.bytes";
    public static final String TOPIC_MAX_MESSAGE_BYTES_DOC = "Maximum message size for the metrics topic.";
    public static final int DEFAULT_TOPIC_MAX_MESSAGE_BYTES = 0xA00000;
    private static final ConfigDef CONFIG = new ConfigDef().define("producer.bootstrap.servers", ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.HIGH, "Bootstrap servers for the Kafka cluster telemetry will be published to. The target cluster may be different from the cluster(s) whose telemetry is being collected. Several production Kafka clusters can publish to a single target Kafka cluster, for example. However, if a named exporter client is configured, this value should not be set").define("topic.name", ConfigDef.Type.STRING, (Object)"_confluent-telemetry-metrics", ConfigDef.Importance.LOW, "Topic to which metrics data will be written.").define("topic.create", ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.LOW, "Create the metrics topic if it does not exist.").define("topic.partitions", ConfigDef.Type.INT, (Object)12, ConfigDef.Importance.LOW, "Number of partitions in the metrics topic.").define("topic.replicas", ConfigDef.Type.INT, (Object)3, ConfigDef.Importance.LOW, "Number of replicas in the metric topic. It must not be higher than the number of brokers in the destination Kafka cluster.").define("topic.retention.ms", ConfigDef.Type.LONG, (Object)DEFAULT_TOPIC_RETENTION_MS, ConfigDef.Importance.LOW, "Retention time for the metrics topic.").define("topic.retention.bytes", ConfigDef.Type.LONG, (Object)-1L, ConfigDef.Importance.LOW, "Retention bytes for the metrics topic.").define("topic.roll.ms", ConfigDef.Type.LONG, (Object)DEFAULT_TOPIC_ROLL_MS, ConfigDef.Importance.LOW, "Log rolling time for the metrics topic.").define("topic.max.message.bytes", ConfigDef.Type.INT, (Object)0xA00000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.MEDIUM, "Maximum message size for the metrics topic.");
    private static final ConfigPropertyTranslater DEPRECATION_TRANSLATER = new ConfigPropertyTranslater.Builder().build();
    private final ProducerClientConfig clientConfig;

    public KafkaExporterConfig(String name, Map<String, ?> originals) {
        this(name, originals, null, true);
    }

    public KafkaExporterConfig(String name, Map<String, ?> originals, boolean doLog) {
        this(name, originals, null, doLog);
    }

    public KafkaExporterConfig(String name, Map<String, ?> originals, ProducerClientConfig clientConfig, boolean doLog) {
        super(name, CONFIG, DEPRECATION_TRANSLATER.translate(originals), doLog);
        this.clientConfig = clientConfig;
        if (this.hasNamedClient()) {
            if (this.hasNativeClientConfigs()) {
                throw new ConfigException("Exporter " + name + " is using both native client configs and named client");
            }
            Preconditions.checkNotNull((Object)((Object)clientConfig), (Object)"Using named client but ProducerClientConfig is null");
            Preconditions.checkArgument((boolean)Objects.equals(clientConfig.getName(), this.getClientName()), (Object)"ProducerClientConfig does not match the configured client");
            log.info("Configuring named client " + this.getClientName() + " for exporter " + name);
        }
    }

    public static void main(String[] args) {
        System.out.println(CONFIG.toRst());
    }

    public String getClientName() {
        return this.getString("client");
    }

    Properties getProducerProperties() {
        if (this.clientConfig != null) {
            return this.clientConfig.getProducerProperties();
        }
        return ProducerClientConfig.getProducerProperties(this.originalsWithPrefix(PREFIX_PRODUCER));
    }

    public boolean hasNamedClient() {
        return !Objects.equals(this.getString("client"), BOOTSTRAP_SERVERS_DEFAULT);
    }

    public boolean hasNativeClientConfigs() {
        return !this.originalsWithPrefix(PREFIX_PRODUCER).isEmpty();
    }

    public ProducerClientConfig getClientConfig() {
        return this.clientConfig;
    }

    Map<String, String> getTopicConfig() {
        HashMap<String, String> topicConfig = new HashMap<String, String>();
        topicConfig.put("min.insync.replicas", Integer.toString(1));
        topicConfig.put("retention.ms", this.getLong(TOPIC_RETENTION_MS_CONFIG).toString());
        topicConfig.put("retention.bytes", this.getLong(TOPIC_RETENTION_BYTES_CONFIG).toString());
        topicConfig.put("segment.ms", this.getLong(TOPIC_ROLL_MS_CONFIG).toString());
        topicConfig.put("max.message.bytes", this.getInt(TOPIC_MAX_MESSAGE_BYTES_CONFIG).toString());
        topicConfig.put("message.timestamp.type", TimestampType.CREATE_TIME.name);
        return topicConfig;
    }

    boolean isCreateTopic() {
        return this.getBoolean(TOPIC_CREATE_CONFIG);
    }

    int getTopicReplicas() {
        Integer topicReplicas = this.getInt(TOPIC_REPLICAS_CONFIG);
        Verify.verify((topicReplicas > 0 ? 1 : 0) != 0, (String)"topic needs at least 1 replica", (Object[])new Object[0]);
        return topicReplicas;
    }

    int getTopicPartitions() {
        Integer topicPartitions = this.getInt(TOPIC_PARTITIONS_CONFIG);
        Verify.verify((topicPartitions > 0 ? 1 : 0) != 0, (String)"topic needs at least 1 partition", (Object[])new Object[0]);
        return topicPartitions;
    }

    String getTopicName() {
        return this.getString(TOPIC_NAME_CONFIG);
    }
}

