/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.telemetry.exporter.kafka;

import io.confluent.monitoring.common.MonitoringProducerDefaults;
import io.confluent.telemetry.events.exporter.kafka.RandomBrokerPartitionSubsetPartitioner;
import io.confluent.telemetry.exporter.ClientConfig;
import io.confluent.telemetry.serde.OpenTelemetryMetricsSerde;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.serialization.ByteArraySerializer;

public class ProducerClientConfig
extends ClientConfig {
    public static final String PREFIX_PRODUCER = "producer.";
    public static final String BOOTSTRAP_SERVERS_CONFIG = "producer.bootstrap.servers";
    public static final String BOOTSTRAP_SERVERS_DOC = "Bootstrap servers for the Kafka cluster telemetry will be published to. The target cluster may be different from the cluster(s) whose telemetry is being collected. Several production Kafka clusters can publish to a single target Kafka cluster, for example.";
    private static final ConfigDef CONFIG_DEF = new ConfigDef().define("producer.bootstrap.servers", ConfigDef.Type.STRING, ConfigDef.Importance.HIGH, "Bootstrap servers for the Kafka cluster telemetry will be published to. The target cluster may be different from the cluster(s) whose telemetry is being collected. Several production Kafka clusters can publish to a single target Kafka cluster, for example.");

    public ProducerClientConfig(String name, Map<?, ?> originals, boolean doLog) {
        super(name, CONFIG_DEF, originals, doLog);
    }

    private static Map<String, Object> producerConfigDefaults() {
        HashMap<String, Object> defaults = new HashMap<String, Object>(MonitoringProducerDefaults.PRODUCER_CONFIG_DEFAULTS);
        defaults.put("key.serializer", ByteArraySerializer.class.getName());
        defaults.put("value.serializer", OpenTelemetryMetricsSerde.class.getName());
        defaults.put("enable.idempotence", "false");
        defaults.put("client.id", "confluent-telemetry-metrics-reporter");
        defaults.put("enable.metrics.push", "false");
        defaults.put("partitioner.class", RandomBrokerPartitionSubsetPartitioner.class.getName());
        return defaults;
    }

    public Properties getProducerProperties() {
        return ProducerClientConfig.getProducerProperties(this.originalsWithPrefix(PREFIX_PRODUCER));
    }

    public static Properties getProducerProperties(Map<String, Object> producerConfigs) {
        Properties props = new Properties();
        props.putAll(ProducerClientConfig.producerConfigDefaults());
        props.putAll(producerConfigs);
        if (!props.containsKey("bootstrap.servers")) {
            throw new ConfigException("Missing required property producer.bootstrap.servers");
        }
        return props;
    }
}

