/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.telemetry.provider;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import io.confluent.telemetry.ConfluentTelemetryConfig;
import io.confluent.telemetry.Context;
import io.confluent.telemetry.ResourceBuilderFacade;
import io.confluent.telemetry.collector.JvmMetricsCollector;
import io.confluent.telemetry.collector.MetricsCollector;
import io.confluent.telemetry.provider.Provider;
import io.confluent.telemetry.provider.Utils;
import io.opentelemetry.proto.resource.v1.Resource;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.metrics.MetricsContext;

public class KafkaClientProvider
implements Provider {
    @VisibleForTesting
    public static final String DOMAIN = "io.confluent.kafka.client";
    public static final String LABEL_CLIENT_ID = "client.id";
    public static final String ADMIN_NAMESPACE = "kafka.admin.client";
    public static final String CONSUMER_NAMESPACE = "kafka.consumer";
    public static final String PRODUCER_NAMESPACE = "kafka.producer";
    private static final List<String> DEFAULT_METRICS_INCLUDE_LIST = Collections.unmodifiableList(Arrays.asList(ConfluentTelemetryConfig.DEFAULT_SYSTEM_METRICS_INCLUDE_REGEX, "io.confluent.kafka.client/.*(producer/connection_count|producer/incoming_byte_rate|producer/incoming_byte_total|producer/outgoing_byte_rate|producer/outgoing_byte_total|producer/request_size_avg|producer/request_size_max|producer/requests_in_flight|producer/record_error_rate|producer/record_error_total|producer/record_send_rate|producer/record_send_total|producer/batch_size_avg|producer/batch_size_max|producer/record_size_avg|producer/record_size_max|producer_node/request_size_avg|producer_node/request_size_max|producer_node/incoming_byte_rate|producer_node/incoming_byte_total|producer_node/outgoing_byte_rate|producer_node/outgoing_byte_total|consumer/request_size_avg|consumer/request_size_max|consumer_fetch_manager/bytes_consumed_total|consumer_node/request_size_avg|consumer_node/request_size_max)"));
    private Resource resource;
    private ConfluentTelemetryConfig config;

    public synchronized void configure(Map<String, ?> configs) {
        this.config = new ConfluentTelemetryConfig(configs);
    }

    @Override
    public boolean validate(MetricsContext metricsContext, Map<String, ?> config) {
        return Utils.notEmptyString(config, LABEL_CLIENT_ID) && this.validateRequiredLabels(metricsContext.contextLabels());
    }

    @Override
    public void contextChange(MetricsContext metricsContext) {
        Map contextLabels = metricsContext.contextLabels();
        String clusterId = (String)contextLabels.get("resource.cluster.id");
        String resourceId = clusterId;
        if (resourceId == null) {
            String connectGroupId = (String)contextLabels.get("connect.group.id");
            String connectKafkaClusterId = (String)contextLabels.get("connect.kafka.cluster.id");
            clusterId = connectGroupId;
            resourceId = connectGroupId != null ? connectGroupId : connectKafkaClusterId;
        }
        ResourceBuilderFacade resourceBuilder = Utils.buildResourceFromAllLabelsWithId(metricsContext, resourceId).withNamespacedLabel(LABEL_CLIENT_ID, (String)this.config.originals().get(LABEL_CLIENT_ID));
        if (clusterId != null) {
            resourceBuilder.withNamespacedLabel("cluster.id", clusterId);
        }
        this.resource = resourceBuilder.build();
    }

    @Override
    public Resource resource() {
        return this.resource;
    }

    @Override
    public String domain() {
        return DOMAIN;
    }

    private boolean validateRequiredLabels(Map<String, String> metadata) {
        return Utils.validateRequiredResourceLabels(metadata) && (Utils.notEmptyString(metadata, "resource.cluster.id") || Utils.notEmptyString(metadata, "connect.group.id") || Utils.notEmptyString(metadata, "connect.kafka.cluster.id"));
    }

    @Override
    public List<MetricsCollector> extraCollectors(Context ctx) {
        return ImmutableList.of((Object)JvmMetricsCollector.newBuilder().setContext(ctx).build());
    }

    @Override
    public List<String> metricsIncludeRegexDefault() {
        return DEFAULT_METRICS_INCLUDE_LIST;
    }
}

