/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.telemetry.provider;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import io.confluent.telemetry.ConfluentTelemetryConfig;
import io.confluent.telemetry.Context;
import io.confluent.telemetry.ResourceBuilderFacade;
import io.confluent.telemetry.collector.JvmMetricsCollector;
import io.confluent.telemetry.collector.MetricsCollector;
import io.confluent.telemetry.provider.Provider;
import io.confluent.telemetry.provider.Utils;
import io.opentelemetry.proto.resource.v1.Resource;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.metrics.MetricsContext;

public class KafkaConnectProvider
implements Provider {
    @VisibleForTesting
    public static final String DOMAIN = "io.confluent.kafka.connect";
    public static final String NAMESPACE = "kafka.connect";
    private static final List<String> DEFAULT_METRICS_INCLUDE_LIST = Collections.unmodifiableList(Arrays.asList(ConfluentTelemetryConfig.DEFAULT_SYSTEM_METRICS_INCLUDE_REGEX, "io.confluent.kafka.connect/.*(connect/request_size_avg|connect/request_size_max|connect_node/request_size_avg|connect_node/request_size_max|connector_task/batch_size_avg|connector_task/batch_size_max|connector_task/task_mem_usages-avg|connector_task/task_mem_usages-max|connector_task/task_cpu_load_avg|connector_task/task_cpu_load_max|source_task/poll_batch_avg_time_ms|source_task/poll_batch_max_time_ms|source_task/source_record_write_rate|source_task/source_record_write_total|sink_task/sink_record_send_rate|sink_task/sink_record_send_total|sink_task/sink_record_read_rate|connect_worker/connector_destroyed_task_count|connect_worker/connector_failed_task_count|connect_worker/connector_paused_task_count|connect_worker/connector_running_task_count|connect_worker/connector_total_task_count|connect_worker/connector_unassigned_task_count|connect_worker/task_count|deadletterqueue_produce_requests)"));
    private Resource resource;

    public synchronized void configure(Map<String, ?> configs) {
    }

    @Override
    public boolean validate(MetricsContext metricsContext, Map<String, ?> config) {
        return this.validateKafkaConnectRequiredLabels(metricsContext.contextLabels());
    }

    @Override
    public void contextChange(MetricsContext metricsContext) {
        Map contextLabels = metricsContext.contextLabels();
        String kafkaClusterId = (String)contextLabels.get("connect.kafka.cluster.id");
        String groupId = (String)contextLabels.get("connect.group.id");
        String resourceId = groupId != null ? groupId : kafkaClusterId;
        ResourceBuilderFacade resourceBuilderFacade = Utils.buildResourceFromAllLabelsWithId(metricsContext, resourceId);
        if (groupId != null) {
            resourceBuilderFacade.withNamespacedLabel("cluster.id", groupId);
        }
        this.resource = resourceBuilderFacade.build();
    }

    @Override
    public List<String> metricsIncludeRegexDefault() {
        return DEFAULT_METRICS_INCLUDE_LIST;
    }

    @Override
    public Resource resource() {
        return this.resource;
    }

    @Override
    public String domain() {
        return DOMAIN;
    }

    private boolean validateKafkaConnectRequiredLabels(Map<String, String> metadata) {
        return Utils.notEmptyString(metadata, "_namespace") && Utils.notEmptyString(metadata, "resource.type") && Utils.notEmptyString(metadata, "resource.version") && Utils.notEmptyString(metadata, "resource.commit.id") && Utils.notEmptyString(metadata, "connect.kafka.cluster.id");
    }

    @Override
    public List<MetricsCollector> extraCollectors(Context ctx) {
        return ImmutableList.of((Object)JvmMetricsCollector.newBuilder().setContext(ctx).build());
    }
}

