/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.telemetry.provider;

import com.google.common.collect.ImmutableList;
import io.confluent.telemetry.ConfluentTelemetryConfig;
import io.confluent.telemetry.Context;
import io.confluent.telemetry.ResourceBuilderFacade;
import io.confluent.telemetry.collector.JvmMetricsCollector;
import io.confluent.telemetry.collector.MetricsCollector;
import io.confluent.telemetry.provider.Provider;
import io.confluent.telemetry.provider.Utils;
import io.opentelemetry.proto.resource.v1.Resource;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.metrics.MetricsContext;

public class KafkaRestProvider
implements Provider {
    public static final String DOMAIN = "io.confluent.kafka.rest";
    public static final String NAMESPACE = "kafka.rest";
    private static final List<String> DEFAULT_METRICS_INCLUDE_LIST = Collections.unmodifiableList(Arrays.asList(ConfluentTelemetryConfig.DEFAULT_SYSTEM_METRICS_INCLUDE_REGEX, "io.confluent.kafka.rest/.*(connections_active|connections_closed_rate|request_error_rate|request_latency_avg|request_latency_max|request_rate|response_size_avg|response_size_max)"));
    private Resource resource;
    private ConfluentTelemetryConfig config;

    public synchronized void configure(Map<String, ?> configs) {
        this.config = new ConfluentTelemetryConfig(configs);
    }

    @Override
    public boolean validate(MetricsContext metricsContext, Map<String, ?> config) {
        return Utils.validateRequiredLabels(metricsContext.contextLabels());
    }

    @Override
    public void contextChange(MetricsContext metricsContext) {
        ResourceBuilderFacade resourceBuilderFacade = Utils.buildResourceFromLabels(metricsContext);
        this.resource = resourceBuilderFacade.build();
    }

    @Override
    public Resource resource() {
        return this.resource;
    }

    @Override
    public String domain() {
        return DOMAIN;
    }

    @Override
    public List<MetricsCollector> extraCollectors(Context ctx) {
        return ImmutableList.of((Object)JvmMetricsCollector.newBuilder().setContext(ctx).build());
    }

    @Override
    public List<String> metricsIncludeRegexDefault() {
        return DEFAULT_METRICS_INCLUDE_LIST;
    }
}

