/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.telemetry.provider;

import com.google.common.annotations.VisibleForTesting;
import io.confluent.telemetry.BrokerConfigUtils;
import io.confluent.telemetry.ConfluentTelemetryConfig;
import io.confluent.telemetry.Context;
import io.confluent.telemetry.ResourceBuilderFacade;
import io.confluent.telemetry.collector.ConfluentMetricNamingConvention;
import io.confluent.telemetry.collector.JvmMetricsCollector;
import io.confluent.telemetry.collector.MetricsCollector;
import io.confluent.telemetry.collector.SLOMetricsCollector;
import io.confluent.telemetry.collector.VolumeMetricsCollector;
import io.confluent.telemetry.collector.YammerMetricsCollector;
import io.confluent.telemetry.provider.Provider;
import io.confluent.telemetry.provider.Utils;
import io.opentelemetry.proto.resource.v1.Resource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.kafka.common.metrics.MetricsContext;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaServerProvider
implements Provider {
    public static final String DEFAULT_SECURITY_METRICS_INCLUDE_REGEX = "io.confluent.kafka.server/.*(confluent_audit/audit_log_fallback_rate_per_minute|confluent_audit/audit_log_rate_per_minute|confluent_authorizer/authorization_request_rate_per_minute|confluent_authorizer/authorization_allowed_rate_per_minute|confluent_authorizer/authorization_denied_rate_per_minute|confluent_auth_store/rbac_role_bindings_count|confluent_auth_store/rbac_access_rules_count|confluent_auth_store/acl_access_rules_count)";
    public static final String DEFAULT_BROKER_METRICS_INCLUDE_REGEX = "io.confluent.kafka.server/.*(acl_authorizer/zookeeper_disconnects/total/delta|acl_authorizer/zookeeper_expires/total/delta|broker_failure/zookeeper_disconnects/total/delta|broker_failure/zookeeper_expires/total/delta|broker_topic/bytes_in/total/delta|broker_topic/bytes_out/total/delta|broker_topic/failed_produce_requests/total/delta|broker_topic/failed_fetch_requests/total/delta|broker_topic/produce_message_conversions/total/delta|broker_topic/fetch_message_conversions/total/delta|client_broker_topic/client_bytes_in/delta|client_broker_topic/client_bytes_out/delta|client_broker_topic/client_records_in/delta|client_broker_topic/client_records_out/delta|cluster_link/active_link_count|cluster_link/consumer_offset_committed_rate|cluster_link/consumer_offset_committed_total|cluster_link/fetch_throttle_time_avg|cluster_link/fetch_throttle_time_max|cluster_link/link_count|cluster_link/linked_leader_epoch_change_rate|cluster_link/linked_leader_epoch_change_total|cluster_link/linked_topic_partition_addition_rate|cluster_link/linked_topic_partition_addition_total|cluster_link/mirror_partition_count|cluster_link/mirror_topic_byte_total|cluster_link/mirror_topic_count|cluster_link/mirror_topic_lag|cluster_link/topic_config_update_rate|cluster_link/topic_config_update_total|cluster_link_fetcher/connection_count|cluster_link_fetcher/failed_reauthentication_rate|cluster_link_fetcher/failed_reauthentication_total|cluster_link_fetcher/incoming_byte_rate|cluster_link_fetcher/incoming_byte_total|cluster_link_fetcher/outgoing_byte_rate|cluster_link_fetcher/outgoing_byte_total|cluster_link_fetcher/reauthentication_latency_avg|cluster_link_fetcher_manager/max_lag|controller/active_controller_count|controller/leader_election_rate_and_time_ms|controller/offline_partitions_count|controller/partition_availability|controller/preferred_replica_imbalance_count|controller/tenant_partition_availability|controller/global_under_min_isr_partition_count|controller/unclean_leader_elections/total|controller_channel/connection_close_rate|controller_channel/connection_close_total|controller_channel/connection_count|controller_channel/connection_creation_rate|controller_channel/connection_creation_total|controller_channel/request_size_avg|controller_channel/request_size_max|controller_channel_manager/queue_size|controller_channel_manager/total_queue_size|controller_event_manager/event_queue_size|delayed_operation_purgatory/purgatory_size|executor/zookeeper_disconnects/total/delta|executor/zookeeper_expires/total/delta|fetch/queue_size|fetcher/bytes_per_sec|fetcher_lag/consumer_lag|group_coordinator/partition_load_time_max|log/log_end_offset|log/log_start_offset|log/total_size|log_cleaner_manager/achieved_cleaning_ratio/time/delta|log_cleaner_manager/achieved_cleaning_ratio/total/delta|log_cleaner_manager/compacted_partition_bytes|log_cleaner_manager/max_dirty_percent|log_cleaner_manager/time_since_last_run_ms|log_cleaner_manager/uncleanable_bytes|log_cleaner_manager/uncleanable_partitions_count|replica_alter_log_dirs_manager/max_lag|replica_fetcher/request_size_avg|replica_fetcher/request_size_max|replica_fetcher_manager/max_lag|replica_manager/blocked_on_mirror_source_partition_count|replica_manager/isr_shrinks|replica_manager/leader_count|replica_manager/partition_count|replica_manager/under_min_isr_mirror_partition_count|replica_manager/under_min_isr_partition_count|replica_manager/under_replicated_mirror_partitions|replica_manager/under_replicated_partitions|request/errors/total/delta|request/local_time_ms/time/delta|request/local_time_ms/total/delta|request/queue_size|request/remote_time_ms/time/delta|request/remote_time_ms/total/delta|request/request_queue_time_ms/time/delta|request/request_queue_time_ms/total/delta|request/requests|request/response_queue_time_ms/time/delta|request/response_queue_time_ms/total/delta|request/response_send_time_ms/time/delta|request/response_send_time_ms/total/delta|request/total_time_ms/time/delta|request/total_time_ms/total/delta|request_channel/request_queue_size|request_channel/response_queue_size|request_handler_pool/request_handler_avg_idle_percent|session_expire_listener/zookeeper_disconnects/total/delta|session_expire_listener/zookeeper_expires/total/delta|socket_server/connections|socket_server/successful_authentication_total/delta|socket_server/failed_authentication_total/delta|socket_server/network_processor_avg_idle_percent|socket_server/request_size_avg|socket_server/request_size_max|tenant/consumer_lag_offsets)";
    public static final String DEFAULT_CLIENT_TELEMETRY_METRICS_INCLUDE_REGEX = "org\\.apache\\.kafka\\.(producer\\.connection\\.creation\\.rate|producer\\.node\\.request\\.latency\\.avg|producer\\.node\\.request\\.latency\\.max|producer\\.produce\\.throttle\\.time\\.avg|producer\\.produce\\.throttle\\.time\\.max|producer\\.record\\.queue\\.time\\.avg|producer\\.record\\.queue\\.time\\.max|producer\\.connection\\.creation\\.total|consumer\\.connection\\.creation\\.rate|consumer\\.connection\\.creation\\.total|consumer\\.node\\.request\\.latency\\.avg|consumer\\.node\\.request\\.latency\\.max|consumer\\.poll\\.idle\\.ratio\\.avg|consumer\\.coordinator\\.commit\\.latency\\.avg|consumer\\.coordinator\\.commit\\.latency\\.max|consumer\\.coordinator\\.assigned\\.partitions|consumer\\.coordinator\\.rebalance\\.latency\\.avg|consumer\\.coordinator\\.rebalance\\.latency\\.max|consumer\\.coordinator\\.rebalance\\.latency\\.total|consumer\\.fetch\\.manager\\.fetch\\.latency\\.avg|consumer\\.fetch\\.manager\\.fetch\\.latency\\.max)";
    private static final List<String> DEFAULT_METRICS_INCLUDE_LIST = Collections.unmodifiableList(Arrays.asList(ConfluentTelemetryConfig.DEFAULT_SYSTEM_METRICS_INCLUDE_REGEX, "io.confluent.kafka.server/.*(confluent_audit/audit_log_fallback_rate_per_minute|confluent_audit/audit_log_rate_per_minute|confluent_authorizer/authorization_request_rate_per_minute|confluent_authorizer/authorization_allowed_rate_per_minute|confluent_authorizer/authorization_denied_rate_per_minute|confluent_auth_store/rbac_role_bindings_count|confluent_auth_store/rbac_access_rules_count|confluent_auth_store/acl_access_rules_count)", "io.confluent.kafka.server/.*(acl_authorizer/zookeeper_disconnects/total/delta|acl_authorizer/zookeeper_expires/total/delta|broker_failure/zookeeper_disconnects/total/delta|broker_failure/zookeeper_expires/total/delta|broker_topic/bytes_in/total/delta|broker_topic/bytes_out/total/delta|broker_topic/failed_produce_requests/total/delta|broker_topic/failed_fetch_requests/total/delta|broker_topic/produce_message_conversions/total/delta|broker_topic/fetch_message_conversions/total/delta|client_broker_topic/client_bytes_in/delta|client_broker_topic/client_bytes_out/delta|client_broker_topic/client_records_in/delta|client_broker_topic/client_records_out/delta|cluster_link/active_link_count|cluster_link/consumer_offset_committed_rate|cluster_link/consumer_offset_committed_total|cluster_link/fetch_throttle_time_avg|cluster_link/fetch_throttle_time_max|cluster_link/link_count|cluster_link/linked_leader_epoch_change_rate|cluster_link/linked_leader_epoch_change_total|cluster_link/linked_topic_partition_addition_rate|cluster_link/linked_topic_partition_addition_total|cluster_link/mirror_partition_count|cluster_link/mirror_topic_byte_total|cluster_link/mirror_topic_count|cluster_link/mirror_topic_lag|cluster_link/topic_config_update_rate|cluster_link/topic_config_update_total|cluster_link_fetcher/connection_count|cluster_link_fetcher/failed_reauthentication_rate|cluster_link_fetcher/failed_reauthentication_total|cluster_link_fetcher/incoming_byte_rate|cluster_link_fetcher/incoming_byte_total|cluster_link_fetcher/outgoing_byte_rate|cluster_link_fetcher/outgoing_byte_total|cluster_link_fetcher/reauthentication_latency_avg|cluster_link_fetcher_manager/max_lag|controller/active_controller_count|controller/leader_election_rate_and_time_ms|controller/offline_partitions_count|controller/partition_availability|controller/preferred_replica_imbalance_count|controller/tenant_partition_availability|controller/global_under_min_isr_partition_count|controller/unclean_leader_elections/total|controller_channel/connection_close_rate|controller_channel/connection_close_total|controller_channel/connection_count|controller_channel/connection_creation_rate|controller_channel/connection_creation_total|controller_channel/request_size_avg|controller_channel/request_size_max|controller_channel_manager/queue_size|controller_channel_manager/total_queue_size|controller_event_manager/event_queue_size|delayed_operation_purgatory/purgatory_size|executor/zookeeper_disconnects/total/delta|executor/zookeeper_expires/total/delta|fetch/queue_size|fetcher/bytes_per_sec|fetcher_lag/consumer_lag|group_coordinator/partition_load_time_max|log/log_end_offset|log/log_start_offset|log/total_size|log_cleaner_manager/achieved_cleaning_ratio/time/delta|log_cleaner_manager/achieved_cleaning_ratio/total/delta|log_cleaner_manager/compacted_partition_bytes|log_cleaner_manager/max_dirty_percent|log_cleaner_manager/time_since_last_run_ms|log_cleaner_manager/uncleanable_bytes|log_cleaner_manager/uncleanable_partitions_count|replica_alter_log_dirs_manager/max_lag|replica_fetcher/request_size_avg|replica_fetcher/request_size_max|replica_fetcher_manager/max_lag|replica_manager/blocked_on_mirror_source_partition_count|replica_manager/isr_shrinks|replica_manager/leader_count|replica_manager/partition_count|replica_manager/under_min_isr_mirror_partition_count|replica_manager/under_min_isr_partition_count|replica_manager/under_replicated_mirror_partitions|replica_manager/under_replicated_partitions|request/errors/total/delta|request/local_time_ms/time/delta|request/local_time_ms/total/delta|request/queue_size|request/remote_time_ms/time/delta|request/remote_time_ms/total/delta|request/request_queue_time_ms/time/delta|request/request_queue_time_ms/total/delta|request/requests|request/response_queue_time_ms/time/delta|request/response_queue_time_ms/total/delta|request/response_send_time_ms/time/delta|request/response_send_time_ms/total/delta|request/total_time_ms/time/delta|request/total_time_ms/total/delta|request_channel/request_queue_size|request_channel/response_queue_size|request_handler_pool/request_handler_avg_idle_percent|session_expire_listener/zookeeper_disconnects/total/delta|session_expire_listener/zookeeper_expires/total/delta|socket_server/connections|socket_server/successful_authentication_total/delta|socket_server/failed_authentication_total/delta|socket_server/network_processor_avg_idle_percent|socket_server/request_size_avg|socket_server/request_size_max|tenant/consumer_lag_offsets)", "org\\.apache\\.kafka\\.(producer\\.connection\\.creation\\.rate|producer\\.node\\.request\\.latency\\.avg|producer\\.node\\.request\\.latency\\.max|producer\\.produce\\.throttle\\.time\\.avg|producer\\.produce\\.throttle\\.time\\.max|producer\\.record\\.queue\\.time\\.avg|producer\\.record\\.queue\\.time\\.max|producer\\.connection\\.creation\\.total|consumer\\.connection\\.creation\\.rate|consumer\\.connection\\.creation\\.total|consumer\\.node\\.request\\.latency\\.avg|consumer\\.node\\.request\\.latency\\.max|consumer\\.poll\\.idle\\.ratio\\.avg|consumer\\.coordinator\\.commit\\.latency\\.avg|consumer\\.coordinator\\.commit\\.latency\\.max|consumer\\.coordinator\\.assigned\\.partitions|consumer\\.coordinator\\.rebalance\\.latency\\.avg|consumer\\.coordinator\\.rebalance\\.latency\\.max|consumer\\.coordinator\\.rebalance\\.latency\\.total|consumer\\.fetch\\.manager\\.fetch\\.latency\\.avg|consumer\\.fetch\\.manager\\.fetch\\.latency\\.max)"));
    @VisibleForTesting
    public static final String LABEL_CLUSTER_ID = "cluster.id";
    @VisibleForTesting
    public static final String LABEL_BROKER_ID = "broker.id";
    @VisibleForTesting
    public static final String LABEL_BROKER_RACK = "broker.rack";
    @VisibleForTesting
    public static final String LABEL_CELL_ID = "cell.id";
    public static final String LABEL_PROCESS_ROLES = "process.roles";
    public static final String LABEL_PROCESS_BROKER = "process.roles.broker";
    public static final String LABEL_PROCESS_CONTROLLER = "process.roles.controller";
    public static final String NAMESPACE = "kafka.server";
    private static final Logger log = LoggerFactory.getLogger(KafkaServerProvider.class);
    private static final String DOMAIN = "io.confluent.kafka.server";
    private Predicate<String> eventIncludeList = EXCLUDE_ALL;
    private Resource resource;
    private ConfluentTelemetryConfig config;

    public synchronized void configure(Map<String, ?> configs) {
        this.config = new ConfluentTelemetryConfig(configs.entrySet().stream().filter(e -> !((String)e.getKey()).startsWith(ConfluentTelemetryConfig.exporterPrefixForName("_local"))).filter(e -> !((String)e.getKey()).startsWith(ConfluentTelemetryConfig.exporterPrefixForName("_c3"))).filter(e -> e.getValue() != null).collect(Collectors.toMap(e -> (String)e.getKey(), e -> e.getValue())), false);
        this.eventIncludeList = Utils.configPredicate(this.config.getString("confluent.telemetry.events.collector.include"));
    }

    @Override
    public Resource resource() {
        return this.resource;
    }

    @Override
    public boolean validate(MetricsContext metricsContext, Map<String, ?> config) {
        return (Utils.notEmptyString(config, "node.id") || Utils.notEmptyString(config, LABEL_BROKER_ID)) && this.validateKafkaServerRequiredLabels(metricsContext.contextLabels());
    }

    @Override
    public String domain() {
        return DOMAIN;
    }

    @Override
    public List<MetricsCollector> extraCollectors(Context ctx) {
        ArrayList<MetricsCollector> collectors = new ArrayList<MetricsCollector>();
        collectors.add(JvmMetricsCollector.newBuilder().setContext(ctx).build());
        collectors.add(VolumeMetricsCollector.newBuilder(this.config).setContext(ctx).build());
        collectors.add(YammerMetricsCollector.newBuilder().setMetricNamingStrategy(ConfluentMetricNamingConvention.forYammerMetrics(ctx.getDomain(), ctx.isDebugEnabled(), ctx.isDebugEnabled())).setMetricsRegistry(KafkaYammerMetrics.defaultRegistry()).build());
        if (this.config.getBoolean("confluent.telemetry.metrics.collector.slo.enabled").booleanValue()) {
            collectors.add(new SLOMetricsCollector(KafkaYammerMetrics.defaultRegistry(), ConfluentMetricNamingConvention.forYammerMetrics(ctx.getDomain(), ctx.isDebugEnabled(), ctx.isDebugEnabled())));
        }
        return collectors;
    }

    @Override
    public void contextChange(MetricsContext metricsContext) {
        String clusterId = (String)metricsContext.contextLabels().get("kafka.cluster.id");
        String brokerId = (String)metricsContext.contextLabels().get("kafka.broker.id");
        if (brokerId == null) {
            brokerId = (String)metricsContext.contextLabels().get("kafka.node.id");
        }
        String type = (String)metricsContext.contextLabels().get("resource.type");
        String version = (String)metricsContext.contextLabels().get("resource.version");
        ResourceBuilderFacade resourceBuilderFacade = new ResourceBuilderFacade(type.toLowerCase(Locale.ROOT)).withVersion(version).withId(clusterId).withNamespacedLabels(Utils.getResourceLabels(metricsContext.contextLabels())).withNamespacedLabel(LABEL_BROKER_ID, brokerId).withNamespacedLabel(LABEL_CLUSTER_ID, clusterId);
        String cellId = (String)metricsContext.contextLabels().get("kafka.cell.id");
        if (cellId != null) {
            resourceBuilderFacade.withNamespacedLabel(LABEL_CELL_ID, cellId);
        }
        Optional.ofNullable((String)metricsContext.contextLabels().get("kafka.process.roles")).ifPresent(processRoles -> {
            List<String> roles = Arrays.asList(processRoles.split(","));
            boolean brokerRole = roles.contains("broker");
            boolean controllerRole = roles.contains("controller");
            resourceBuilderFacade.withNamespacedLabel(LABEL_PROCESS_ROLES, roles).withNamespacedLabel(LABEL_PROCESS_BROKER, String.valueOf(brokerRole)).withNamespacedLabel(LABEL_PROCESS_CONTROLLER, String.valueOf(controllerRole));
        });
        BrokerConfigUtils.getBrokerRack(this.config.originals()).ifPresent(value -> resourceBuilderFacade.withNamespacedLabel(LABEL_BROKER_RACK, (String)value));
        this.resource = resourceBuilderFacade.build();
    }

    @Override
    public List<String> metricsIncludeRegexDefault() {
        return DEFAULT_METRICS_INCLUDE_LIST;
    }

    private boolean validateKafkaServerRequiredLabels(Map<String, String> metadata) {
        return Utils.validateRequiredResourceLabels(metadata) && Utils.notEmptyString(metadata, "kafka.cluster.id") && (Utils.notEmptyString(metadata, "kafka.broker.id") || Utils.notEmptyString(metadata, "kafka.node.id"));
    }

    @Override
    public Predicate<String> configInclude() {
        return this.eventIncludeList;
    }
}

