/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.telemetry.provider;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import io.confluent.telemetry.ConfluentTelemetryConfig;
import io.confluent.telemetry.Context;
import io.confluent.telemetry.ResourceBuilderFacade;
import io.confluent.telemetry.collector.JvmMetricsCollector;
import io.confluent.telemetry.collector.MetricsCollector;
import io.confluent.telemetry.provider.Provider;
import io.confluent.telemetry.provider.Utils;
import io.opentelemetry.proto.resource.v1.Resource;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.metrics.MetricsContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaStreamsProvider
implements Provider {
    @VisibleForTesting
    public static final String DOMAIN = "io.confluent.kafka.streams";
    public static final String NAMESPACE = "kafka.streams";
    public static final String STREAMS_APPLICATION_ID = "application.id";
    private static final Logger log = LoggerFactory.getLogger(KafkaStreamsProvider.class);
    private Resource resource;
    private ConfluentTelemetryConfig config;

    public synchronized void configure(Map<String, ?> configs) {
        this.config = new ConfluentTelemetryConfig(configs);
    }

    @Override
    public boolean validate(MetricsContext metricsContext, Map<String, ?> config) {
        return Utils.notEmptyString(config, STREAMS_APPLICATION_ID) && Utils.validateRequiredLabels(metricsContext.contextLabels());
    }

    @Override
    public void contextChange(MetricsContext metricsContext) {
        String clusterId = (String)metricsContext.contextLabels().get("resource.cluster.id");
        String streamsApplicationId = (String)this.config.originals().get(STREAMS_APPLICATION_ID);
        ResourceBuilderFacade resourceBuilderFacade = Utils.buildResourceFromLabelsWithId(metricsContext, clusterId).withNamespacedLabel(STREAMS_APPLICATION_ID, streamsApplicationId);
        this.resource = resourceBuilderFacade.build();
    }

    @Override
    public List<String> metricsIncludeRegexDefault() {
        return Collections.singletonList(ConfluentTelemetryConfig.DEFAULT_SYSTEM_METRICS_INCLUDE_REGEX);
    }

    @Override
    public Resource resource() {
        return this.resource;
    }

    @Override
    public String domain() {
        return DOMAIN;
    }

    @Override
    public List<MetricsCollector> extraCollectors(Context ctx) {
        return ImmutableList.of((Object)JvmMetricsCollector.newBuilder().setContext(ctx).build());
    }
}

