/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.telemetry.provider;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import io.confluent.telemetry.ConfluentTelemetryConfig;
import io.confluent.telemetry.Context;
import io.confluent.telemetry.ResourceBuilderFacade;
import io.confluent.telemetry.collector.JvmMetricsCollector;
import io.confluent.telemetry.collector.MetricsCollector;
import io.confluent.telemetry.collector.VolumeMetricsCollector;
import io.confluent.telemetry.provider.Provider;
import io.confluent.telemetry.provider.Utils;
import io.opentelemetry.proto.resource.v1.Resource;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.metrics.MetricsContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KsqlProvider
implements Provider {
    @VisibleForTesting
    public static final String DOMAIN = "io.confluent.ksql";
    public static final String NAMESPACE = "io.confluent.ksql.metrics";
    public static final String KSQL_SERVICE_ID = "ksql.service.id";
    private static final String KSQL_ENGINE_QUERY_METRICS = "io.confluent.ksql/ksql_engine_query/(liveness_indicator|error_rate|num_persistent_queries|created_queries|num_idle_queries|error_queries|running_queries|not_running_queries|rebalancing_queries|pending_shutdown_queries|num_active_queries|bytes_consumed_total|messages_consumed|messages_produced)";
    private static final String PULL_QUERY_METRICS = "io.confluent.ksql/pull_query/pull_query_requests";
    private static final List<String> DEFAULT_METRICS_INCLUDE_LIST = Collections.unmodifiableList(Arrays.asList(ConfluentTelemetryConfig.DEFAULT_SYSTEM_METRICS_INCLUDE_REGEX, "io.confluent.ksql/ksql_engine_query/(liveness_indicator|error_rate|num_persistent_queries|created_queries|num_idle_queries|error_queries|running_queries|not_running_queries|rebalancing_queries|pending_shutdown_queries|num_active_queries|bytes_consumed_total|messages_consumed|messages_produced)", "io.confluent.ksql/pull_query/pull_query_requests"));
    private static final String[] MONITORED_VOLUMES = new String[]{"/mnt/data/data"};
    private static final Logger log = LoggerFactory.getLogger(KsqlProvider.class);
    private Resource resource;
    private ConfluentTelemetryConfig config;

    public synchronized void configure(Map<String, ?> configs) {
        this.config = new ConfluentTelemetryConfig(configs);
    }

    @Override
    public boolean validate(MetricsContext metricsContext, Map<String, ?> config) {
        return Utils.notEmptyString(config, KSQL_SERVICE_ID) && Utils.validateRequiredLabels(metricsContext.contextLabels());
    }

    @Override
    public void contextChange(MetricsContext metricsContext) {
        String ksqlClusterId = (String)this.config.originals().get(KSQL_SERVICE_ID);
        ResourceBuilderFacade resourceBuilderFacade = Utils.buildResourceFromLabelsWithId(metricsContext, ksqlClusterId);
        this.resource = resourceBuilderFacade.build();
    }

    @Override
    public List<String> metricsIncludeRegexDefault() {
        return DEFAULT_METRICS_INCLUDE_LIST;
    }

    @Override
    public Resource resource() {
        return this.resource;
    }

    @Override
    public String domain() {
        return DOMAIN;
    }

    @Override
    public List<MetricsCollector> extraCollectors(Context ctx) {
        return ImmutableList.of((Object)JvmMetricsCollector.newBuilder().setContext(ctx).build(), (Object)VolumeMetricsCollector.newBuilder(this.config).setContext(ctx).setLogDirs(MONITORED_VOLUMES).build());
    }
}

