/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.telemetry.provider;

import io.confluent.telemetry.provider.ControlCenterProvider;
import io.confluent.telemetry.provider.KafkaClientProvider;
import io.confluent.telemetry.provider.KafkaConnectProvider;
import io.confluent.telemetry.provider.KafkaRestProvider;
import io.confluent.telemetry.provider.KafkaServerProvider;
import io.confluent.telemetry.provider.KafkaStreamsProvider;
import io.confluent.telemetry.provider.KsqlProvider;
import io.confluent.telemetry.provider.Provider;
import io.confluent.telemetry.provider.SchemaRegistryProvider;
import io.confluent.telemetry.provider.Utils;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProviderRegistry {
    private static final Logger log = LoggerFactory.getLogger(ProviderRegistry.class);
    public static Map<String, String> providers = new HashMap<String, String>();

    public static Provider getProvider(String namespace) {
        if (!Utils.notEmptyString(providers, namespace)) {
            return null;
        }
        try {
            Class<?> clazz = Class.forName(providers.get(namespace));
            Object object = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (object instanceof Provider) {
                return (Provider)object;
            }
            log.error("Provider {} with class {} does not implement the Provider interface", (Object)namespace, (Object)providers.get(namespace));
        }
        catch (Exception e) {
            log.error("error while creating provider", (Throwable)e);
        }
        return null;
    }

    public static void registerProvider(String namespace, String provider) {
        providers.put(namespace, provider);
    }

    static {
        ProviderRegistry.registerProvider("kafka.server", KafkaServerProvider.class.getCanonicalName());
        ProviderRegistry.registerProvider("kafka.connect", KafkaConnectProvider.class.getCanonicalName());
        ProviderRegistry.registerProvider("kafka.admin.client", KafkaClientProvider.class.getCanonicalName());
        ProviderRegistry.registerProvider("kafka.producer", KafkaClientProvider.class.getCanonicalName());
        ProviderRegistry.registerProvider("kafka.consumer", KafkaClientProvider.class.getCanonicalName());
        ProviderRegistry.registerProvider("kafka.streams", KafkaStreamsProvider.class.getCanonicalName());
        ProviderRegistry.registerProvider("io.confluent.ksql.metrics", KsqlProvider.class.getCanonicalName());
        ProviderRegistry.registerProvider("kafka.schema.registry", SchemaRegistryProvider.class.getCanonicalName());
        ProviderRegistry.registerProvider("confluent.controlcenter", ControlCenterProvider.class.getCanonicalName());
        ProviderRegistry.registerProvider("kafka.rest", KafkaRestProvider.class.getCanonicalName());
    }
}

