/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.telemetry.provider;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import io.confluent.telemetry.ConfluentTelemetryConfig;
import io.confluent.telemetry.Context;
import io.confluent.telemetry.ResourceBuilderFacade;
import io.confluent.telemetry.collector.JvmMetricsCollector;
import io.confluent.telemetry.collector.MetricsCollector;
import io.confluent.telemetry.collector.VolumeMetricsCollector;
import io.confluent.telemetry.provider.Provider;
import io.confluent.telemetry.provider.Utils;
import io.opentelemetry.proto.resource.v1.Resource;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.metrics.MetricsContext;

public class SchemaRegistryProvider
implements Provider {
    @VisibleForTesting
    public static final String DOMAIN = "io.confluent.schema.registry";
    public static final String NAMESPACE = "kafka.schema.registry";
    public static final String SCHEMAS_TOPIC_CONFIG = "kafkastore.topic";
    private static final List<String> DEFAULT_METRICS_INCLUDE_LIST = Collections.unmodifiableList(Arrays.asList(ConfluentTelemetryConfig.DEFAULT_SYSTEM_METRICS_INCLUDE_REGEX, "io.confluent.schema.registry/.*(node_count|api_success_count|api_failure_count|custom_schema_provider_count|registered_count|deleted_count|avro_schemas_created|avro_schemas_deleted|json_schemas_created|json_schemas_deleted|protobuf_schemas_created|protobuf_schemas_deleted)"));
    private static final String[] MONITORED_VOLUMES = new String[]{"/mnt/data/srdata"};
    private String schemasTopic;
    private Resource resource;
    private ConfluentTelemetryConfig config;

    public synchronized void configure(Map<String, ?> configs) {
        this.schemasTopic = (String)configs.get(SCHEMAS_TOPIC_CONFIG);
        this.config = new ConfluentTelemetryConfig(configs);
    }

    @Override
    public boolean validate(MetricsContext metricsContext, Map<String, ?> config) {
        return Utils.notEmptyString(config, SCHEMAS_TOPIC_CONFIG) && Utils.validateRequiredLabels(metricsContext.contextLabels());
    }

    @Override
    public void contextChange(MetricsContext metricsContext) {
        ResourceBuilderFacade resourceBuilderFacade = Utils.buildResourceFromLabels(metricsContext);
        if (this.schemasTopic != null) {
            resourceBuilderFacade.withNamespacedLabel("topic", this.schemasTopic);
        }
        this.resource = resourceBuilderFacade.build();
    }

    @Override
    public List<String> metricsIncludeRegexDefault() {
        return DEFAULT_METRICS_INCLUDE_LIST;
    }

    @Override
    public Resource resource() {
        return this.resource;
    }

    @Override
    public String domain() {
        return DOMAIN;
    }

    @Override
    public List<MetricsCollector> extraCollectors(Context ctx) {
        return ImmutableList.of((Object)JvmMetricsCollector.newBuilder().setContext(ctx).build(), (Object)VolumeMetricsCollector.newBuilder(this.config).setContext(ctx).setLogDirs(MONITORED_VOLUMES).build());
    }
}

