/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.telemetry.provider;

import com.google.common.collect.ImmutableSet;
import com.google.protobuf.Message;
import io.confluent.telemetry.MetricsUtils;
import io.confluent.telemetry.ResourceBuilderFacade;
import io.confluent.telemetry.api.events.Event;
import io.confluent.telemetry.events.EventUtils;
import io.confluent.telemetry.events.v1.AnyValue;
import io.confluent.telemetry.events.v1.ArrayValue;
import io.confluent.telemetry.events.v1.Config;
import io.confluent.telemetry.events.v1.ConfigEvent;
import io.confluent.telemetry.events.v1.ConfigResource;
import io.confluent.telemetry.events.v1.KeyValue;
import io.confluent.telemetry.provider.Provider;
import io.opentelemetry.proto.resource.v1.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.kafka.common.metrics.MetricsContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    public static final String LABEL_CLUSTER_ID = "cluster.id";
    public static final String RESOURCE_LABEL_CLUSTER_ID = "resource.cluster.id";
    public static final String KAFKA_BROKER_ID = "kafka.broker.id";
    public static final String KAFKA_NODE_ID = "kafka.node.id";
    public static final String KAFKA_CLUSTER_ID = "kafka.cluster.id";
    public static final String KAFKA_CELL_ID = "kafka.cell.id";
    public static final String KAFKA_PROCESS_ROLES = "kafka.process.roles";
    public static final String KAFKA_CONTROLLER_ROLE = "controller";
    public static final String KAFKA_BROKER_ROLE = "broker";
    public static final String CONNECT_KAFKA_CLUSTER_ID = "connect.kafka.cluster.id";
    public static final String CONNECT_GROUP_ID = "connect.group.id";
    private static final Set<String> EXCLUDED_LABELS = ImmutableSet.of((Object)"_namespace", (Object)"kafka.cluster.id", (Object)"kafka.broker.id", (Object)"kafka.cell.id", (Object)"kafka.process.roles", (Object)"connect.kafka.cluster.id", (Object[])new String[]{"connect.group.id", "resource.type"});
    private static final Logger log = LoggerFactory.getLogger(Utils.class);

    public static boolean notEmptyString(Map<String, ?> m, String key) {
        if (!m.containsKey(key)) {
            log.trace("{} does not exist in map {}", (Object)key, m);
            return false;
        }
        if (m.get(key) == null) {
            log.trace("{} is null. map {}", (Object)key, m);
            return false;
        }
        if (!(m.get(key) instanceof String)) {
            log.trace("{} is not a string. map {}", (Object)key, m);
            return false;
        }
        String val = (String)m.get(key);
        if (val.isEmpty()) {
            log.trace("{} is empty string. value = {} map {}", new Object[]{key, val, m});
            return false;
        }
        return true;
    }

    public static Map<String, String> getResourceLabels(Map<String, String> metricsCtxMetadata) {
        return metricsCtxMetadata.entrySet().stream().filter(e -> !EXCLUDED_LABELS.contains(e.getKey())).collect(Collectors.toMap(entry -> ((String)entry.getKey()).replace("resource.", ""), entry -> (String)entry.getValue()));
    }

    public static Map<String, String> getNonResourceLabels(Map<String, String> metricsCtxMetadata) {
        ImmutableSet exclude = ImmutableSet.of((Object)"_namespace");
        return metricsCtxMetadata.entrySet().stream().filter(arg_0 -> Utils.lambda$getNonResourceLabels$3((Set)exclude, arg_0)).collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> (String)entry.getValue()));
    }

    public static ResourceBuilderFacade buildResourceFromLabels(MetricsContext metricsContext) {
        String clusterId = (String)metricsContext.contextLabels().get(RESOURCE_LABEL_CLUSTER_ID);
        String type = (String)metricsContext.contextLabels().get("resource.type");
        String version = (String)metricsContext.contextLabels().get("resource.version");
        ResourceBuilderFacade resourceBuilderFacade = new ResourceBuilderFacade(type.toLowerCase(Locale.ROOT)).withVersion(version).withId(clusterId).withNamespacedLabels(Utils.getResourceLabels(metricsContext.contextLabels()));
        return resourceBuilderFacade;
    }

    public static ResourceBuilderFacade buildResourceFromLabelsWithId(MetricsContext metricsContext, String id) {
        String type = (String)metricsContext.contextLabels().get("resource.type");
        String version = (String)metricsContext.contextLabels().get("resource.version");
        ResourceBuilderFacade resourceBuilderFacade = new ResourceBuilderFacade(type.toLowerCase(Locale.ROOT)).withVersion(version).withId(id).withNamespacedLabels(Utils.getResourceLabels(metricsContext.contextLabels()));
        return resourceBuilderFacade;
    }

    public static ResourceBuilderFacade buildResourceFromAllLabelsWithId(MetricsContext metricsContext, String id) {
        String type = (String)metricsContext.contextLabels().get("resource.type");
        String version = (String)metricsContext.contextLabels().get("resource.version");
        ResourceBuilderFacade resourceBuilderFacade = new ResourceBuilderFacade(type.toLowerCase(Locale.ROOT)).withVersion(version).withId(id).withNamespacedLabels(Utils.getResourceLabels(metricsContext.contextLabels())).withLabels(Utils.getNonResourceLabels(metricsContext.contextLabels()));
        return resourceBuilderFacade;
    }

    public static boolean validateRequiredLabels(Map<String, String> metadata) {
        return Utils.notEmptyString(metadata, "_namespace") && Utils.notEmptyString(metadata, "resource.type") && Utils.notEmptyString(metadata, "resource.version") && Utils.notEmptyString(metadata, RESOURCE_LABEL_CLUSTER_ID) && Utils.notEmptyString(metadata, "resource.commit.id");
    }

    public static boolean validateRequiredResourceLabels(Map<String, String> metadata) {
        return Utils.notEmptyString(metadata, "_namespace") && Utils.notEmptyString(metadata, "resource.type") && Utils.notEmptyString(metadata, "resource.version") && Utils.notEmptyString(metadata, "resource.commit.id");
    }

    public static Predicate<String> configPredicate(String regexString) {
        if ((regexString = regexString.trim()).isEmpty()) {
            return Provider.EXCLUDE_ALL;
        }
        Pattern pattern = Pattern.compile(regexString);
        return configName -> pattern.matcher((CharSequence)configName).matches();
    }

    public static Event configEvent(Map<String, ?> cfg, Predicate<String> configPredicate, Resource res, Provider provider, String eventType) {
        String idLabel;
        String id;
        Config.Builder ceConfig = Config.newBuilder();
        cfg.entrySet().stream().filter(e -> configPredicate.test((String)e.getKey())).forEach(e -> {
            Object value = e.getValue();
            AnyValue.Builder av = AnyValue.newBuilder();
            if (value instanceof String) {
                av.setStringValue((String)value);
            } else if (value instanceof Integer || value instanceof Long || value instanceof Short) {
                av.setIntValue(Long.parseLong(String.valueOf(value)));
            } else if (value instanceof Boolean) {
                av.setBoolValue(((Boolean)value).booleanValue());
            } else if (value instanceof Double) {
                av.setDoubleValue(((Double)value).doubleValue());
            } else if (value instanceof Class) {
                av.setStringValue(((Class)value).getCanonicalName());
            } else if (value instanceof List) {
                List l = (List)value;
                ArrayValue.Builder arv = ArrayValue.newBuilder();
                l.forEach(el -> arv.addValues(AnyValue.newBuilder().setStringValue(el.toString()).build()));
                av.setArrayValue(arv.build());
            } else {
                log.debug("Ignoring {} = {} ", e.getKey(), value);
                return;
            }
            ceConfig.putData((String)e.getKey(), av.build());
        });
        HashMap labels = new HashMap(res.getAttributesCount());
        ConfigResource.Builder r = ConfigResource.newBuilder();
        res.getAttributesList().forEach(attr -> {
            String key = attr.getKey();
            String stringValue = attr.getValue().getStringValue();
            r.addAttributes(KeyValue.newBuilder().setKey(key).setValue(AnyValue.newBuilder().setStringValue(stringValue)));
            labels.put(key, stringValue);
        });
        String crn = "crn://" + provider.domain() + "/";
        String resourceType = (String)labels.get("type");
        if (resourceType != null && (id = (String)labels.get(idLabel = resourceType + ".id")) != null) {
            crn = crn + idLabel + "=" + id;
        }
        return new Event().setId(UUID.randomUUID().toString()).setSource(crn).setSubject("telemetry-reporter").setType(eventType).setTime(MetricsUtils.nowInUTC()).setData("application/protobuf", EventUtils.protoToBytes((Message)ConfigEvent.newBuilder().setConfig(ceConfig.build()).setResource(r.build()).build(), (String)"application/protobuf"));
    }

    private static /* synthetic */ boolean lambda$getNonResourceLabels$3(Set exclude, Map.Entry e) {
        return !exclude.contains(e.getKey()) && !((String)e.getKey()).startsWith("resource.");
    }
}

