/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.telemetry.reporter;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.confluent.telemetry.BrokerConfigUtils;
import io.confluent.telemetry.ConfluentTelemetryConfig;
import io.confluent.telemetry.Context;
import io.confluent.telemetry.MetricsCollectorTask;
import io.confluent.telemetry.MetricsUtils;
import io.confluent.telemetry.api.events.Event;
import io.confluent.telemetry.api.events.EventEmitter;
import io.confluent.telemetry.api.events.EventEmitterProvider;
import io.confluent.telemetry.api.events.NoOpEventEmitter;
import io.confluent.telemetry.client.TelemetryHttpClient;
import io.confluent.telemetry.collector.ConfluentMetricNamingConvention;
import io.confluent.telemetry.collector.KafkaMetricsCollector;
import io.confluent.telemetry.collector.MetricsCollector;
import io.confluent.telemetry.config.FilterSetPredicate;
import io.confluent.telemetry.config.remote.RemoteConfigConfiguration;
import io.confluent.telemetry.config.remote.RemoteConfigurationSource;
import io.confluent.telemetry.config.remote.file.FileRemoteConfigConfiguration;
import io.confluent.telemetry.config.remote.file.FileRemoteConfigSource;
import io.confluent.telemetry.config.remote.polling.HttpRemoteConfigurationSource;
import io.confluent.telemetry.config.remote.polling.PollingRemoteConfigurationConfig;
import io.confluent.telemetry.config.remote.polling.kubernetes.KubernetesRemoteConfigurationConfig;
import io.confluent.telemetry.config.remote.polling.kubernetes.KubernetesRemoteConfigurationSource;
import io.confluent.telemetry.config.v2.ExporterConfig;
import io.confluent.telemetry.config.v2.NamedClientConfig;
import io.confluent.telemetry.config.v2.remote.RemoteConfiguration;
import io.confluent.telemetry.config.v2.remote.RemoteConfigurationRequest;
import io.confluent.telemetry.config.v2.remote.RemoteConfigurationResponse;
import io.confluent.telemetry.emitter.ClientMetricsTelemetryReceiver;
import io.confluent.telemetry.emitter.Emitter;
import io.confluent.telemetry.emitter.TelemetryEmitter;
import io.confluent.telemetry.events.EventEmitterConfig;
import io.confluent.telemetry.events.EventEmitterImpl;
import io.confluent.telemetry.events.EventLogger;
import io.confluent.telemetry.events.EventLoggerFactory;
import io.confluent.telemetry.events.exporter.ExporterConfig;
import io.confluent.telemetry.events.exporter.http.EventHttpExporter;
import io.confluent.telemetry.exporter.AbstractExporter;
import io.confluent.telemetry.exporter.Exporter;
import io.confluent.telemetry.exporter.ExporterConfig;
import io.confluent.telemetry.exporter.http.HttpClientConfig;
import io.confluent.telemetry.exporter.http.HttpExporter;
import io.confluent.telemetry.exporter.http.HttpExporterConfig;
import io.confluent.telemetry.exporter.kafka.KafkaExporter;
import io.confluent.telemetry.exporter.kafka.KafkaExporterConfig;
import io.confluent.telemetry.metrics.Keyed;
import io.confluent.telemetry.provider.KafkaServerProvider;
import io.confluent.telemetry.provider.Provider;
import io.confluent.telemetry.provider.ProviderRegistry;
import io.confluent.telemetry.provider.Utils;
import io.opentelemetry.proto.common.v1.AnyValue;
import io.opentelemetry.proto.resource.v1.Resource;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.kafka.common.ClusterResource;
import org.apache.kafka.common.ClusterResourceListener;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.metrics.JmxReporter;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.KafkaMetricsContext;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.MetricsContext;
import org.apache.kafka.common.metrics.MetricsReporter;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.telemetry.ClientTelemetry;
import org.apache.kafka.server.telemetry.ClientTelemetryReceiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TelemetryReporter
implements MetricsReporter,
ClusterResourceListener,
EventEmitterProvider,
ClientTelemetry {
    private static final Logger log = LoggerFactory.getLogger(TelemetryReporter.class);
    public static final String SELF_METRICS_DOMAIN = "io.confluent.telemetry";
    public static final String SELF_METRICS_NAMESPACE = "confluent.telemetry";
    public static final String TELEMETRY_REPORTER_ID_TAG = "telemetry-reporter-id";
    private Map<String, Object> rawOriginalConfig;
    private ConfluentTelemetryConfig originalConfig;
    private ConfluentTelemetryConfig config;
    private volatile Context ctx;
    private Optional<String> physicalClusterId;
    private MetricsCollectorTask collectorTask;
    private final Map<String, Exporter> exporters = new ConcurrentHashMap<String, Exporter>();
    private final List<MetricsCollector> collectors = new CopyOnWriteArrayList<MetricsCollector>();
    private volatile KafkaMetricsCollector kafkaMetricsCollector;
    private volatile TelemetryEmitter emitter;
    private Provider activeProvider;
    private RemoteConfigurationSource remoteConfigSource;
    private final EventLoggerFactory eventLoggerFactory;
    @VisibleForTesting
    volatile EventLogger configEventLogger;
    private volatile Optional<EventEmitterImpl> eventEmitterOpt;
    private Metrics selfMetrics;
    private FilterSetPredicate metricFilters;
    private RemoteConfiguration remoteConfig = new RemoteConfiguration();
    private final Uuid reporterId = Uuid.randomUuid();

    public TelemetryReporter() {
        this(config -> {
            EventLogger eventLogger = new EventLogger();
            eventLogger.configure(config);
            return eventLogger;
        });
    }

    @VisibleForTesting
    public TelemetryReporter(EventLoggerFactory eventLoggerFactory) {
        this.eventLoggerFactory = eventLoggerFactory;
    }

    public synchronized void configure(Map<String, ?> configs) {
        this.rawOriginalConfig = configs;
        this.eventEmitterOpt = this.createEventEmitter(configs);
    }

    public void validateReconfiguration(Map<String, ?> configs) throws ConfigException {
        this.createConfiguration(configs, false);
    }

    public synchronized void reconfigure(Map<String, ?> newRawConfig) {
        Preconditions.checkState((this.config != null && this.emitter != null ? 1 : 0) != 0, (Object)"contextChange() was not called before reconfigure()");
        ConfluentTelemetryConfig oldConfig = this.config;
        this.config = this.createConfiguration(newRawConfig, true);
        this.metricFilters = this.config.getDefaultFilterSet().union(this.metricFilters);
        this.reconfigureEventLogger(oldConfig, this.config);
        Event configEvent = Utils.configEvent(this.config.originals(), this.activeProvider.configInclude(), this.ctx.getResource(), this.activeProvider, this.activeProvider.domain() + "/config/dynamic");
        if (this.activeProvider != null) {
            if (this.configEventLogger != null) {
                this.configEventLogger.log(configEvent);
            }
            this.eventEmitterOpt.ifPresent(eventEmitter -> eventEmitter.emit(configEvent));
        }
        this.reconfigureRemoteConfigSource(this.config);
        this.reconfigureExporters(oldConfig, this.config);
        this.reconfigureEventEmitter(newRawConfig);
        this.updateEmitterPredicate();
    }

    private ConfluentTelemetryConfig createConfiguration(Map<String, ?> configs, boolean doLog) {
        configs = ConfluentTelemetryConfig.reconcileConfigs(configs);
        HashMap validateConfig = Maps.newHashMap((Map)this.originalConfig.originals());
        validateConfig.putAll(this.onlyReconfigurables(configs));
        return new ConfluentTelemetryConfig(validateConfig, doLog);
    }

    private void initExporters(Map<String, io.confluent.telemetry.exporter.ExporterConfig> toInit) {
        for (Map.Entry<String, io.confluent.telemetry.exporter.ExporterConfig> entry : toInit.entrySet()) {
            AbstractExporter newExporter;
            io.confluent.telemetry.exporter.ExporterConfig exporterConfig = entry.getValue();
            String exporterName = entry.getKey();
            log.info("Creating {} exporter named '{}'", (Object)exporterConfig.getType().name(), (Object)exporterName);
            Predicate<Keyed> metricsPredicate = this.resolveExporterMetricsPredicate(exporterConfig, this.remoteConfig);
            if (exporterConfig instanceof KafkaExporterConfig) {
                newExporter = KafkaExporter.newBuilder((KafkaExporterConfig)exporterConfig).setMetricsPredicate(metricsPredicate).setName(exporterName).build();
            } else if (exporterConfig instanceof HttpExporterConfig) {
                newExporter = new HttpExporter(metricsPredicate, exporterName, (HttpExporterConfig)exporterConfig);
            } else {
                throw new IllegalStateException("Unexpected exporter config: " + String.valueOf(((Object)((Object)exporterConfig)).getClass()));
            }
            newExporter.setMetricsRegistry(this.selfMetrics);
            this.exporters.put(exporterName, newExporter);
        }
    }

    private Predicate<Keyed> resolveExporterMetricsPredicate(io.confluent.telemetry.exporter.ExporterConfig exporterConfig, RemoteConfiguration remoteConfig) {
        if ("_local".equals(exporterConfig.getName()) || this.remoteConfigSource == null) {
            FilterSetPredicate defaultMetricsPredicate = this.metricFilters.subset(remoteConfig.getActiveFilters());
            return exporterConfig.buildMetricsPredicate().orElse(defaultMetricsPredicate);
        }
        return this.metricFilters.subset(Optional.ofNullable((ExporterConfig)remoteConfig.getExporterConfigMap().get(exporterConfig.getName())).map(ExporterConfig::getActiveFilters).orElse(remoteConfig.getActiveFilters()));
    }

    private void updateExporters(Map<String, io.confluent.telemetry.exporter.ExporterConfig> toReconfigure, RemoteConfiguration remoteConfig) {
        for (Map.Entry<String, io.confluent.telemetry.exporter.ExporterConfig> entry : toReconfigure.entrySet()) {
            Exporter exporter = this.exporters.get(entry.getKey());
            io.confluent.telemetry.exporter.ExporterConfig exporterConfig = entry.getValue();
            Predicate<Keyed> metricsPredicate = this.resolveExporterMetricsPredicate(exporterConfig, remoteConfig);
            if (exporter != null && exporterConfig.isRemoteConfigurable()) {
                this.closeExporters(Collections.singletonMap(exporterConfig.getName(), exporterConfig));
            }
            if (exporter == null || exporterConfig.isRemoteConfigurable()) {
                log.info("Configuring {} exporter", (Object)exporterConfig.getName());
                if (exporterConfig.getType() == ExporterConfig.ExporterType.http) {
                    exporter = new HttpExporter(metricsPredicate, exporterConfig.getName(), (HttpExporterConfig)exporterConfig);
                } else if (exporterConfig.getType() == ExporterConfig.ExporterType.kafka) {
                    exporter = KafkaExporter.newBuilder((KafkaExporterConfig)exporterConfig).setMetricsPredicate(metricsPredicate).setName(exporterConfig.getName()).build();
                } else {
                    throw new RuntimeException("unexpected Exporter type");
                }
                exporter.setMetricsRegistry(this.selfMetrics);
                this.exporters.put(exporterConfig.getName(), exporter);
            } else {
                exporter.reconfigurePredicate(metricsPredicate);
            }
            if (!(exporter instanceof HttpExporter)) continue;
            ((HttpExporter)exporter).setDynamicFields((HttpExporterConfig)exporterConfig);
        }
    }

    private void closeExporters(Map<String, io.confluent.telemetry.exporter.ExporterConfig> toClose) {
        for (Map.Entry<String, io.confluent.telemetry.exporter.ExporterConfig> entry : toClose.entrySet()) {
            log.info("Closing {} exporter named '{}'", (Object)entry.getValue().getType().name(), (Object)entry.getKey());
            Exporter exporter = this.exporters.remove(entry.getKey());
            try {
                exporter.close();
            }
            catch (Exception e) {
                log.warn("Exception closing {} exporter named '{}'", new Object[]{entry.getValue().getType(), entry.getKey(), e});
            }
        }
    }

    private void reconfigureExporters(ConfluentTelemetryConfig oldConfig, ConfluentTelemetryConfig newConfig) {
        Set<String> oldEnabled = oldConfig.enabledExporters().keySet();
        Set<String> newEnabled = newConfig.enabledExporters().keySet();
        this.closeExporters(newConfig.allExportersWithNames((Set<String>)Sets.difference(oldEnabled, newEnabled)));
        this.updateExporters(newConfig.allExportersWithNames((Set<String>)Sets.intersection(oldEnabled, newEnabled)), this.remoteConfig);
        this.initExporters(newConfig.allExportersWithNames((Set<String>)Sets.difference(newEnabled, oldEnabled)));
    }

    private void reconfigureRemoteConfigSource(ConfluentTelemetryConfig config) {
        Optional<RemoteConfigConfiguration> enabledRemoteConfigConfiguration = config.getRemoteConfigConfiguration();
        if (enabledRemoteConfigConfiguration.isPresent()) {
            RemoteConfigConfiguration remoteConfigSourceConfiguration = enabledRemoteConfigConfiguration.get();
            if (this.remoteConfigSource instanceof HttpRemoteConfigurationSource) {
                HttpExporterConfig exporterConfig = config.allHttpExporters().get("_confluent");
                if (exporterConfig == null) {
                    throw new ConfigException("Exporter '_confluent' config to use the HttpRemoteConfigurationSource.");
                }
                ((HttpRemoteConfigurationSource)this.remoteConfigSource).setProxyConfig(exporterConfig.getProxyConfig());
                ((HttpRemoteConfigurationSource)this.remoteConfigSource).setCredentials(exporterConfig.getCredentials());
            }
        }
    }

    public Set<String> reconfigurableConfigs() {
        if (this.config == null) {
            throw new IllegalStateException("contextChange() was not called before reconfigurableConfigs()");
        }
        HashSet<String> reconfigurables = new HashSet<String>(ConfluentTelemetryConfig.RECONFIGURABLES);
        for (String name : this.config.allExporters().keySet()) {
            reconfigurables.addAll(io.confluent.telemetry.exporter.ExporterConfig.RECONFIGURABLES.stream().map(c -> ConfluentTelemetryConfig.exporterPrefixForName(name) + c).collect(Collectors.toSet()));
        }
        for (String name : this.config.allHttpExporters().keySet()) {
            reconfigurables.addAll(HttpExporterConfig.RECONFIGURABLE_CONFIGS.stream().map(c -> ConfluentTelemetryConfig.exporterPrefixForName(name) + c).collect(Collectors.toSet()));
        }
        for (String name : this.config.allHttpClients().keySet()) {
            reconfigurables.addAll(HttpClientConfig.RECONFIGURABLE_CONFIGS.stream().map(c -> ConfluentTelemetryConfig.clientPrefixForName(name) + c).collect(Collectors.toSet()));
        }
        return reconfigurables;
    }

    public synchronized void contextChange(MetricsContext metricsContext) {
        Preconditions.checkState((this.rawOriginalConfig != null ? 1 : 0) != 0, (Object)"configure() was not called before contextChange()");
        log.debug("metricsContext {}", (Object)metricsContext.contextLabels());
        if (!metricsContext.contextLabels().containsKey("_namespace")) {
            log.error("_namespace not found in metrics context. Metrics collection is disabled");
            return;
        }
        this.collectors.forEach(MetricsCollector::stop);
        this.activeProvider = ProviderRegistry.getProvider((String)metricsContext.contextLabels().get("_namespace"));
        if (this.activeProvider == null) {
            log.error("No provider was detected for context {}. Available providers {}.", (Object)metricsContext.contextLabels(), ProviderRegistry.providers.keySet());
            return;
        }
        log.debug("provider {} is selected.", (Object)this.activeProvider.getClass().getCanonicalName());
        if (!this.activeProvider.validate(metricsContext, this.rawOriginalConfig)) {
            log.warn("Validation failed for {} context {}", this.activeProvider.getClass(), (Object)metricsContext.contextLabels());
            return;
        }
        if (this.collectorTask == null) {
            this.activeProvider.configure(this.rawOriginalConfig);
        }
        this.activeProvider.contextChange(metricsContext);
        if (this.collectorTask == null) {
            this.initConfig();
            this.initContext();
            this.initSelfMetrics();
            this.initCollectors();
            this.initExporters(this.config.enabledExporters());
            this.createEmitter();
            try {
                this.initRemoteConfig();
            }
            catch (RuntimeException e) {
                log.error("Unable to start Remote Configuration", (Throwable)e);
            }
            this.startMetricCollectorTask();
        }
        Event configEvent = Utils.configEvent(this.config.originals(), this.activeProvider.configInclude(), this.ctx.getResource(), this.activeProvider, this.activeProvider.domain() + "/config/static");
        this.eventEmitterOpt.ifPresent(eventEmitter -> {
            eventEmitter.setEventLabels(TelemetryReporter.eventLabels(this.activeProvider.resource()));
            eventEmitter.emit(configEvent);
        });
        if (this.configEventLogger != null) {
            this.configEventLogger.log(configEvent);
        }
    }

    private static Map<String, String> eventLabels(Resource resource) {
        return MetricsUtils.attributesMap(resource).entrySet().stream().filter(e -> !((String)e.getKey()).equals("type")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private void initConfig() {
        this.originalConfig = new ConfluentTelemetryConfig(TelemetryReporter.injectProviderConfigs(this.activeProvider, this.rawOriginalConfig));
        this.maybeInitEventLogger(this.originalConfig);
        this.config = this.originalConfig;
        this.metricFilters = this.config.getDefaultFilterSet();
        this.physicalClusterId = Optional.ofNullable(this.config.getString("confluent.telemetry.cluster.id"));
    }

    private void initContext() {
        Resource.Builder builder = this.activeProvider.resource().toBuilder();
        this.config.getLabels().forEach((k, v) -> builder.addAttributesBuilder().setKey(k).setValue(AnyValue.newBuilder().setStringValue(v)));
        Resource resource = builder.build();
        this.ctx = new Context(resource, this.activeProvider.domain(), this.config.isDebugEnabled());
    }

    private Map<String, Object> toEventLoggerConfig(ConfluentTelemetryConfig config) {
        HttpClientConfig defaultHttpExporterConfig = config.allHttpClients().get("_confluentClient");
        if (defaultHttpExporterConfig == null) {
            throw new ConfigException("Expected http client '_confluentClient' to exist but it does not.");
        }
        HashMap<String, Object> eventConfig = new HashMap<String, Object>(defaultHttpExporterConfig.originals());
        eventConfig.put("type", ExporterConfig.ExporterType.http.name());
        eventConfig.put("event.logger.exporter.class", EventHttpExporter.class.getCanonicalName());
        return eventConfig;
    }

    private void maybeInitEventLogger(ConfluentTelemetryConfig config) {
        if (config.getBoolean("confluent.telemetry.events.enable").booleanValue()) {
            this.initEventLogger(config);
        }
    }

    private void reconfigureEventLogger(ConfluentTelemetryConfig oldConfig, ConfluentTelemetryConfig newConfig) {
        boolean eventLoggerWasEnabled = oldConfig.getBoolean("confluent.telemetry.events.enable");
        boolean eventLoggerIsEnabled = newConfig.getBoolean("confluent.telemetry.events.enable");
        if (!eventLoggerIsEnabled) {
            this.closeEventLogger();
        } else if (eventLoggerWasEnabled) {
            this.reconfigureEventLogger(this.config);
        } else {
            this.initEventLogger(this.config);
        }
    }

    private void initEventLogger(ConfluentTelemetryConfig config) {
        if (this.configEventLogger != null) {
            log.warn("Trying to initialize the event logger but it's already initialized! Will not initialize another one...");
            return;
        }
        log.info("Initializing the event logger");
        this.configEventLogger = this.eventLoggerFactory.create(this.toEventLoggerConfig(config));
    }

    private void reconfigureEventLogger(ConfluentTelemetryConfig config) {
        if (this.configEventLogger == null) {
            log.warn("Trying to reconfigure the event logger but it's not initialized!");
            return;
        }
        this.configEventLogger.reconfigure(this.toEventLoggerConfig(config));
    }

    private void closeEventLogger() {
        if (this.configEventLogger == null) {
            return;
        }
        log.info("Closing the event logger");
        try {
            this.configEventLogger.close();
            this.configEventLogger = null;
        }
        catch (Exception e) {
            log.warn("Exception closing event logger", (Throwable)e);
        }
    }

    private void startMetricCollectorTask() {
        long collectIntervalMs = this.config.getLong("confluent.telemetry.metrics.collector.interval.ms");
        log.info("Starting Confluent telemetry reporter with an interval of {} ms)", (Object)collectIntervalMs);
        log.debug("Telemetry reporter resource attributes: {}", (Object)this.ctx.getResource().getAttributesList());
        this.collectorTask = new MetricsCollectorTask(this.collectors, collectIntervalMs, this.emitter);
        this.collectors.forEach(MetricsCollector::start);
        this.collectorTask.start();
    }

    private void initSelfMetrics() {
        final KafkaMetricsCollector selfMetricsCollector = new KafkaMetricsCollector(ConfluentMetricNamingConvention.forKafkaMetrics(SELF_METRICS_DOMAIN, this.ctx.isDebugEnabled(), this.ctx.isDebugEnabled()));
        this.collectors.add(selfMetricsCollector);
        MetricConfig config = new MetricConfig().tags((Map)ImmutableMap.of((Object)TELEMETRY_REPORTER_ID_TAG, (Object)this.reporterId.toString()));
        this.selfMetrics = new Metrics(config, (List)ImmutableList.of((Object)new JmxReporter(), (Object)new MetricsReporter(){

            public void init(List<KafkaMetric> metrics) {
                selfMetricsCollector.init(metrics);
            }

            public void metricChange(KafkaMetric metric) {
                selfMetricsCollector.metricChange(metric);
            }

            public void metricRemoval(KafkaMetric metric) {
                selfMetricsCollector.metricRemoval(metric);
            }

            public void close() {
            }

            public void configure(Map<String, ?> configs) {
            }
        }), Time.SYSTEM, (MetricsContext)new KafkaMetricsContext(SELF_METRICS_NAMESPACE));
    }

    private void initCollectors() {
        this.kafkaMetricsCollector = new KafkaMetricsCollector(ConfluentMetricNamingConvention.forKafkaMetrics(this.ctx.getDomain(), this.ctx.isDebugEnabled(), this.ctx.isDebugEnabled()));
        this.collectors.add(this.kafkaMetricsCollector);
        this.collectors.addAll(this.activeProvider.extraCollectors(this.ctx));
    }

    @VisibleForTesting
    ConfluentTelemetryConfig getConfig() {
        return this.config;
    }

    @VisibleForTesting
    Map<String, Exporter> getExporters() {
        return this.exporters;
    }

    @VisibleForTesting
    public List<MetricsCollector> getCollectors() {
        return this.collectors;
    }

    @VisibleForTesting
    public Metrics getSelfMetrics() {
        return this.selfMetrics;
    }

    @VisibleForTesting
    Uuid getReporterId() {
        return this.reporterId;
    }

    public void close() {
        log.info("Stopping TelemetryReporter collectorTask");
        if (this.collectorTask != null) {
            this.collectorTask.close();
        }
        this.collectors.forEach(MetricsCollector::stop);
        this.closeEventLogger();
        for (Exporter exporter : this.exporters.values()) {
            try {
                exporter.close();
            }
            catch (Exception e) {
                log.error("Error while closing {}", (Object)exporter, (Object)e);
            }
        }
        this.closeEventEmitter();
        if (this.remoteConfigSource != null) {
            log.info("Stopping TelemetryReporter remoteConfigTask");
            this.remoteConfigSource.stop();
        }
        if (this.selfMetrics != null) {
            this.selfMetrics.close();
        }
    }

    public synchronized void onUpdate(ClusterResource clusterResource) {
    }

    public void init(List<KafkaMetric> metrics) {
        if (this.kafkaMetricsCollector != null) {
            this.kafkaMetricsCollector.init(metrics);
        }
    }

    private void initRemoteConfig() throws RuntimeException {
        if (this.remoteConfigSource != null) {
            return;
        }
        this.config.getRemoteConfigConfiguration().ifPresent(remoteConfigSourceConfiguration -> {
            if (remoteConfigSourceConfiguration instanceof KubernetesRemoteConfigurationConfig) {
                try {
                    KubernetesRemoteConfigurationConfig config = (KubernetesRemoteConfigurationConfig)((Object)remoteConfigSourceConfiguration);
                    this.remoteConfigSource = new KubernetesRemoteConfigurationSource(config, this.physicalClusterId, this::onRemoteConfigurationReceived);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            } else if (remoteConfigSourceConfiguration instanceof FileRemoteConfigConfiguration) {
                this.remoteConfigSource = new FileRemoteConfigSource((FileRemoteConfigConfiguration)((Object)remoteConfigSourceConfiguration), this::onRemoteConfigurationReceived);
            } else if (remoteConfigSourceConfiguration instanceof PollingRemoteConfigurationConfig) {
                HttpExporterConfig exporterConfig = this.config.allHttpExporters().get("_confluent");
                if (exporterConfig == null) {
                    throw new ConfigException("Exporter '_confluent' config to use the HttpRemoteConfigurationSource.");
                }
                this.remoteConfigSource = TelemetryReporter.createHttpRemoteConfigurationSource(this.ctx.getResource(), (PollingRemoteConfigurationConfig)((Object)remoteConfigSourceConfiguration), exporterConfig, this::onRemoteConfigurationReceived);
            } else {
                throw new RuntimeException("Remote Configuration Config not supported");
            }
            this.remoteConfigSource.start();
        });
    }

    private static HttpRemoteConfigurationSource createHttpRemoteConfigurationSource(Resource resource, PollingRemoteConfigurationConfig remoteConfig, HttpExporterConfig exporterConfig, Consumer<RemoteConfiguration> callback) {
        TelemetryHttpClient.Builder builder = new TelemetryHttpClient.Builder();
        exporterConfig.configureClientDefaults(builder);
        HttpRemoteConfigurationSource configSource = new HttpRemoteConfigurationSource((TelemetryHttpClient.Builder<RemoteConfigurationRequest, RemoteConfigurationResponse>)builder, remoteConfig.getRefreshInterval(), callback, resource);
        configSource.setProxyConfig(exporterConfig.getProxyConfig());
        configSource.setCredentials(exporterConfig.getCredentials());
        return configSource;
    }

    public void onRemoteConfigurationReceived(RemoteConfiguration remoteConfig) {
        log.info("Updating remote configuration: {}", (Object)MoreObjects.toStringHelper(RemoteConfiguration.class).add("activeFilters", (Object)remoteConfig.getActiveFilters()).add("exporters", remoteConfig.getExporters().stream().map(e -> MoreObjects.toStringHelper(ExporterConfig.class).add("name", (Object)e.getName()).add("activeFilters", (Object)e.getActiveFilters())).collect(Collectors.toSet())).add("clients", remoteConfig.getClients().stream().map(e -> MoreObjects.toStringHelper(NamedClientConfig.class).add("name", (Object)e.getName())).collect(Collectors.toSet())));
        remoteConfig.getNamedClientConfigMap().entrySet().stream().filter(clientConfigEntry -> !this.config.hasClientWithName((String)clientConfigEntry.getKey())).forEach(clientConfigEntry -> this.config.addClientConfig((String)clientConfigEntry.getKey(), ((NamedClientConfig)clientConfigEntry.getValue()).getConfigs()));
        remoteConfig.getExporterConfigMap().entrySet().stream().filter(exporterConfigEntry -> !this.config.hasExporterWithName((String)exporterConfigEntry.getKey())).forEach(exporterConfigEntry -> this.config.addExporterConfig((String)exporterConfigEntry.getKey(), ((ExporterConfig)exporterConfigEntry.getValue()).getConfigs()));
        remoteConfig.getNamedClientConfigMap().entrySet().stream().filter(clientConfigEntry -> this.config.hasClientWithName((String)clientConfigEntry.getKey())).forEach(clientConfigEntry -> this.config.updateClientConfigs((String)clientConfigEntry.getKey(), ((NamedClientConfig)clientConfigEntry.getValue()).getConfigs()));
        remoteConfig.getExporterConfigMap().entrySet().stream().filter(exporterConfigEntry -> this.config.hasExporterWithName((String)exporterConfigEntry.getKey())).forEach(exporterConfigEntry -> this.config.updateExporterConfigs((String)exporterConfigEntry.getKey(), ((ExporterConfig)exporterConfigEntry.getValue()).getConfigs()));
        FilterSetPredicate newMetricFilters = FilterSetPredicate.fromNamedFilter(remoteConfig.getFilters());
        this.metricFilters = this.config.getDefaultFilterSet().union(newMetricFilters);
        this.updateExporters(this.config.enabledExporters(), remoteConfig);
        this.remoteConfig = remoteConfig;
        this.updateEmitterPredicate();
        this.collectorTask.setAggregationRules(remoteConfig.getAggregationRules());
    }

    public void metricChange(KafkaMetric metric) {
        if (this.kafkaMetricsCollector != null) {
            this.kafkaMetricsCollector.metricChange(metric);
        }
    }

    public void metricRemoval(KafkaMetric metric) {
        if (this.kafkaMetricsCollector != null) {
            this.kafkaMetricsCollector.metricRemoval(metric);
        }
    }

    private Map<String, ?> onlyReconfigurables(Map<String, ?> originals) {
        return this.reconfigurableConfigs().stream().filter(c -> originals.get(c) != null).collect(Collectors.toMap(c -> c, c -> originals.get(c)));
    }

    private void updateEmitterPredicate() {
        Predicate<Keyed> unionPredicate = this.getExporters().values().stream().map(Exporter::getPredicate).reduce(Predicate::or).orElse(metricKey -> false);
        this.emitter.reconfigurePredicate(unionPredicate);
    }

    private static Map<String, Object> prefixedExporterConfigs(String prefix, Map<String, Object> configs) {
        String exporterPrefix = ConfluentTelemetryConfig.exporterPrefixForName(prefix);
        return configs.entrySet().stream().filter(e -> e.getValue() != null).collect(Collectors.toMap(e -> exporterPrefix + (String)e.getKey(), e -> e.getValue()));
    }

    protected static Map<String, Object> injectProviderConfigs(Provider provider, Map<String, Object> originals) {
        return TelemetryReporter.maybeInjectC3PlusPlusExporter(provider, TelemetryReporter.maybeInjectLocalExporter(provider, TelemetryReporter.maybeInjectProviderDefaultIncludeConfig(provider, originals)));
    }

    private static Map<String, Object> maybeInjectC3PlusPlusExporter(Provider provider, Map<String, Object> originals) {
        if (!TelemetryReporter.isRunningInsideBroker(provider, originals)) {
            return originals;
        }
        HashMap<String, Object> configs = new HashMap<String, Object>();
        configs.putAll(TelemetryReporter.prefixedExporterConfigs("_c3", ConfluentTelemetryConfig.EXPORTER_C3PLUSPLUS_DEFAULTS));
        configs.putAll(originals);
        return configs;
    }

    private static Map<String, Object> maybeInjectProviderDefaultIncludeConfig(Provider provider, Map<String, Object> originals) {
        if (!originals.containsKey("confluent.telemetry.metrics.collector.include")) {
            return TelemetryReporter.updateMetricsInclude(originals, provider.metricsIncludeRegexDefault());
        }
        return originals;
    }

    private static Map<String, Object> updateMetricsInclude(Map<String, Object> originals, List<String> includeList) {
        HashMap<String, Object> configs = new HashMap<String, Object>(originals);
        String selfMetricsIncludeRegex = "io.confluent.telemetry/.*";
        configs.put("confluent.telemetry.metrics.collector.include", ConfluentTelemetryConfig.joinIncludeRegexList((List<String>)ImmutableList.builder().add((Object)selfMetricsIncludeRegex).addAll(includeList).build()));
        return configs;
    }

    private static boolean isRunningInsideBroker(Provider provider, Map<String, Object> originals) {
        if (provider instanceof KafkaServerProvider) {
            Object processRoles = originals.getOrDefault("process.roles", "");
            String processRolesToString = processRoles.toString();
            boolean isKRaftRemoteController = processRolesToString.contains("controller") && !processRolesToString.contains("broker");
            return !isKRaftRemoteController;
        }
        return false;
    }

    private static Map<String, Object> maybeInjectLocalExporter(Provider provider, Map<String, Object> originals) {
        HashMap<String, Object> configs = new HashMap<String, Object>();
        if (TelemetryReporter.isRunningInsideBroker(provider, originals)) {
            configs.putAll(TelemetryReporter.prefixedExporterConfigs("_local", ConfluentTelemetryConfig.EXPORTER_LOCAL_DEFAULTS));
            configs.putAll(TelemetryReporter.prefixedExporterConfigs("_local", BrokerConfigUtils.deriveLocalProducerConfigs(originals)));
            String balanceReplicationFactor = BrokerConfigUtils.getBalanceReplicationFactor(originals);
            if (balanceReplicationFactor != null) {
                configs.putAll(TelemetryReporter.prefixedExporterConfigs("_local", (Map<String, Object>)ImmutableMap.of((Object)"topic.replicas", (Object)balanceReplicationFactor)));
            }
        }
        configs.putAll(originals);
        return configs;
    }

    @VisibleForTesting
    Context getContext() {
        return this.ctx;
    }

    public Emitter emitter() {
        if (this.emitter == null) {
            throw new IllegalStateException("emitter() was called before the Emitter was instantiated.");
        }
        return this.emitter;
    }

    private void createEmitter() {
        this.emitter = new TelemetryEmitter(this.ctx, this.exporters::values, this.selfMetrics);
        this.updateEmitterPredicate();
    }

    public EventEmitter eventEmitter() {
        return this.eventEmitterOpt.isPresent() ? (EventEmitter)this.eventEmitterOpt.get() : NoOpEventEmitter.INSTANCE;
    }

    private void closeEventEmitter() {
        this.eventEmitterOpt.ifPresent(eventEmitter -> {
            try {
                eventEmitter.close();
            }
            catch (Exception e) {
                log.error("Error while closing {}", eventEmitter, (Object)e);
            }
        });
    }

    private Optional<EventEmitterImpl> createEventEmitter(Map<String, ?> configs) {
        Optional<EventEmitterImpl> eventEmitterOpt = Optional.empty();
        if (this.maybeInitEventEmitter(configs)) {
            eventEmitterOpt = Optional.of(new EventEmitterImpl(configs));
        }
        return eventEmitterOpt;
    }

    private void reconfigureEventEmitter(Map<String, ?> configs) {
        this.closeEventEmitter();
        this.eventEmitterOpt = this.createEventEmitter(configs);
        this.eventEmitterOpt.ifPresent(eventEmitter -> eventEmitter.setEventLabels(TelemetryReporter.eventLabels(this.activeProvider.resource())));
    }

    private boolean maybeInitEventEmitter(Map<String, ?> configs) {
        EventEmitterConfig config = new EventEmitterConfig(configs);
        Map eventExporterConfigs = config.getEnabledExporterConfigs(EventEmitterConfig.EventType.events);
        if (eventExporterConfigs == null || eventExporterConfigs.isEmpty()) {
            return false;
        }
        for (Map.Entry entry : eventExporterConfigs.entrySet()) {
            if (!config.isKafkaExporter((Map)entry.getValue()) && !config.isHttpExporter((Map)entry.getValue())) continue;
            return true;
        }
        return false;
    }

    public ClientTelemetryReceiver clientReceiver() {
        return new ClientMetricsTelemetryReceiver(this.emitter, this.ctx, TelemetryReporter.eventLabels(this.activeProvider.resource()), this.config.getClientMetricsExcludeLabels());
    }
}

