/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.telemetry.serde;

import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import io.opentelemetry.proto.metrics.v1.MetricsData;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Map;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Deserializer;

public class ProtoToJson
implements Deserializer<String> {
    public void configure(Map configs, boolean isKey) {
    }

    public void close() {
    }

    public String deserialize(String topic, byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            MetricsData metric = MetricsData.parseFrom((byte[])data);
            return JsonFormat.printer().omittingInsignificantWhitespace().print((MessageOrBuilder)metric);
        }
        catch (Exception e) {
            String errMsg = "Error deserializing protobuf message";
            throw new SerializationException(errMsg, (Throwable)e);
        }
    }

    public String deserialize(String topic, Headers headers, byte[] data) {
        int version = ProtoToJson.telemetryMessageVersion(headers);
        if (version == 1) {
            return this.deserialize(topic, data);
        }
        throw new SerializationException("Unsupported telemetry message version: [" + version + "]");
    }

    private static int telemetryMessageVersion(Headers headers) {
        Header versionHeader = headers.lastHeader("v");
        if (versionHeader != null) {
            return ByteBuffer.wrap(versionHeader.value()).order(ByteOrder.LITTLE_ENDIAN).getInt();
        }
        return 0;
    }
}

