/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.shell.confluent;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.List;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Properties;
import kafka.raft.KafkaMetadataLog;
import kafka.raft.MetadataLogConfig;
import kafka.server.KafkaRaftServer$;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.impl.type.FileArgumentType;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentType;
import net.sourceforge.argparse4j.inf.MutuallyExclusiveGroup;
import net.sourceforge.argparse4j.inf.Namespace;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.util.LocalMetadataLogReader;
import org.apache.kafka.raft.ReplicatedLog;
import org.apache.kafka.raft.VoterSet;
import org.apache.kafka.server.common.KRaftVersion;
import org.apache.kafka.server.util.KafkaScheduler;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.shell.InteractiveShell;
import org.apache.kafka.shell.command.Commands;
import org.apache.kafka.shell.confluent.MetadataShellObserver;
import org.apache.kafka.shell.confluent.ShellSourceManager;

public class MetadataShellTool {
    public static void main(String[] argv) throws Exception {
        MetadataShellObserver source;
        VoterSet voterSet;
        KRaftVersion kRaftVersion;
        ArgumentParser parser = ArgumentParsers.newArgumentParser((String)"metadata-shell-tool").defaultHelp(true).description("The Apache Kafka metadata tool");
        parser.addArgument(new String[]{"--cluster-id", "-t"}).help("The cluster id. Required when using --controllers");
        MutuallyExclusiveGroup accessGroup = parser.addMutuallyExclusiveGroup().required(true);
        accessGroup.addArgument(new String[]{"--directory", "-d"}).help("The __cluster_metadata-0 directory to read.");
        accessGroup.addArgument(new String[]{"--controllers", "-q"}).help("The controller.quorum.voters.");
        parser.addArgument(new String[]{"--offset", "-o"}).type(Long.TYPE).help("The (exclusive) offset to read up to");
        parser.addArgument(new String[]{"--config"}).type((ArgumentType)new FileArgumentType().verifyExists().verifyIsFile().verifyCanRead()).help("Path to property file containing a Kafka configuration");
        parser.addArgument(new String[]{"command"}).nargs("*").help("The command to run.");
        Namespace res = parser.parseArgsOrFail(argv);
        Properties configProps = MetadataShellTool.loadConfigProperties(res);
        File datadirArg = null;
        if (res.getString("directory") != null) {
            TopicPartition topicPartitionArg = Topic.CLUSTER_METADATA_TOPIC_PARTITION;
            Uuid topicArg = Uuid.METADATA_TOPIC_ID;
            datadirArg = new File(res.get("directory").toString()).getAbsoluteFile();
            KafkaScheduler schedulerArg = new KafkaScheduler(1, true, "scheduler", false);
            MetadataLogConfig configArg = new MetadataLogConfig(0x800000, 0x800000, 10000L, Long.MAX_VALUE, Long.MAX_VALUE, 0x800000, 0x800000, 60000L, 1);
            KafkaMetadataLog metadataLog = KafkaMetadataLog.createWithoutRecovery((TopicPartition)topicPartitionArg, (Uuid)topicArg, (File)datadirArg, (Time)Time.SYSTEM, (Metrics)new Metrics(), (Scheduler)schedulerArg, (MetadataLogConfig)configArg, l -> {}, o -> {});
            AbstractMap.SimpleEntry<KRaftVersion, VoterSet> kRaftVersionAndVoterSet = MetadataShellObserver.getKRaftVersionAndVoterSet((ReplicatedLog)metadataLog);
            kRaftVersion = kRaftVersionAndVoterSet.getKey();
            voterSet = kRaftVersionAndVoterSet.getValue();
            OptionalLong stopOffset = res.get("offset") != null ? OptionalLong.of(res.getLong("offset")) : OptionalLong.empty();
            source = new LocalMetadataLogReader((ReplicatedLog)metadataLog, stopOffset);
        } else if (res.getString("controllers") != null) {
            String clusterId = res.getString("cluster_id");
            if (clusterId == null || clusterId.isEmpty()) {
                throw new RuntimeException("You must provide --cluster-id when connecting directly to the controllers.");
            }
            source = MetadataShellObserver.create(res.getString("controllers"), clusterId, configProps);
            kRaftVersion = source.getKRaftVersion();
            voterSet = source.getVoterSet();
        } else {
            throw new RuntimeException("You must set either --directory or --controllers");
        }
        if (!kRaftVersion.isReconfigSupported()) {
            voterSet = null;
        }
        try (ShellSourceManager shellSourceManager = new ShellSourceManager(source, configProps, KafkaRaftServer$.MODULE$.configSchema(), Optional.ofNullable(datadirArg), kRaftVersion, Optional.ofNullable(voterSet));){
            shellSourceManager.start();
            List args = res.getList("command");
            if (args.isEmpty()) {
                System.out.println("Loading...");
                shellSourceManager.waitUntilCaughtUp();
                System.out.println("Starting...");
                try (InteractiveShell shell = new InteractiveShell(shellSourceManager.state());){
                    shell.runMainLoop();
                }
            }
            shellSourceManager.waitUntilCaughtUp();
            Commands commands = new Commands(false);
            try (PrintWriter writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)System.out, StandardCharsets.UTF_8)));){
                Commands.Handler handler = commands.parseCommand(args);
                handler.run(Optional.empty(), writer, shellSourceManager.state());
                writer.flush();
            }
            Exit.exit((int)0);
        }
        catch (Throwable e) {
            System.err.println("Unexpected error: " + (e.getMessage() == null ? "" : e.getMessage()));
            e.printStackTrace(System.err);
            Exit.exit((int)1);
        }
    }

    private static Properties loadConfigProperties(Namespace ns) throws IOException {
        Properties configProps = new Properties();
        File configFile = (File)ns.get("config");
        if (configFile != null) {
            try (FileInputStream fis = new FileInputStream(configFile);){
                configProps.load(fis);
            }
        }
        return configProps;
    }
}

