/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.protobuf;

import com.fasterxml.jackson.dataformat.protobuf.ProtobufUtil;
import java.io.IOException;
import java.io.OutputStream;

public class ByteAccumulator {
    protected final ByteAccumulator _parent;
    protected final byte[] _prefixBuffer;
    protected final int _prefixOffset;
    protected final int _typedTag;
    protected Segment _firstSegment;
    protected Segment _lastSegment;
    protected int _segmentBytes;
    protected int _parentStart;

    public ByteAccumulator(ByteAccumulator p, int typedTag, byte[] prefixBuffer, int prefixOffset, int parentStart) {
        this._parent = p;
        this._typedTag = typedTag;
        this._prefixBuffer = prefixBuffer;
        this._prefixOffset = prefixOffset;
        this._parentStart = parentStart;
    }

    public void append(byte[] buf, int offset, int len) {
        Segment s = new Segment(buf, offset, len);
        if (this._lastSegment == null) {
            this._firstSegment = this._lastSegment = s;
        } else {
            this._lastSegment = this._lastSegment.linkNext(s);
        }
        this._segmentBytes += len;
    }

    public ByteAccumulator finish(OutputStream out, byte[] input, int offset, int len) throws IOException {
        byte[] prefixBuf = this._prefixBuffer;
        int ptr = this._typedTag == -1 ? this._prefixOffset : ProtobufUtil.appendLengthLength(this._typedTag, prefixBuf, this._prefixOffset);
        int plen = this._segmentBytes + len;
        ptr = ProtobufUtil.appendLengthLength(plen, prefixBuf, ptr);
        int writeStart = this._parentStart;
        if (this._parent == null) {
            out.write(prefixBuf, writeStart, ptr - writeStart);
            for (Segment s = this._firstSegment; s != null; s = s.next()) {
                s.writeTo(out);
            }
            if (len > 0) {
                out.write(input, offset, len);
            }
        } else {
            this._parent.append(prefixBuf, writeStart, ptr - writeStart);
            if (this._firstSegment != null) {
                this._parent.appendAll(this._firstSegment, this._lastSegment, this._segmentBytes);
            }
            if (len > 0) {
                this._parent.append(input, offset, len);
            }
        }
        return this._parent;
    }

    public ByteAccumulator finish(OutputStream out, byte[] input) throws IOException {
        byte[] prefixBuf = this._prefixBuffer;
        int ptr = this._typedTag == -1 ? this._prefixOffset : ProtobufUtil.appendLengthLength(this._typedTag, prefixBuf, this._prefixOffset);
        int plen = this._segmentBytes;
        ptr = ProtobufUtil.appendLengthLength(plen, prefixBuf, ptr);
        int writeStart = this._parentStart;
        if (this._parent == null) {
            out.write(prefixBuf, writeStart, ptr - writeStart);
            for (Segment s = this._firstSegment; s != null; s = s.next()) {
                s.writeTo(out);
            }
        } else {
            this._parent.append(prefixBuf, writeStart, ptr - writeStart);
            if (this._firstSegment != null) {
                this._parent.appendAll(this._firstSegment, this._lastSegment, this._segmentBytes);
            }
        }
        return this._parent;
    }

    private void appendAll(Segment first, Segment last, int segmentBytes) {
        this._segmentBytes += segmentBytes;
        if (this._firstSegment == null) {
            this._firstSegment = first;
            this._lastSegment = last;
        } else {
            this._lastSegment.linkNext(first);
            this._lastSegment = last;
        }
    }

    private static final class Segment {
        private final byte[] _buffer;
        private final int _start;
        private final int _length;
        private Segment _next;

        public Segment(byte[] buffer, int start, int length) {
            this._buffer = buffer;
            this._start = start;
            this._length = length;
        }

        public Segment linkNext(Segment next) {
            this._next = next;
            return next;
        }

        public Segment next() {
            return this._next;
        }

        public void writeTo(OutputStream out) throws IOException {
            out.write(this._buffer, this._start, this._length);
        }
    }
}

