/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.serializers.protobuf;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.Message;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.SchemaProvider;
import io.confluent.kafka.schemaregistry.client.rest.entities.Metadata;
import io.confluent.kafka.schemaregistry.client.rest.entities.RuleMode;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.protobuf.MessageIndexes;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchema;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchemaProvider;
import io.confluent.kafka.schemaregistry.rules.RulePhase;
import io.confluent.kafka.schemaregistry.utils.BoundedConcurrentHashMap;
import io.confluent.kafka.serializers.AbstractKafkaSchemaSerDe;
import io.confluent.kafka.serializers.protobuf.KafkaProtobufDeserializerConfig;
import io.confluent.kafka.serializers.protobuf.ProtobufSchemaAndValue;
import io.confluent.kafka.serializers.schema.id.SchemaId;
import io.confluent.kafka.serializers.schema.id.SchemaIdDeserializer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.header.Headers;

public abstract class AbstractKafkaProtobufDeserializer<T extends Message>
extends AbstractKafkaSchemaSerDe {
    private static final int DEFAULT_CACHE_CAPACITY = 1000;
    protected Class<T> specificProtobufClass;
    protected Method parseMethod;
    protected boolean deriveType;
    private final Map<Pair<String, ProtobufSchema>, ProtobufSchema> schemaCache = new BoundedConcurrentHashMap(1000);

    protected void configure(KafkaProtobufDeserializerConfig config, Class<T> type) {
        this.configureClientProperties(config, (SchemaProvider)new ProtobufSchemaProvider());
        try {
            this.specificProtobufClass = type;
            if (this.specificProtobufClass != null && !this.specificProtobufClass.equals(Object.class)) {
                this.parseMethod = this.specificProtobufClass.getDeclaredMethod("parseFrom", ByteBuffer.class, ExtensionRegistryLite.class);
            }
            this.deriveType = config.getBoolean("derive.type");
        }
        catch (Exception e) {
            throw new ConfigException("Class " + this.specificProtobufClass.getCanonicalName() + " is not a valid protobuf message class", (Object)e);
        }
    }

    protected KafkaProtobufDeserializerConfig deserializerConfig(Map<String, ?> props) {
        try {
            return new KafkaProtobufDeserializerConfig(props);
        }
        catch (ConfigException e) {
            throw new ConfigException(e.getMessage());
        }
    }

    protected KafkaProtobufDeserializerConfig deserializerConfig(Properties props) {
        return new KafkaProtobufDeserializerConfig(props);
    }

    protected T deserialize(byte[] payload) throws SerializationException, InvalidConfigurationException {
        return (T)((Message)this.deserialize(false, null, this.isKey, payload));
    }

    protected Object deserialize(boolean includeSchemaAndVersion, String topic, Boolean isKey, byte[] payload) throws SerializationException, InvalidConfigurationException {
        return this.deserialize(includeSchemaAndVersion, topic, isKey, null, payload);
    }

    protected Object deserialize(boolean includeSchemaAndVersion, String topic, Boolean isKey, Headers headers, byte[] payload) throws SerializationException, InvalidConfigurationException {
        if (this.schemaRegistry == null) {
            throw new InvalidConfigurationException("SchemaRegistryClient not found. You need to configure the deserializer or use deserializer constructor with SchemaRegistryClient.");
        }
        if (payload == null) {
            return null;
        }
        SchemaId schemaId = new SchemaId("PROTOBUF");
        try {
            Object object;
            block38: {
                Object value;
                SchemaIdDeserializer schemaIdDeserializer;
                block36: {
                    block37: {
                        schemaIdDeserializer = this.schemaIdDeserializer(isKey);
                        try {
                            Object buf;
                            ByteBuffer buffer = schemaIdDeserializer.deserialize(topic, isKey.booleanValue(), headers, payload, schemaId);
                            String subject = isKey == null || this.strategyUsesSchema(isKey) ? this.getContextName(topic) : this.subjectName(topic, isKey, null);
                            ProtobufSchema schema = (ProtobufSchema)this.getSchemaBySchemaId(subject, schemaId);
                            MessageIndexes indexes = new MessageIndexes(schemaId.getMessageIndexes());
                            String name = schema.toMessageName(indexes);
                            schema = this.schemaWithName(schema, name);
                            if (isKey != null && this.strategyUsesSchema(isKey)) {
                                subject = this.subjectName(topic, isKey, schema);
                                schema = this.schemaForDeserialize(schemaId, schema, subject, isKey);
                            }
                            buffer = (buf = this.executeRules(subject, topic, headers, payload, RulePhase.ENCODING, RuleMode.READ, null, (ParsedSchema)schema, buffer)) instanceof byte[] ? ByteBuffer.wrap((byte[])buf) : (ByteBuffer)buf;
                            ProtobufSchema readerSchema = null;
                            if (this.metadata != null) {
                                readerSchema = (ProtobufSchema)this.getLatestWithMetadata(subject).getSchema();
                            } else if (this.useLatestVersion) {
                                readerSchema = (ProtobufSchema)this.lookupLatestVersion(subject, (ParsedSchema)schema, false).getSchema();
                            }
                            if (readerSchema != null && readerSchema.toDescriptor(name) != null) {
                                readerSchema = this.schemaWithName(readerSchema, name);
                            }
                            if (includeSchemaAndVersion || readerSchema != null) {
                                Integer version = this.schemaVersion(topic, isKey, schemaId, subject, schema, null);
                                schema = schema.copy(version);
                                schema = this.schemaWithName(schema, name);
                            }
                            List migrations = Collections.emptyList();
                            if (readerSchema != null) {
                                migrations = this.getMigrations(subject, (ParsedSchema)schema, (ParsedSchema)readerSchema);
                            }
                            int length = buffer.remaining();
                            int start = buffer.position() + buffer.arrayOffset();
                            Object message = null;
                            if (!migrations.isEmpty()) {
                                message = DynamicMessage.parseFrom((Descriptors.Descriptor)schema.toDescriptor(), (InputStream)new ByteArrayInputStream(buffer.array(), start, length), (ExtensionRegistry)ProtobufSchema.EXTENSION_REGISTRY);
                                message = this.executeMigrations(migrations, subject, topic, headers, message);
                                message = readerSchema.fromJson((JsonNode)message);
                            }
                            if (readerSchema != null) {
                                schema = readerSchema;
                            }
                            if (schema.ruleSet() != null && schema.ruleSet().hasRules(RulePhase.DOMAIN, RuleMode.READ)) {
                                if (message == null) {
                                    message = DynamicMessage.parseFrom((Descriptors.Descriptor)schema.toDescriptor(), (InputStream)new ByteArrayInputStream(buffer.array(), start, length), (ExtensionRegistry)ProtobufSchema.EXTENSION_REGISTRY);
                                }
                                message = this.executeRules(subject, topic, headers, payload, RuleMode.READ, null, (ParsedSchema)schema, message);
                            }
                            ByteBuffer protobufBytes = buffer;
                            if (message != null) {
                                protobufBytes = ByteBuffer.wrap(((Message)message).toByteArray());
                                length = buffer.limit();
                                start = 0;
                            }
                            if (this.parseMethod != null) {
                                try {
                                    value = this.parseMethod.invoke(null, protobufBytes, ProtobufSchema.EXTENSION_REGISTRY);
                                }
                                catch (Exception e) {
                                    throw new ConfigException("Not a valid protobuf builder", (Object)e);
                                }
                            } else if (this.deriveType) {
                                value = this.deriveType(protobufBytes, schema);
                            } else {
                                Descriptors.Descriptor descriptor = schema.toDescriptor();
                                if (descriptor == null) {
                                    throw new SerializationException("Could not find descriptor with name " + schema.name());
                                }
                                value = DynamicMessage.parseFrom((Descriptors.Descriptor)descriptor, (InputStream)new ByteArrayInputStream(protobufBytes.array(), start, length), (ExtensionRegistry)ProtobufSchema.EXTENSION_REGISTRY);
                            }
                            if (!includeSchemaAndVersion) break block36;
                            object = new ProtobufSchemaAndValue(schema, value);
                            if (schemaIdDeserializer == null) break block37;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (schemaIdDeserializer != null) {
                                    try {
                                        schemaIdDeserializer.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            catch (InterruptedIOException e) {
                                throw new TimeoutException("Error deserializing Protobuf message for id " + String.valueOf(schemaId), (Throwable)e);
                            }
                            catch (IOException | RuntimeException e) {
                                throw new SerializationException("Error deserializing Protobuf message for id " + String.valueOf(schemaId), (Throwable)e);
                            }
                            catch (RestClientException e) {
                                throw AbstractKafkaProtobufDeserializer.toKafkaException((RestClientException)e, (String)("Error retrieving Protobuf schema for id " + String.valueOf(schemaId)));
                            }
                        }
                        schemaIdDeserializer.close();
                    }
                    return object;
                }
                object = value;
                if (schemaIdDeserializer == null) break block38;
                schemaIdDeserializer.close();
            }
            return object;
        }
        finally {
            this.postOp(payload);
        }
    }

    private ProtobufSchema schemaWithName(ProtobufSchema schema, String name) {
        Pair<String, ProtobufSchema> cacheKey = new Pair<String, ProtobufSchema>(name, schema);
        return this.schemaCache.computeIfAbsent(cacheKey, k -> schema.copy(name));
    }

    private Object deriveType(ByteBuffer buffer, ProtobufSchema schema) {
        String clsName = schema.fullName();
        if (clsName == null) {
            throw new SerializationException("If `derive.type` is true, then either `java_outer_classname` or `java_multiple_files = true` must be set in the Protobuf schema");
        }
        try {
            Class<?> cls = Class.forName(clsName);
            Method parseMethod = cls.getDeclaredMethod("parseFrom", ByteBuffer.class, ExtensionRegistryLite.class);
            return parseMethod.invoke(null, buffer, ProtobufSchema.EXTENSION_REGISTRY);
        }
        catch (ClassNotFoundException e) {
            throw new SerializationException("Class " + clsName + " could not be found.");
        }
        catch (NoSuchMethodException e) {
            throw new SerializationException("Class " + clsName + " is not a valid protobuf message class", (Throwable)e);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new SerializationException("Not a valid protobuf builder");
        }
    }

    private Integer schemaVersion(String topic, boolean isKey, SchemaId schemaId, String subject, ProtobufSchema schema, Object value) throws IOException, RestClientException {
        Integer version = null;
        ProtobufSchema subjectSchema = (ProtobufSchema)this.getSchemaBySchemaId(subject, schemaId);
        Metadata metadata = subjectSchema.metadata();
        if (metadata != null) {
            version = metadata.getConfluentVersionNumber();
        }
        if (version == null) {
            version = this.schemaRegistry.getVersion(subject, (ParsedSchema)subjectSchema);
        }
        return version;
    }

    private String subjectName(String topic, boolean isKey, ProtobufSchema schemaFromRegistry) {
        return this.getSubjectName(topic, isKey, null, (ParsedSchema)schemaFromRegistry);
    }

    private ProtobufSchema schemaForDeserialize(SchemaId schemaId, ProtobufSchema schemaFromRegistry, String subject, boolean isKey) throws IOException, RestClientException {
        return (ProtobufSchema)this.getSchemaBySchemaId(subject, schemaId);
    }

    protected ProtobufSchemaAndValue deserializeWithSchemaAndVersion(String topic, boolean isKey, Headers headers, byte[] payload) throws SerializationException {
        return (ProtobufSchemaAndValue)this.deserialize(true, topic, isKey, headers, payload);
    }

    static class Pair<K, V> {
        private final K key;
        private final V value;

        public Pair(K key, V value) {
            this.key = key;
            this.value = value;
        }

        public K getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Pair pair = (Pair)o;
            return Objects.equals(this.key, pair.key) && Objects.equals(this.value, pair.value);
        }

        public int hashCode() {
            return Objects.hash(this.key, this.value);
        }

        public String toString() {
            return "Pair{key=" + String.valueOf(this.key) + ", value=" + String.valueOf(this.value) + "}";
        }
    }
}

