/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.serializers.protobuf;

import com.google.protobuf.Message;
import com.squareup.wire.schema.internal.parser.ProtoFileElement;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.SchemaProvider;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.entities.Schema;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.RegisterSchemaResponse;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchema;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchemaProvider;
import io.confluent.kafka.serializers.AbstractKafkaSchemaSerDe;
import io.confluent.kafka.serializers.protobuf.KafkaProtobufSerializerConfig;
import io.confluent.kafka.serializers.subject.strategy.ReferenceSubjectNameStrategy;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.header.Headers;

public abstract class AbstractKafkaProtobufSerializer<T extends Message>
extends AbstractKafkaSchemaSerDe {
    protected boolean normalizeSchema;
    protected boolean autoRegisterSchema;
    protected boolean propagateSchemaTags;
    protected boolean onlyLookupReferencesBySchema;
    protected int useSchemaId = -1;
    protected boolean idCompatStrict;
    protected boolean latestCompatStrict;
    protected String schemaFormat;
    protected boolean skipKnownTypes;
    protected ReferenceSubjectNameStrategy referenceSubjectNameStrategy;

    protected void configure(KafkaProtobufSerializerConfig config) {
        this.configureClientProperties(config, (SchemaProvider)new ProtobufSchemaProvider());
        this.normalizeSchema = config.normalizeSchema();
        this.autoRegisterSchema = config.autoRegisterSchema();
        this.propagateSchemaTags = config.propagateSchemaTags();
        this.onlyLookupReferencesBySchema = config.onlyLookupReferencesBySchema();
        this.useSchemaId = config.useSchemaId();
        this.idCompatStrict = config.getIdCompatibilityStrict();
        this.latestCompatStrict = config.getLatestCompatibilityStrict();
        this.schemaFormat = config.getSchemaFormat();
        this.skipKnownTypes = config.skipKnownTypes();
        this.referenceSubjectNameStrategy = config.referenceSubjectNameStrategyInstance();
    }

    protected KafkaProtobufSerializerConfig serializerConfig(Map<String, ?> props) {
        try {
            return new KafkaProtobufSerializerConfig(props);
        }
        catch (ConfigException e) {
            throw new ConfigException(e.getMessage());
        }
    }

    protected byte[] serializeImpl(String subject, String topic, boolean isKey, T object, ProtobufSchema schema) throws SerializationException, InvalidConfigurationException {
        return this.serializeImpl(subject, topic, isKey, null, object, schema);
    }

    /*
     * Exception decompiling
     */
    protected byte[] serializeImpl(String subject, String topic, boolean isKey, Headers headers, T object, ProtobufSchema schema) throws SerializationException, InvalidConfigurationException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static ProtobufSchema resolveDependencies(SchemaRegistryClient schemaRegistry, boolean autoRegisterSchema, boolean useLatestVersion, boolean latestCompatStrict, Map<AbstractKafkaSchemaSerDe.SubjectSchema, AbstractKafkaSchemaSerDe.ExtendedSchema> latestVersions, ReferenceSubjectNameStrategy strategy, String topic, boolean isKey, ProtobufSchema schema) throws IOException, RestClientException {
        return AbstractKafkaProtobufSerializer.resolveDependencies(schemaRegistry, autoRegisterSchema, useLatestVersion, latestCompatStrict, latestVersions, true, strategy, topic, isKey, schema);
    }

    public static ProtobufSchema resolveDependencies(SchemaRegistryClient schemaRegistry, boolean autoRegisterSchema, boolean useLatestVersion, boolean latestCompatStrict, Map<AbstractKafkaSchemaSerDe.SubjectSchema, AbstractKafkaSchemaSerDe.ExtendedSchema> latestVersions, boolean skipKnownTypes, ReferenceSubjectNameStrategy strategy, String topic, boolean isKey, ProtobufSchema schema) throws IOException, RestClientException {
        return AbstractKafkaProtobufSerializer.resolveDependencies(schemaRegistry, false, autoRegisterSchema, useLatestVersion, latestCompatStrict, latestVersions, skipKnownTypes, strategy, topic, isKey, schema);
    }

    public static ProtobufSchema resolveDependencies(SchemaRegistryClient schemaRegistry, boolean normalizeSchema, boolean autoRegisterSchema, boolean useLatestVersion, boolean latestCompatStrict, Map<AbstractKafkaSchemaSerDe.SubjectSchema, AbstractKafkaSchemaSerDe.ExtendedSchema> latestVersions, boolean skipKnownTypes, ReferenceSubjectNameStrategy strategy, String topic, boolean isKey, ProtobufSchema schema) throws IOException, RestClientException {
        return AbstractKafkaProtobufSerializer.resolveDependencies(schemaRegistry, normalizeSchema, autoRegisterSchema, false, useLatestVersion, latestCompatStrict, latestVersions, skipKnownTypes, strategy, topic, isKey, schema);
    }

    public static ProtobufSchema resolveDependencies(SchemaRegistryClient schemaRegistry, boolean normalizeSchema, boolean autoRegisterSchema, boolean propagateSchemaTags, boolean useLatestVersion, boolean latestCompatStrict, Map<AbstractKafkaSchemaSerDe.SubjectSchema, AbstractKafkaSchemaSerDe.ExtendedSchema> latestVersions, boolean skipKnownTypes, ReferenceSubjectNameStrategy strategy, String topic, boolean isKey, ProtobufSchema schema) throws IOException, RestClientException {
        if (schema.dependencies().isEmpty() || !schema.references().isEmpty()) {
            return schema;
        }
        HashMap<String, ProtoFileElement> dependencies = new HashMap<String, ProtoFileElement>(schema.dependencies());
        Schema s = AbstractKafkaProtobufSerializer.resolveDependencies(schemaRegistry, normalizeSchema, autoRegisterSchema, propagateSchemaTags, useLatestVersion, latestCompatStrict, latestVersions, skipKnownTypes, strategy, topic, isKey, null, schema.rawSchema(), dependencies);
        return schema.copy(s.getReferences(), dependencies);
    }

    private static Schema resolveDependencies(SchemaRegistryClient schemaRegistry, boolean normalizeSchema, boolean autoRegisterSchema, boolean propagateSchemaTags, boolean useLatestVersion, boolean latestCompatStrict, Map<AbstractKafkaSchemaSerDe.SubjectSchema, AbstractKafkaSchemaSerDe.ExtendedSchema> latestVersions, boolean skipKnownTypes, ReferenceSubjectNameStrategy strategy, String topic, boolean isKey, String name, ProtoFileElement protoFileElement, Map<String, ProtoFileElement> dependencies) throws IOException, RestClientException {
        String subject;
        Schema subschema;
        ArrayList<SchemaReference> references = new ArrayList<SchemaReference>();
        for (String dep : protoFileElement.getImports()) {
            if (skipKnownTypes && ProtobufSchema.knownTypes().contains(dep)) {
                dependencies.remove(dep);
                continue;
            }
            subschema = AbstractKafkaProtobufSerializer.resolveDependencies(schemaRegistry, normalizeSchema, autoRegisterSchema, propagateSchemaTags, useLatestVersion, latestCompatStrict, latestVersions, skipKnownTypes, strategy, topic, isKey, dep, dependencies.get(dep), dependencies);
            references.add(new SchemaReference(dep, subschema.getSubject(), subschema.getVersion()));
        }
        for (String dep : protoFileElement.getPublicImports()) {
            if (skipKnownTypes && ProtobufSchema.knownTypes().contains(dep)) {
                dependencies.remove(dep);
                continue;
            }
            subschema = AbstractKafkaProtobufSerializer.resolveDependencies(schemaRegistry, normalizeSchema, autoRegisterSchema, propagateSchemaTags, useLatestVersion, latestCompatStrict, latestVersions, skipKnownTypes, strategy, topic, isKey, dep, dependencies.get(dep), dependencies);
            references.add(new SchemaReference(dep, subschema.getSubject(), subschema.getVersion()));
        }
        ProtobufSchema schema = new ProtobufSchema(protoFileElement, references, dependencies);
        Integer id = null;
        Integer version = null;
        String string = subject = name != null ? strategy.subjectName(name, topic, isKey, (ParsedSchema)schema) : null;
        if (subject != null) {
            if (autoRegisterSchema) {
                Optional optSchema;
                RegisterSchemaResponse response = schemaRegistry.registerWithResponse(subject, (ParsedSchema)schema, normalizeSchema, propagateSchemaTags);
                if (response.getSchema() != null && (optSchema = schemaRegistry.parseSchema(new Schema(subject, response))).isPresent()) {
                    schema = (ProtobufSchema)optSchema.get();
                    schema = schema.copy(response.getVersion());
                }
                id = response.getId();
                version = schemaRegistry.getVersion(subject, (ParsedSchema)schema, normalizeSchema);
            } else if (useLatestVersion) {
                AbstractKafkaSchemaSerDe.ExtendedSchema extendedSchema = AbstractKafkaProtobufSerializer.lookupLatestVersion((SchemaRegistryClient)schemaRegistry, (String)subject, (ParsedSchema)schema, latestVersions, (boolean)latestCompatStrict);
                schema = (ProtobufSchema)extendedSchema.getSchema();
                id = extendedSchema.getId();
                version = extendedSchema.getVersion();
            } else {
                id = schemaRegistry.getId(subject, (ParsedSchema)schema, normalizeSchema);
                version = schemaRegistry.getVersion(subject, (ParsedSchema)schema, normalizeSchema);
            }
        }
        return new Schema(subject, version, id, (ParsedSchema)schema);
    }
}

