/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.help.sections.factories;

import com.github.rvesse.airline.help.sections.HelpSection;
import com.github.rvesse.airline.help.sections.factories.HelpSectionFactory;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;

public class HelpSectionRegistry {
    private static final Map<Class<? extends Annotation>, HelpSectionFactory> FACTORIES = new HashMap<Class<? extends Annotation>, HelpSectionFactory>();
    private static boolean init = false;

    static synchronized void init() {
        if (init) {
            return;
        }
        ServiceLoader<HelpSectionFactory> helpSectionFactories = ServiceLoader.load(HelpSectionFactory.class);
        for (HelpSectionFactory factory : helpSectionFactories) {
            for (Class<? extends Annotation> cls : factory.supportedAnnotations()) {
                FACTORIES.put(cls, factory);
            }
        }
        init = true;
    }

    public static synchronized void reset() {
        init = false;
        FACTORIES.clear();
        HelpSectionRegistry.init();
    }

    public static void addFactory(Class<? extends Annotation> cls, HelpSectionFactory factory) {
        if (cls == null) {
            throw new NullPointerException("cls cannot be null");
        }
        FACTORIES.put(cls, factory);
    }

    public static Set<Class<? extends Annotation>> getAnnotationClasses() {
        return FACTORIES.keySet();
    }

    public static HelpSection getHelpSection(Class<? extends Annotation> cls, Annotation annotation) {
        HelpSectionFactory factory = FACTORIES.get(cls);
        if (factory != null) {
            return factory.createSection(annotation);
        }
        return null;
    }

    static {
        HelpSectionRegistry.init();
    }
}

