/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.api.auth;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextOutputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jetty.security.jaas.callback.DefaultCallbackHandler;
import org.eclipse.jetty.security.jaas.callback.ObjectCallback;

public class BasicCallbackHandler
extends DefaultCallbackHandler {
    private static final Logger log = LogManager.getLogger(BasicCallbackHandler.class);

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        block5: for (Callback callback : callbacks) {
            if (callback instanceof NameCallback) {
                NameCallback nc = (NameCallback)callback;
                nc.setName(this.getUserName());
                continue;
            }
            if (callback instanceof ObjectCallback) {
                ObjectCallback oc = (ObjectCallback)callback;
                oc.setObject(this.getCredential());
                continue;
            }
            if (callback instanceof PasswordCallback) {
                PasswordCallback pc = (PasswordCallback)callback;
                pc.setPassword(((String)this.getCredential()).toCharArray());
                continue;
            }
            if (!(callback instanceof TextOutputCallback)) continue;
            TextOutputCallback toc = (TextOutputCallback)callback;
            switch (toc.getMessageType()) {
                case 2: {
                    log.error(toc.getMessage());
                    continue block5;
                }
                case 1: {
                    log.warn(toc.getMessage());
                    continue block5;
                }
                case 0: {
                    log.info(toc.getMessage());
                    continue block5;
                }
                default: {
                    throw new IOException("Unsupported message type: " + toc.getMessageType());
                }
            }
        }
    }
}

