/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.api.auth;

import io.confluent.ksql.api.auth.ApiUser;
import io.confluent.ksql.security.DefaultKsqlPrincipal;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpConnection;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.AuthProvider;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.authorization.Authorization;
import io.vertx.ext.web.RoutingContext;
import java.security.Principal;
import java.util.Objects;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;

public class SystemAuthenticationHandler
implements Handler<RoutingContext> {
    public void handle(RoutingContext routingContext) {
        HttpConnection httpConnection = routingContext.request().connection();
        if (!httpConnection.isSsl()) {
            throw new IllegalStateException("Should only have ssl connections");
        }
        Principal peerPrincipal = SystemAuthenticationHandler.getPeerPrincipal(httpConnection.sslSession());
        routingContext.setUser((User)new SystemUser(peerPrincipal));
        routingContext.next();
    }

    private static Principal getPeerPrincipal(SSLSession sslSession) {
        try {
            return sslSession.getPeerPrincipal();
        }
        catch (SSLPeerUnverifiedException e) {
            throw new IllegalStateException("Peer should always be verified", e);
        }
    }

    public static boolean isAuthenticatedAsSystemUser(RoutingContext routingContext) {
        User user = routingContext.user();
        return user instanceof SystemUser;
    }

    private static class SystemUser
    implements ApiUser {
        private final DefaultKsqlPrincipal principal;

        SystemUser(Principal principal) {
            Objects.requireNonNull(principal);
            this.principal = principal instanceof DefaultKsqlPrincipal ? (DefaultKsqlPrincipal)principal : new DefaultKsqlPrincipal(principal);
        }

        public JsonObject attributes() {
            throw new UnsupportedOperationException();
        }

        public User isAuthorized(Authorization authority, Handler<AsyncResult<Boolean>> resultHandler) {
            throw new UnsupportedOperationException();
        }

        public User isAuthorized(String s, Handler<AsyncResult<Boolean>> handler) {
            throw new UnsupportedOperationException();
        }

        public User clearCache() {
            throw new UnsupportedOperationException();
        }

        public JsonObject principal() {
            throw new UnsupportedOperationException();
        }

        public void setAuthProvider(AuthProvider authProvider) {
            throw new UnsupportedOperationException();
        }

        public User merge(User other) {
            throw new UnsupportedOperationException();
        }

        @Override
        public DefaultKsqlPrincipal getPrincipal() {
            return this.principal;
        }
    }
}

