/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.api.impl;

import io.confluent.ksql.api.server.KsqlApiException;
import io.confluent.ksql.parser.tree.PrintTopic;
import io.confluent.ksql.reactive.BasePublisher;
import io.confluent.ksql.rest.Errors;
import io.confluent.ksql.rest.server.resources.streaming.PrintTopicUtil;
import io.confluent.ksql.rest.server.resources.streaming.RecordFormatter;
import io.confluent.ksql.services.ServiceContext;
import io.confluent.ksql.util.KsqlConfig;
import io.confluent.ksql.util.KsqlException;
import io.confluent.ksql.util.VertxUtils;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.WorkerExecutor;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.utils.Bytes;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BlockingPrintPublisher
extends BasePublisher<String> {
    private static final Logger log = LogManager.getLogger(BlockingPrintPublisher.class);
    private static final Duration POLL_TIMEOUT = Duration.ofMillis(5000L);
    public static final int SEND_MAX_BATCH_SIZE = 200;
    private final WorkerExecutor workerExecutor;
    private final KafkaConsumer<Bytes, Bytes> topicConsumer;
    private final PrintTopic printTopic;
    private final int limit;
    private final long interval;
    private final RecordFormatter formatter;
    private volatile boolean closed;
    private volatile boolean started;

    public BlockingPrintPublisher(Context ctx, WorkerExecutor workerExecutor, ServiceContext serviceContext, KsqlConfig ksqlConfig, Map<String, Object> consumerProperties, PrintTopic printTopic) {
        super(ctx);
        this.workerExecutor = Objects.requireNonNull(workerExecutor);
        this.printTopic = printTopic;
        this.limit = printTopic.getLimit().orElse(Integer.MAX_VALUE);
        this.interval = printTopic.getIntervalValue();
        this.formatter = new RecordFormatter(serviceContext.getSchemaRegistryClient(), printTopic.getTopic());
        this.topicConsumer = this.createTopicConsumer(serviceContext, ksqlConfig, consumerProperties, printTopic);
    }

    public Future<Void> close() {
        if (this.closed) {
            return Future.succeededFuture();
        }
        this.closed = true;
        this.ctx.runOnContext(v -> this.sendComplete());
        return super.close();
    }

    protected void maybeSend() {
        this.executeOnWorker(this::doSend);
    }

    protected void afterSubscribe() {
        if (!this.started) {
            this.started = true;
        }
    }

    public void startFromWorkerThread() {
        VertxUtils.checkIsWorker();
        this.started = true;
    }

    private void executeOnWorker(Runnable runnable) {
        this.workerExecutor.executeBlocking(p -> runnable.run(), false, ar -> {
            if (ar.failed()) {
                log.error("Failed to close print", ar.cause());
            }
        });
    }

    private void doSend() {
        VertxUtils.checkIsWorker();
        int messagesWritten = 0;
        int messagesPolled = 0;
        block0: while (!this.isClosed() && this.getDemand() > 0L && messagesWritten < this.limit) {
            ConsumerRecords records = this.topicConsumer.poll(POLL_TIMEOUT);
            if (records.isEmpty()) continue;
            List<String> formattedRecords = this.formatter.format(records.records(this.printTopic.getTopic()));
            for (String message : formattedRecords) {
                if ((long)messagesPolled++ % this.interval == 0L) {
                    ++messagesWritten;
                    this.doOnNext(message);
                }
                if (messagesWritten >= this.limit) {
                    this.ctx.runOnContext(v -> this.sendComplete());
                    continue block0;
                }
                if (messagesWritten < 200) continue;
                this.ctx.runOnContext(v -> this.doSend());
                continue block0;
            }
        }
        if (this.isClosed()) {
            this.topicConsumer.close();
        }
    }

    private KafkaConsumer<Bytes, Bytes> createTopicConsumer(ServiceContext serviceContext, KsqlConfig ksqlConfig, Map<String, Object> consumerProperties, PrintTopic printTopic) {
        try {
            boolean topicExists = ((Set)serviceContext.getAdminClient().listTopics().names().get()).stream().anyMatch(topicName -> topicName.equalsIgnoreCase(printTopic.getTopic()));
            if (!topicExists) {
                throw new KsqlApiException("Topic does not exist: " + printTopic.getTopic(), Errors.ERROR_CODE_BAD_STATEMENT);
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw new KsqlException("Could not list existing kafka topics" + String.valueOf(e));
        }
        Map<String, Object> ksqlStreamConfigProps = this.overrideDefaultKsqlStreamConfigProps(ksqlConfig);
        Map<String, Object> finalConsumerProperties = this.populateKsqlStreamConfigProps(ksqlStreamConfigProps, consumerProperties);
        return PrintTopicUtil.createTopicConsumer(serviceContext, finalConsumerProperties, printTopic);
    }

    private Map<String, Object> populateKsqlStreamConfigProps(Map<String, Object> ksqlConfig, Map<String, Object> properties) {
        HashMap<String, Object> consumerProperties = new HashMap<String, Object>(ksqlConfig);
        consumerProperties.putAll(properties);
        return consumerProperties;
    }

    private Map<String, Object> overrideDefaultKsqlStreamConfigProps(KsqlConfig ksqlConfig) {
        HashMap<String, Object> overriddenProperties = new HashMap<String, Object>(ksqlConfig.getKsqlStreamConfigProps());
        overriddenProperties.put("auto.offset.reset", "latest");
        return overriddenProperties;
    }

    private boolean isClosed() {
        return this.closed;
    }
}

