/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.api.impl;

import io.confluent.ksql.GenericKey;
import io.confluent.ksql.GenericRow;
import io.confluent.ksql.api.server.KsqlApiException;
import io.confluent.ksql.rest.Errors;
import io.confluent.ksql.schema.ksql.Column;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.schema.ksql.SqlValueCoercer;
import io.confluent.ksql.schema.ksql.types.SqlBaseType;
import io.confluent.ksql.schema.ksql.types.SqlType;
import io.confluent.ksql.util.JsonUtil;
import io.vertx.core.json.JsonObject;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;

public final class KeyValueExtractor {
    private KeyValueExtractor() {
    }

    public static GenericKey extractKey(JsonObject values, LogicalSchema logicalSchema, SqlValueCoercer sqlValueCoercer) {
        List keyColumns = logicalSchema.key();
        GenericKey.Builder builder = GenericKey.builder((LogicalSchema)logicalSchema);
        for (Column keyColumn : keyColumns) {
            Object value = values.getValue(keyColumn.name().text());
            if (value == null) {
                throw new KsqlApiException("Key field must be specified: " + keyColumn.name().text(), Errors.ERROR_CODE_BAD_REQUEST);
            }
            Object coercedValue = KeyValueExtractor.coerceObject(value, keyColumn.type(), sqlValueCoercer);
            builder.append(coercedValue);
        }
        return builder.build();
    }

    public static GenericRow extractValues(JsonObject values, LogicalSchema logicalSchema, SqlValueCoercer sqlValueCoercer) {
        List valColumns = logicalSchema.value();
        ArrayList<Object> vals = new ArrayList<Object>(valColumns.size());
        for (Column column : valColumns) {
            String colName = column.name().text();
            Object val = column.type().baseType() == SqlBaseType.BYTES ? KeyValueExtractor.decodeJsonBytes((String)values.getValue(colName)) : values.getValue(colName);
            Object coercedValue = val == null ? null : KeyValueExtractor.coerceObject(val, column.type(), sqlValueCoercer);
            vals.add(coercedValue);
        }
        return GenericRow.fromList(vals);
    }

    private static ByteBuffer decodeJsonBytes(String value) {
        return value != null ? ByteBuffer.wrap(Base64.getDecoder().decode(value)) : null;
    }

    static JsonObject convertColumnNameCase(JsonObject jsonObjectWithCaseInsensitiveFields) {
        try {
            return JsonUtil.convertJsonFieldCase((JsonObject)jsonObjectWithCaseInsensitiveFields);
        }
        catch (IllegalArgumentException e) {
            throw new KsqlApiException(e.getMessage(), Errors.ERROR_CODE_BAD_REQUEST);
        }
    }

    private static Object coerceObject(Object value, SqlType sqlType, SqlValueCoercer sqlValueCoercer) {
        return sqlValueCoercer.coerce(value, sqlType).orElseThrow(() -> new KsqlApiException(String.format("Can't coerce a field of type %s into type %s", value.getClass(), sqlType), Errors.ERROR_CODE_BAD_REQUEST)).orElse(null);
    }
}

