/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.api.server;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.api.server.KsqlApiException;
import io.confluent.ksql.api.server.PushQueryHolder;
import io.confluent.ksql.api.server.Server;
import io.confluent.ksql.api.server.ServerUtils;
import io.confluent.ksql.rest.Errors;
import io.confluent.ksql.rest.entity.CloseQueryArgs;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;
import java.util.Objects;
import java.util.Optional;

public class CloseQueryHandler
implements Handler<RoutingContext> {
    private final Server server;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public CloseQueryHandler(Server server) {
        this.server = Objects.requireNonNull(server);
    }

    public void handle(RoutingContext routingContext) {
        Optional<CloseQueryArgs> closeQueryArgs = ServerUtils.deserialiseObject(routingContext.getBody(), routingContext, CloseQueryArgs.class);
        if (!closeQueryArgs.isPresent()) {
            return;
        }
        Optional<PushQueryHolder> query = this.server.removeQuery(closeQueryArgs.get().queryId);
        if (!query.isPresent()) {
            routingContext.fail(HttpResponseStatus.BAD_REQUEST.code(), (Throwable)((Object)new KsqlApiException("No query with id " + String.valueOf(closeQueryArgs.get().queryId), Errors.ERROR_CODE_BAD_REQUEST)));
            return;
        }
        query.get().close(false);
        routingContext.response().end();
    }
}

