/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.api.server;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.api.server.PushQueryHolder;
import io.confluent.ksql.api.server.Server;
import io.confluent.ksql.api.spi.QueryPublisher;
import io.confluent.ksql.util.VertxUtils;
import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpConnection;
import io.vertx.core.http.HttpServerRequest;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class ConnectionQueryManager {
    private final Context context;
    private final Server server;
    private final Map<HttpConnection, ConnectionQueries> connectionsMap = new HashMap<HttpConnection, ConnectionQueries>();

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public ConnectionQueryManager(Context context, Server server) {
        this.context = Objects.requireNonNull(context);
        this.server = Objects.requireNonNull(server);
    }

    public PushQueryHolder createApiQuery(QueryPublisher queryPublisher, HttpServerRequest request) {
        this.checkContext();
        ConnectionQueries connectionQueries = this.getConnectionQueries(request);
        PushQueryHolder query = new PushQueryHolder(this.server, queryPublisher, connectionQueries::removeQuery);
        this.server.registerQuery(query);
        connectionQueries.addQuery(query);
        return query;
    }

    private ConnectionQueries getConnectionQueries(HttpServerRequest request) {
        HttpConnection conn = request.connection();
        return this.connectionsMap.computeIfAbsent(conn, x$0 -> new ConnectionQueries((HttpConnection)x$0));
    }

    private void checkContext() {
        VertxUtils.checkContext((Context)this.context);
    }

    private class ConnectionQueries
    implements Handler<Void> {
        private final HttpConnection conn;
        private final Set<PushQueryHolder> queries = new HashSet<PushQueryHolder>();

        ConnectionQueries(HttpConnection conn) {
            this.conn = Objects.requireNonNull(conn);
            conn.closeHandler((Handler)this);
            ConnectionQueryManager.this.server.registerQueryConnection(conn);
        }

        void addQuery(PushQueryHolder query) {
            ConnectionQueryManager.this.checkContext();
            this.queries.add(Objects.requireNonNull(query));
        }

        void removeQuery(PushQueryHolder query) {
            ConnectionQueryManager.this.checkContext();
            this.queries.remove(Objects.requireNonNull(query));
        }

        public void handle(Void v) {
            ConnectionQueryManager.this.checkContext();
            for (PushQueryHolder query : this.queries) {
                query.close();
            }
            ConnectionQueryManager.this.connectionsMap.remove(this.conn);
            ConnectionQueryManager.this.server.removeQueryConnection(this.conn);
        }
    }
}

