/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.api.server;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.api.server.InsertsStreamResponseWriter;
import io.confluent.ksql.api.server.ServerUtils;
import io.confluent.ksql.rest.entity.InsertAck;
import io.confluent.ksql.rest.entity.InsertError;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.json.JsonObject;
import java.util.Objects;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DelimitedInsertsStreamResponseWriter
implements InsertsStreamResponseWriter {
    private static final Logger LOG = LogManager.getLogger(DelimitedInsertsStreamResponseWriter.class);
    private static final Buffer ACK_RESPONSE_LINE = new JsonObject().put("status", (Object)"ok").toBuffer().appendString("\n");
    private final HttpServerResponse response;
    private final UUID uuid;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public DelimitedInsertsStreamResponseWriter(HttpServerResponse response, UUID uuid) {
        this.response = Objects.requireNonNull(response);
        this.uuid = uuid;
    }

    @Override
    public InsertsStreamResponseWriter writeInsertResponse(InsertAck insertAck) {
        this.response.write((Object)ServerUtils.serializeObject(insertAck).appendString("\n"));
        return this;
    }

    @Override
    public InsertsStreamResponseWriter writeError(InsertError error) {
        this.response.write((Object)ServerUtils.serializeObject(error).appendString("\n"));
        return this;
    }

    @Override
    public void end() {
        LOG.debug("({}) Ending response for insert stream", (Object)this.uuid);
        this.response.end();
    }
}

