/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.api.server;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.GenericRow;
import io.confluent.ksql.api.server.QueryStreamResponseWriter;
import io.confluent.ksql.api.server.ServerUtils;
import io.confluent.ksql.rest.entity.ConsistencyToken;
import io.confluent.ksql.rest.entity.KsqlErrorMessage;
import io.confluent.ksql.rest.entity.PushContinuationToken;
import io.confluent.ksql.rest.entity.QueryResponseMetadata;
import io.confluent.ksql.util.KeyValue;
import io.confluent.ksql.util.KeyValueMetadata;
import io.vertx.core.http.HttpServerResponse;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DelimitedQueryStreamResponseWriter
implements QueryStreamResponseWriter {
    private static final Logger LOG = LogManager.getLogger(DelimitedQueryStreamResponseWriter.class);
    private final HttpServerResponse response;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public DelimitedQueryStreamResponseWriter(HttpServerResponse response) {
        this.response = Objects.requireNonNull(response);
    }

    @Override
    public QueryStreamResponseWriter writeMetadata(QueryResponseMetadata metaData) {
        this.response.write((Object)ServerUtils.serializeObject(metaData).appendString("\n"));
        return this;
    }

    @Override
    public QueryStreamResponseWriter writeRow(KeyValueMetadata<List<?>, GenericRow> keyValueMetadata) {
        KeyValue keyValue = keyValueMetadata.getKeyValue();
        if (keyValue.value() == null) {
            LOG.warn("Dropped tombstone. Not currently supported");
        } else {
            this.response.write((Object)ServerUtils.serializeObject(((GenericRow)keyValue.value()).values()).appendString("\n"));
        }
        return this;
    }

    @Override
    public QueryStreamResponseWriter writeContinuationToken(PushContinuationToken pushContinuationToken) {
        this.response.write((Object)ServerUtils.serializeObject(pushContinuationToken).appendString("\n"));
        return this;
    }

    @Override
    public QueryStreamResponseWriter writeError(KsqlErrorMessage error) {
        this.response.write((Object)ServerUtils.serializeObject(error).appendString("\n"));
        return this;
    }

    @Override
    public QueryStreamResponseWriter writeConsistencyToken(ConsistencyToken consistencyToken) {
        this.response.write((Object)ServerUtils.serializeObject(consistencyToken).appendString("\n"));
        return this;
    }

    @Override
    public QueryStreamResponseWriter writeCompletionMessage() {
        return this;
    }

    @Override
    public QueryStreamResponseWriter writeLimitMessage() {
        return this;
    }

    @Override
    public void end() {
        this.response.end();
    }
}

