/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.api.server;

import io.confluent.ksql.api.server.ServerUtils;
import io.confluent.ksql.rest.server.KsqlRestConfig;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpMethod;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.CorsHandler;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;

public class KsqlCorsHandler
implements Handler<RoutingContext> {
    private static final List<String> DEFAULT_ALLOWED_METHODS = Arrays.asList("GET", "POST", "HEAD");
    private static final List<String> DEFAULT_ALLOWED_HEADERS = Arrays.asList("X-Requested-With", "Content-Type", "Accept", "Origin");
    private static final List<String> EXCLUDED_PATH_PREFIXES = Collections.singletonList("/ws/");
    private final CorsHandler corsHandler;

    static void setupCorsHandler(KsqlRestConfig ksqlRestConfig, Router router) {
        String allowedOrigins = ksqlRestConfig.getString("access.control.allow.origin");
        if (allowedOrigins.trim().isEmpty()) {
            return;
        }
        String convertedPattern = ServerUtils.convertCommaSeparatedWilcardsToRegex(allowedOrigins);
        CorsHandler corsHandler = CorsHandler.create((String)convertedPattern);
        HashSet<String> allowedMethodsSet = new HashSet<String>(ksqlRestConfig.getList("access.control.allow.methods"));
        if (allowedMethodsSet.isEmpty()) {
            allowedMethodsSet.addAll(DEFAULT_ALLOWED_METHODS);
        }
        corsHandler.allowedMethods(allowedMethodsSet.stream().map(sMethod -> HttpMethod.valueOf((String)sMethod.toUpperCase())).collect(Collectors.toSet()));
        HashSet<String> allowedHeadersSet = new HashSet<String>(ksqlRestConfig.getList("access.control.allow.headers"));
        if (allowedHeadersSet.isEmpty()) {
            allowedHeadersSet.addAll(DEFAULT_ALLOWED_HEADERS);
        }
        corsHandler.allowedHeaders(allowedHeadersSet);
        corsHandler.allowCredentials(true);
        router.route().handler((Handler)new KsqlCorsHandler(corsHandler));
    }

    public KsqlCorsHandler(CorsHandler corsHandler) {
        this.corsHandler = corsHandler;
    }

    public void handle(RoutingContext routingContext) {
        String path = routingContext.normalisedPath();
        for (String excludedPrefix : EXCLUDED_PATH_PREFIXES) {
            if (!path.startsWith(excludedPrefix)) continue;
            routingContext.next();
            return;
        }
        this.corsHandler.handle((Object)routingContext);
    }
}

