/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.api.server;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.RateLimiter;
import io.confluent.ksql.rest.server.KsqlRestConfig;
import io.confluent.ksql.util.Pair;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.apache.logging.log4j.Logger;

public class LoggingRateLimiter {
    private static final double LIMIT_HIT_LOG_RATE = 0.2;
    private final Map<String, RateLimiter> rateLimitersByPath;
    private final Map<Integer, RateLimiter> rateLimitersByResponseCode;
    private final RateLimiter pathLimitHit;
    private final RateLimiter responseCodeLimitHit;

    LoggingRateLimiter(KsqlRestConfig ksqlRestConfig) {
        this(ksqlRestConfig, RateLimiter::create);
    }

    @VisibleForTesting
    LoggingRateLimiter(KsqlRestConfig ksqlRestConfig, Function<Double, RateLimiter> rateLimiterFactory) {
        Objects.requireNonNull(ksqlRestConfig);
        Objects.requireNonNull(rateLimiterFactory);
        this.pathLimitHit = rateLimiterFactory.apply(0.2);
        this.responseCodeLimitHit = rateLimiterFactory.apply(0.2);
        this.rateLimitersByPath = LoggingRateLimiter.getRateLimitedRequestPaths(ksqlRestConfig, rateLimiterFactory);
        this.rateLimitersByResponseCode = LoggingRateLimiter.getRateLimitedResponseCodes(ksqlRestConfig, rateLimiterFactory);
    }

    public boolean shouldLog(Logger logger, String path, int responseCode) {
        RateLimiter rateLimiter;
        if (this.rateLimitersByPath.containsKey(path) && !(rateLimiter = this.rateLimitersByPath.get(path)).tryAcquire()) {
            if (this.pathLimitHit.tryAcquire()) {
                logger.info("Hit rate limit for path " + path + " with limit " + rateLimiter.getRate());
            }
            return false;
        }
        if (this.rateLimitersByResponseCode.containsKey(responseCode) && !(rateLimiter = this.rateLimitersByResponseCode.get(responseCode)).tryAcquire()) {
            if (this.responseCodeLimitHit.tryAcquire()) {
                logger.info("Hit rate limit for response code " + responseCode + " with limit " + rateLimiter.getRate());
            }
            return false;
        }
        return true;
    }

    private static Map<String, RateLimiter> getRateLimitedRequestPaths(KsqlRestConfig config, Function<Double, RateLimiter> rateLimiterFactory) {
        return (Map)config.getStringAsMap("ksql.logging.server.rate.limited.request.paths").entrySet().stream().map(entry -> {
            double rateLimit = Double.parseDouble((String)entry.getValue());
            return Pair.of((Object)((String)entry.getKey()), (Object)((RateLimiter)rateLimiterFactory.apply(rateLimit)));
        }).collect(ImmutableMap.toImmutableMap(Pair::getLeft, Pair::getRight));
    }

    private static Map<Integer, RateLimiter> getRateLimitedResponseCodes(KsqlRestConfig config, Function<Double, RateLimiter> rateLimiterFactory) {
        return (Map)config.getStringAsMap("ksql.logging.server.rate.limited.response.codes").entrySet().stream().map(entry -> {
            int statusCode = Integer.parseInt((String)entry.getKey());
            double rateLimit = Double.parseDouble((String)entry.getValue());
            return Pair.of((Object)statusCode, (Object)((RateLimiter)rateLimiterFactory.apply(rateLimit)));
        }).collect(ImmutableMap.toImmutableMap(Pair::getLeft, Pair::getRight));
    }
}

