/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.api.server;

import io.confluent.ksql.api.auth.ApiSecurityContext;
import io.confluent.ksql.api.auth.DefaultApiSecurityContext;
import io.confluent.ksql.api.server.MetricsCallbackHolder;
import io.confluent.ksql.api.server.NextHandlerOutput;
import io.confluent.ksql.api.server.ResponseOutputStream;
import io.confluent.ksql.api.server.Server;
import io.confluent.ksql.api.server.ServerUtils;
import io.confluent.ksql.api.server.StreamingOutput;
import io.confluent.ksql.api.util.ApiServerUtils;
import io.confluent.ksql.rest.EndpointResponse;
import io.confluent.ksql.rest.Errors;
import io.confluent.ksql.rest.entity.KsqlErrorMessage;
import io.confluent.ksql.rest.entity.KsqlRequest;
import io.confluent.ksql.rest.server.resources.KsqlRestException;
import io.confluent.ksql.util.VertxCompletableFuture;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.Handler;
import io.vertx.core.WorkerExecutor;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.HttpVersion;
import io.vertx.ext.web.RoutingContext;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.BiFunction;
import org.apache.kafka.common.utils.Time;

public final class OldApiUtils {
    private static final String CONTENT_TYPE_HEADER = HttpHeaders.CONTENT_TYPE.toString();
    private static final String JSON_CONTENT_TYPE = "application/json";
    private static final String CHUNKED_ENCODING = "chunked";

    private OldApiUtils() {
    }

    static <T> void handleOldApiRequest(Server server, RoutingContext routingContext, Class<T> requestClass, Optional<MetricsCallbackHolder> metricsCallbackHolder, BiFunction<T, ApiSecurityContext, CompletableFuture<EndpointResponse>> requestor) {
        Object requestObject;
        long startTimeNanos = Time.SYSTEM.nanoseconds();
        if (requestClass != null) {
            Optional<T> optRequestObject = ServerUtils.deserialiseObject(routingContext.getBody(), routingContext, requestClass);
            if (!optRequestObject.isPresent()) {
                return;
            }
            requestObject = optRequestObject.get();
            if (requestObject instanceof KsqlRequest) {
                KsqlRequest request = (KsqlRequest)requestObject;
                ApiServerUtils.setMaskedSql(request);
            }
        } else {
            requestObject = null;
        }
        CompletableFuture<EndpointResponse> completableFuture = requestor.apply(requestObject, DefaultApiSecurityContext.create(routingContext, server));
        ((CompletableFuture)completableFuture.thenAccept(endpointResponse -> OldApiUtils.handleOldApiResponse(server, routingContext, endpointResponse, metricsCallbackHolder, startTimeNanos))).exceptionally(t -> {
            if (t instanceof CompletionException) {
                t = t.getCause();
            }
            OldApiUtils.handleOldApiResponse(server, routingContext, OldApiUtils.mapException(t), metricsCallbackHolder, startTimeNanos);
            return null;
        });
    }

    static void handleOldApiResponse(Server server, RoutingContext routingContext, EndpointResponse endpointResponse, Optional<MetricsCallbackHolder> metricsCallbackHolder, long startTimeNanos) {
        if (endpointResponse.getEntity() instanceof NextHandlerOutput) {
            routingContext.next();
            return;
        }
        HttpServerResponse response = routingContext.response();
        response.putHeader(CONTENT_TYPE_HEADER, JSON_CONTENT_TYPE);
        response.setStatusCode(endpointResponse.getStatus());
        if (endpointResponse.getEntity() instanceof StreamingOutput) {
            StreamingOutput streamingOutput = (StreamingOutput)endpointResponse.getEntity();
            if (routingContext.request().version() == HttpVersion.HTTP_2) {
                routingContext.response().setStatusCode(HttpResponseStatus.METHOD_NOT_ALLOWED.code()).setStatusMessage("The /query endpoint is not available using HTTP2").end();
                streamingOutput.close();
                return;
            }
            response.putHeader("Transfer-Encoding", CHUNKED_ENCODING);
            OldApiUtils.streamEndpointResponse(server, routingContext, streamingOutput, metricsCallbackHolder, startTimeNanos);
        } else {
            if (endpointResponse.getEntity() == null) {
                response.end();
            } else {
                Buffer responseBody = endpointResponse.getEntity() instanceof String ? Buffer.buffer((String)((String)endpointResponse.getEntity())) : ServerUtils.serializeObject(endpointResponse.getEntity());
                response.end(responseBody);
            }
            OldApiUtils.reportMetrics(routingContext, metricsCallbackHolder, startTimeNanos);
        }
    }

    private static void streamEndpointResponse(Server server, RoutingContext routingContext, StreamingOutput streamingOutput, Optional<MetricsCallbackHolder> metricsCallbackHolder, long startTimeNanos) {
        WorkerExecutor workerExecutor = server.getWorkerExecutor();
        VertxCompletableFuture vcf = new VertxCompletableFuture();
        workerExecutor.executeBlocking(promise -> {
            ResponseOutputStream ros = new ResponseOutputStream(routingContext.response(), streamingOutput.getWriteTimeoutMs());
            routingContext.request().connection().closeHandler(v -> {
                try {
                    streamingOutput.close();
                }
                catch (Throwable t) {
                    promise.fail(t);
                }
                try {
                    ros.close();
                }
                catch (IOException e) {
                    promise.fail((Throwable)e);
                }
            });
            try {
                streamingOutput.write(new BufferedOutputStream(ros));
                promise.complete();
            }
            catch (Exception e) {
                promise.fail((Throwable)e);
            }
            finally {
                try {
                    ((OutputStream)ros).close();
                }
                catch (IOException iOException) {}
            }
        }, false, (Handler)vcf);
        vcf.handle((v, throwable) -> {
            OldApiUtils.reportMetrics(routingContext, metricsCallbackHolder, startTimeNanos);
            return null;
        });
    }

    private static void reportMetrics(RoutingContext routingContext, Optional<MetricsCallbackHolder> metricsCallbackHolder, long startTimeNanos) {
        metricsCallbackHolder.ifPresent(mc -> mc.reportMetrics(routingContext.response().getStatusCode(), routingContext.request().bytesRead(), routingContext.response().bytesWritten(), startTimeNanos));
    }

    public static EndpointResponse mapException(Throwable exception) {
        if (exception instanceof KsqlRestException) {
            KsqlRestException restException = (KsqlRestException)exception;
            return restException.getResponse();
        }
        return EndpointResponse.create().status(HttpResponseStatus.INTERNAL_SERVER_ERROR.code()).type(JSON_CONTENT_TYPE).entity((Object)new KsqlErrorMessage(Errors.ERROR_CODE_SERVER_ERROR, exception)).build();
    }
}

