/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.api.server;

import io.confluent.ksql.api.server.KsqlApiException;
import io.confluent.ksql.rest.Errors;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SniHandler
implements Handler<RoutingContext> {
    private static final Logger log = LogManager.getLogger(SniHandler.class);

    public void handle(RoutingContext routingContext) {
        if (routingContext.request().isSSL()) {
            String requestHostNoPort;
            String indicatedServerName = routingContext.request().connection().indicatedServerName();
            String requestHost = routingContext.request().host();
            if (indicatedServerName != null && requestHost != null && !(requestHostNoPort = requestHost.replaceFirst(":\\d+", "")).equals(indicatedServerName)) {
                log.error(String.format("Sni check failed, host header: %s, sni value %s", requestHostNoPort, indicatedServerName));
                routingContext.fail(HttpResponseStatus.MISDIRECTED_REQUEST.code(), (Throwable)((Object)new KsqlApiException("This request was incorrectly sent to this ksqlDB server", Errors.ERROR_CODE_MISDIRECTED_REQUEST)));
                return;
            }
        }
        routingContext.next();
    }
}

