/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.logging.processing;

import io.confluent.common.logging.LogRecordStructBuilder;
import io.confluent.ksql.exception.KafkaTopicExistsException;
import io.confluent.ksql.logging.processing.ProcessingLogConfig;
import io.confluent.ksql.logging.processing.ProcessingLogMessageSchema;
import io.confluent.ksql.schema.connect.SqlSchemaFormatter;
import io.confluent.ksql.services.KafkaTopicClient;
import io.confluent.ksql.util.IdentifierUtil;
import io.confluent.ksql.util.KsqlConfig;
import io.confluent.ksql.util.ReservedInternalTopics;
import java.util.Optional;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaAndValue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ProcessingLogServerUtils {
    private static final Logger LOGGER = LogManager.getLogger(ProcessingLogServerUtils.class);
    private static final SqlSchemaFormatter FORMATTER = new SqlSchemaFormatter(w -> !IdentifierUtil.isValid((String)w), new SqlSchemaFormatter.Option[]{SqlSchemaFormatter.Option.AS_COLUMN_LIST});

    private ProcessingLogServerUtils() {
    }

    static Schema getMessageSchema() {
        return new LogRecordStructBuilder().withMessageSchemaAndValue(new SchemaAndValue(ProcessingLogMessageSchema.PROCESSING_LOG_SCHEMA, null)).build().schema();
    }

    public static String getTopicName(ProcessingLogConfig config, KsqlConfig ksqlConfig) {
        return ReservedInternalTopics.processingLogTopic((ProcessingLogConfig)config, (KsqlConfig)ksqlConfig);
    }

    public static Optional<String> maybeCreateProcessingLogTopic(KafkaTopicClient topicClient, ProcessingLogConfig config, KsqlConfig ksqlConfig) {
        if (!config.getBoolean(ProcessingLogConfig.TOPIC_AUTO_CREATE).booleanValue()) {
            return Optional.empty();
        }
        String topicName = ProcessingLogServerUtils.getTopicName(config, ksqlConfig);
        int nPartitions = config.getInt(ProcessingLogConfig.TOPIC_PARTITIONS);
        short nReplicas = config.getShort(ProcessingLogConfig.TOPIC_REPLICATION_FACTOR);
        try {
            topicClient.createTopic(topicName, nPartitions, nReplicas);
        }
        catch (KafkaTopicExistsException e) {
            if (e.getPartitionOrReplicaMismatch()) {
                LOGGER.warn(String.format("Log topic %s already exists", topicName), (Throwable)e);
            }
            LOGGER.info(String.format("Log topic %s already exists", topicName), (Throwable)e);
        }
        return Optional.of(topicName);
    }

    public static String processingLogStreamCreateStatement(ProcessingLogConfig config, KsqlConfig ksqlConfig) {
        return ProcessingLogServerUtils.processingLogStreamCreateStatement(config.getString(ProcessingLogConfig.STREAM_NAME), ProcessingLogServerUtils.getTopicName(config, ksqlConfig));
    }

    private static String processingLogStreamCreateStatement(String name, String topicName) {
        Schema schema = ProcessingLogServerUtils.getMessageSchema();
        String elements = FORMATTER.format(schema);
        return "CREATE STREAM " + name + " (" + elements + ") WITH(KAFKA_TOPIC='" + topicName + "', VALUE_FORMAT='JSON', KEY_FORMAT='KAFKA');";
    }
}

