/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.entity;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import io.confluent.ksql.execution.timestamp.TimestampColumn;
import io.confluent.ksql.metastore.model.DataSource;
import io.confluent.ksql.metrics.MetricCollectors;
import io.confluent.ksql.metrics.TopicSensors;
import io.confluent.ksql.rest.entity.KsqlHostInfoEntity;
import io.confluent.ksql.rest.entity.QueryHostStat;
import io.confluent.ksql.rest.entity.QueryOffsetSummary;
import io.confluent.ksql.rest.entity.RunningQuery;
import io.confluent.ksql.rest.entity.SourceDescription;
import io.confluent.ksql.rest.util.EntityUtil;
import io.confluent.ksql.schema.utils.FormatOptions;
import io.confluent.ksql.util.KsqlHostInfo;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.TopicPartitionInfo;

public final class SourceDescriptionFactory {
    private SourceDescriptionFactory() {
    }

    public static SourceDescription create(DataSource dataSource, boolean extended, List<RunningQuery> readQueries, List<RunningQuery> writeQueries, Optional<TopicDescription> topicDescription, List<QueryOffsetSummary> queryOffsetSummaries, List<String> sourceConstraints, MetricCollectors metricCollectors) {
        return SourceDescriptionFactory.create(dataSource, extended, readQueries, writeQueries, topicDescription, queryOffsetSummaries, sourceConstraints, Stream.empty(), Stream.empty(), new KsqlHostInfo("", 0), metricCollectors);
    }

    public static SourceDescription create(DataSource dataSource, boolean extended, List<RunningQuery> readQueries, List<RunningQuery> writeQueries, Optional<TopicDescription> topicDescription, List<QueryOffsetSummary> queryOffsetSummaries, List<String> sourceConstraints, Stream<QueryHostStat> stats, Stream<QueryHostStat> errorStats, KsqlHostInfo host, MetricCollectors metricCollectors) {
        KsqlHostInfoEntity hostEntity = new KsqlHostInfoEntity(host);
        Stream<QueryHostStat> localStats = metricCollectors.getStatsFor(dataSource.getKafkaTopicName(), false).stream().map(stat -> QueryHostStat.fromStat((TopicSensors.Stat)stat, (KsqlHostInfoEntity)hostEntity));
        Stream<QueryHostStat> localErrorStats = metricCollectors.getStatsFor(dataSource.getKafkaTopicName(), true).stream().map(stat -> QueryHostStat.fromStat((TopicSensors.Stat)stat, (KsqlHostInfoEntity)hostEntity));
        return new SourceDescription(dataSource.getName().toString(FormatOptions.noEscape()), dataSource.getKsqlTopic().getKeyFormat().getWindowType(), readQueries, writeQueries, EntityUtil.buildSourceSchemaEntity(dataSource.getSchema()), dataSource.getDataSourceType().getKsqlType(), dataSource.getTimestampColumn().map(TimestampColumn::getColumn).map(c -> c.toString(FormatOptions.noEscape())).orElse(""), extended ? metricCollectors.getAndFormatStatsFor(dataSource.getKafkaTopicName(), false) : "", extended ? metricCollectors.getAndFormatStatsFor(dataSource.getKafkaTopicName(), true) : "", extended, dataSource.getKsqlTopic().getKeyFormat().getFormatInfo().getFormat(), dataSource.getKsqlTopic().getValueFormat().getFormatInfo().getFormat(), dataSource.getKafkaTopicName(), topicDescription.map(td -> td.partitions().size()).orElse(0).intValue(), topicDescription.map(td -> ((TopicPartitionInfo)td.partitions().get(0)).replicas().size()).orElse(0).intValue(), dataSource.getSqlExpression(), queryOffsetSummaries, sourceConstraints, (List)Streams.concat((Stream[])new Stream[]{localStats, stats}).collect(ImmutableList.toImmutableList()), (List)Streams.concat((Stream[])new Stream[]{localErrorStats, errorStats}).collect(ImmutableList.toImmutableList()));
    }
}

