/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.healthcheck;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.exception.KsqlTopicAuthorizationException;
import io.confluent.ksql.rest.client.RestResponse;
import io.confluent.ksql.rest.entity.HealthCheckResponse;
import io.confluent.ksql.rest.entity.HealthCheckResponseDetail;
import io.confluent.ksql.rest.server.KsqlRestConfig;
import io.confluent.ksql.rest.server.ServerUtil;
import io.confluent.ksql.rest.server.computation.CommandRunner;
import io.confluent.ksql.rest.server.state.ServerState;
import io.confluent.ksql.services.SimpleKsqlClient;
import io.confluent.ksql.util.KsqlConfig;
import io.confluent.ksql.util.ReservedInternalTopics;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.DescribeTopicsOptions;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HealthCheckAgent {
    private static final Logger log = LogManager.getLogger(HealthCheckAgent.class);
    public static final String METASTORE_CHECK_NAME = "metastore";
    public static final String KAFKA_CHECK_NAME = "kafka";
    public static final String COMMAND_RUNNER_CHECK_NAME = "commandRunner";
    private static final List<Check> DEFAULT_CHECKS = ImmutableList.of((Object)new ExecuteStatementCheck("metastore", "list streams; list tables; list queries;"), (Object)new KafkaBrokerCheck("kafka"), (Object)new CommandRunnerCheck("commandRunner"));
    private final SimpleKsqlClient ksqlClient;
    private final URI serverEndpoint;
    private final KsqlConfig ksqlConfig;
    private final CommandRunner commandRunner;
    private final Admin adminClient;

    public HealthCheckAgent(SimpleKsqlClient ksqlClient, KsqlRestConfig restConfig, KsqlConfig ksqlConfig, CommandRunner commandRunner, Admin adminClient) {
        this.ksqlClient = Objects.requireNonNull(ksqlClient, "ksqlClient");
        this.serverEndpoint = ServerUtil.getServerAddress(restConfig);
        this.ksqlConfig = Objects.requireNonNull(ksqlConfig, "ksqlConfig");
        this.commandRunner = Objects.requireNonNull(commandRunner, COMMAND_RUNNER_CHECK_NAME);
        this.adminClient = Objects.requireNonNull(adminClient, "adminClient");
    }

    public HealthCheckResponse checkHealth() {
        Map<String, HealthCheckResponseDetail> results = DEFAULT_CHECKS.stream().collect(Collectors.toMap(Check::getName, check -> check.check(this)));
        boolean allHealthy = results.values().stream().allMatch(HealthCheckResponseDetail::getIsHealthy);
        ServerState.State serverState = this.commandRunner.checkServerState();
        return new HealthCheckResponse(allHealthy, results, Optional.of(serverState.toString()));
    }

    private static interface Check {
        public String getName();

        public HealthCheckResponseDetail check(HealthCheckAgent var1);
    }

    private static class ExecuteStatementCheck
    implements Check {
        private final String name;
        private final String ksqlStatement;

        ExecuteStatementCheck(String name, String ksqlStatement) {
            this.name = Objects.requireNonNull(name, "name");
            this.ksqlStatement = Objects.requireNonNull(ksqlStatement, "ksqlStatement");
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public HealthCheckResponseDetail check(HealthCheckAgent healthCheckAgent) {
            RestResponse response = healthCheckAgent.ksqlClient.makeKsqlRequest(healthCheckAgent.serverEndpoint, this.ksqlStatement, (Map)ImmutableMap.of((Object)"request.ksql.internal.request", (Object)true));
            return new HealthCheckResponseDetail(response.isSuccessful());
        }
    }

    private static class KafkaBrokerCheck
    implements Check {
        private static final int DESCRIBE_TOPICS_TIMEOUT_MS = 30000;
        private final String name;

        KafkaBrokerCheck(String name) {
            this.name = Objects.requireNonNull(name, "name");
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_NO_SIDE_EFFECT"})
        public HealthCheckResponseDetail check(HealthCheckAgent healthCheckAgent) {
            boolean isHealthy;
            String commandTopic = ReservedInternalTopics.commandTopic((KsqlConfig)healthCheckAgent.ksqlConfig);
            try {
                log.info("Checking ksql's ability to contact broker");
                healthCheckAgent.adminClient.describeTopics(Collections.singletonList(commandTopic), new DescribeTopicsOptions().timeoutMs(Integer.valueOf(30000))).allTopicNames().get();
                isHealthy = true;
            }
            catch (KsqlTopicAuthorizationException e) {
                log.info("ksqlDB denied access to describe cmd topic. This is considered healthy");
                isHealthy = true;
            }
            catch (Exception e) {
                log.error("Error describing command topic during health check", (Throwable)e);
                isHealthy = e instanceof UnknownTopicOrPartitionException || ExceptionUtils.getRootCause((Throwable)e) instanceof UnknownTopicOrPartitionException;
            }
            return new HealthCheckResponseDetail(isHealthy);
        }
    }

    private static class CommandRunnerCheck
    implements Check {
        private final String name;

        CommandRunnerCheck(String name) {
            this.name = Objects.requireNonNull(name, "name");
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public HealthCheckResponseDetail check(HealthCheckAgent healthCheckAgent) {
            return new HealthCheckResponseDetail(healthCheckAgent.commandRunner.checkCommandRunnerStatus() == CommandRunner.CommandRunnerStatus.RUNNING);
        }
    }
}

