/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.server;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.ksql.KsqlExecutionContext;
import io.confluent.ksql.ServiceInfo;
import io.confluent.ksql.api.auth.AuthenticationPlugin;
import io.confluent.ksql.api.impl.DefaultKsqlSecurityContextProvider;
import io.confluent.ksql.api.impl.KsqlSecurityContextProvider;
import io.confluent.ksql.api.impl.MonitoredEndpoints;
import io.confluent.ksql.api.server.Server;
import io.confluent.ksql.api.server.SlidingWindowRateLimiter;
import io.confluent.ksql.engine.KsqlEngine;
import io.confluent.ksql.execution.pull.HARouting;
import io.confluent.ksql.execution.scalablepush.PushRouting;
import io.confluent.ksql.execution.streams.RoutingFilter;
import io.confluent.ksql.execution.streams.RoutingFilters;
import io.confluent.ksql.function.FunctionRegistry;
import io.confluent.ksql.internal.JmxDataPointsReporter;
import io.confluent.ksql.internal.LeakedResourcesMetrics;
import io.confluent.ksql.internal.MetricsReporter;
import io.confluent.ksql.internal.PullQueryExecutorMetrics;
import io.confluent.ksql.internal.ScalablePushQueryMetrics;
import io.confluent.ksql.internal.StorageUtilizationMetricsReporter;
import io.confluent.ksql.logging.processing.ProcessingLogConfig;
import io.confluent.ksql.logging.processing.ProcessingLogContext;
import io.confluent.ksql.logging.processing.ProcessingLogServerUtils;
import io.confluent.ksql.metrics.MetricCollectors;
import io.confluent.ksql.name.SourceName;
import io.confluent.ksql.properties.DenyListPropertyValidator;
import io.confluent.ksql.properties.PropertiesUtil;
import io.confluent.ksql.query.id.QueryIdGenerator;
import io.confluent.ksql.query.id.SpecificQueryIdGenerator;
import io.confluent.ksql.rest.ErrorMessages;
import io.confluent.ksql.rest.Errors;
import io.confluent.ksql.rest.client.KsqlClient;
import io.confluent.ksql.rest.client.RestResponse;
import io.confluent.ksql.rest.entity.KsqlEntityList;
import io.confluent.ksql.rest.entity.StreamsList;
import io.confluent.ksql.rest.server.ActiveHostFilter;
import io.confluent.ksql.rest.server.CommandTopicMigrationUtil;
import io.confluent.ksql.rest.server.Executable;
import io.confluent.ksql.rest.server.HeartbeatAgent;
import io.confluent.ksql.rest.server.KsqlRestApplicationMetrics;
import io.confluent.ksql.rest.server.KsqlRestConfig;
import io.confluent.ksql.rest.server.KsqlServerEndpoints;
import io.confluent.ksql.rest.server.LagReportingAgent;
import io.confluent.ksql.rest.server.LivenessFilter;
import io.confluent.ksql.rest.server.LocalCommands;
import io.confluent.ksql.rest.server.MaximumLagFilter;
import io.confluent.ksql.rest.server.ServerUtil;
import io.confluent.ksql.rest.server.StatementParser;
import io.confluent.ksql.rest.server.computation.Command;
import io.confluent.ksql.rest.server.computation.CommandRunner;
import io.confluent.ksql.rest.server.computation.CommandStore;
import io.confluent.ksql.rest.server.computation.InteractiveStatementExecutor;
import io.confluent.ksql.rest.server.computation.InternalTopicSerdes;
import io.confluent.ksql.rest.server.query.QueryExecutor;
import io.confluent.ksql.rest.server.resources.ClusterStatusResource;
import io.confluent.ksql.rest.server.resources.HealthCheckResource;
import io.confluent.ksql.rest.server.resources.HeartbeatResource;
import io.confluent.ksql.rest.server.resources.KsqlResource;
import io.confluent.ksql.rest.server.resources.LagReportingResource;
import io.confluent.ksql.rest.server.resources.ServerInfoResource;
import io.confluent.ksql.rest.server.resources.ServerMetadataResource;
import io.confluent.ksql.rest.server.resources.StatusResource;
import io.confluent.ksql.rest.server.resources.streaming.StreamedQueryResource;
import io.confluent.ksql.rest.server.resources.streaming.WSQueryEndpoint;
import io.confluent.ksql.rest.server.services.InternalKsqlClientFactory;
import io.confluent.ksql.rest.server.services.RestServiceContextFactory;
import io.confluent.ksql.rest.server.services.ServerInternalKsqlClient;
import io.confluent.ksql.rest.server.state.ServerState;
import io.confluent.ksql.rest.util.ClusterTerminator;
import io.confluent.ksql.rest.util.CommandTopicBackupUtil;
import io.confluent.ksql.rest.util.ConcurrencyLimiter;
import io.confluent.ksql.rest.util.KsqlInternalTopicUtils;
import io.confluent.ksql.rest.util.KsqlUncaughtExceptionHandler;
import io.confluent.ksql.rest.util.PersistentQueryCleanupImpl;
import io.confluent.ksql.rest.util.RateLimiter;
import io.confluent.ksql.rest.util.RocksDBConfigSetterHandler;
import io.confluent.ksql.schema.registry.KsqlSchemaRegistryClientFactory;
import io.confluent.ksql.security.KsqlAuthorizationValidatorFactory;
import io.confluent.ksql.security.KsqlDefaultSecurityExtension;
import io.confluent.ksql.security.KsqlResourceExtension;
import io.confluent.ksql.security.KsqlSecurityContext;
import io.confluent.ksql.security.KsqlSecurityExtension;
import io.confluent.ksql.services.ConnectClientFactory;
import io.confluent.ksql.services.DefaultConnectClientFactory;
import io.confluent.ksql.services.KafkaClusterUtil;
import io.confluent.ksql.services.KafkaTopicClient;
import io.confluent.ksql.services.KafkaTopicClientImpl;
import io.confluent.ksql.services.LazyServiceContext;
import io.confluent.ksql.services.ServiceContext;
import io.confluent.ksql.services.SimpleKsqlClient;
import io.confluent.ksql.util.AppInfo;
import io.confluent.ksql.util.KsqlConfig;
import io.confluent.ksql.util.KsqlConfigurable;
import io.confluent.ksql.util.KsqlException;
import io.confluent.ksql.util.KsqlServerException;
import io.confluent.ksql.util.ReservedInternalTopics;
import io.confluent.ksql.util.RetryUtil;
import io.confluent.ksql.util.WelcomeMsgUtils;
import io.confluent.ksql.utilization.PersistentQuerySaturationMetrics;
import io.confluent.ksql.version.metrics.KsqlVersionCheckerAgent;
import io.confluent.ksql.version.metrics.VersionCheckerAgent;
import io.confluent.ksql.version.metrics.collector.KsqlModuleType;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.metrics.MetricsOptions;
import io.vertx.core.net.SocketAddress;
import io.vertx.ext.dropwizard.DropwizardMetricsOptions;
import io.vertx.ext.dropwizard.Match;
import java.io.Console;
import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.WakeupException;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.processor.internals.DefaultKafkaClientSupplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class KsqlRestApplication
implements Executable {
    private static final Logger log = LogManager.getLogger(KsqlRestApplication.class);
    private static final int NUM_MILLISECONDS_IN_HOUR = 3600000;
    private static final SourceName COMMANDS_STREAM_NAME = SourceName.of((String)"KSQL_COMMANDS");
    private final KsqlConfig ksqlConfigNoPort;
    private final KsqlRestConfig restConfig;
    private final KsqlEngine ksqlEngine;
    private final CommandRunner commandRunner;
    private final CommandStore commandStore;
    private final StatusResource statusResource;
    private final StreamedQueryResource streamedQueryResource;
    private final KsqlResource ksqlResource;
    private final VersionCheckerAgent versionCheckerAgent;
    private final ServiceContext serviceContext;
    private final KsqlSecurityContextProvider ksqlSecurityContextProvider;
    private final KsqlSecurityExtension securityExtension;
    private final Optional<KsqlResourceExtension> ksqlResourceExtension;
    private final Optional<AuthenticationPlugin> authenticationPlugin;
    private final ServerState serverState;
    private final ProcessingLogContext processingLogContext;
    private final List<KsqlConfigurable> configurables;
    private final Consumer<KsqlConfig> rocksDBConfigSetterHandler;
    private final Optional<HeartbeatAgent> heartbeatAgent;
    private final Optional<LagReportingAgent> lagReportingAgent;
    private final ServerInfoResource serverInfoResource;
    private final Optional<HeartbeatResource> heartbeatResource;
    private final Optional<ClusterStatusResource> clusterStatusResource;
    private final Optional<LagReportingResource> lagReportingResource;
    private final HealthCheckResource healthCheckResource;
    private final QueryExecutor queryExecutor;
    private volatile ServerMetadataResource serverMetadataResource;
    private volatile WSQueryEndpoint wsQueryEndpoint;
    private volatile ListeningScheduledExecutorService oldApiWebsocketExecutor;
    private final Vertx vertx;
    private Server apiServer = null;
    private final CompletableFuture<Void> terminatedFuture = new CompletableFuture();
    private final DenyListPropertyValidator denyListPropertyValidator;
    private final Optional<PullQueryExecutorMetrics> pullQueryMetrics;
    private final Optional<ScalablePushQueryMetrics> scalablePushQueryMetrics;
    private final Optional<LocalCommands> localCommands;
    private KafkaTopicClient internalTopicClient;
    private final Instant ksqlRestAppStartTime;
    private final KsqlRestApplicationMetrics restApplicationMetrics;
    private AtomicReference<Thread> startAsyncThreadRef = new AtomicReference<Object>(null);

    public static SourceName getCommandsStreamName() {
        return COMMANDS_STREAM_NAME;
    }

    @VisibleForTesting
    KsqlRestApplication(ServiceContext serviceContext, KsqlEngine ksqlEngine, KsqlConfig ksqlConfig, KsqlRestConfig restConfig, CommandRunner commandRunner, CommandStore commandStore, StatusResource statusResource, StreamedQueryResource streamedQueryResource, KsqlResource ksqlResource, VersionCheckerAgent versionCheckerAgent, KsqlSecurityContextProvider ksqlSecurityContextProvider, KsqlSecurityExtension securityExtension, Optional<KsqlResourceExtension> ksqlResourceExtension, Optional<AuthenticationPlugin> authenticationPlugin, ServerState serverState, ProcessingLogContext processingLogContext, List<KsqlConfigurable> configurables, Consumer<KsqlConfig> rocksDBConfigSetterHandler, Optional<HeartbeatAgent> heartbeatAgent, Optional<LagReportingAgent> lagReportingAgent, Vertx vertx, DenyListPropertyValidator denyListPropertyValidator, Optional<PullQueryExecutorMetrics> pullQueryMetrics, Optional<ScalablePushQueryMetrics> scalablePushQueryMetrics, Optional<LocalCommands> localCommands, QueryExecutor queryExecutor, MetricCollectors metricCollectors, KafkaTopicClient internalTopicClient, Admin internalAdmin, Instant ksqlRestAppStartTime) {
        log.debug("Creating instance of ksqlDB API server");
        this.serviceContext = Objects.requireNonNull(serviceContext, "serviceContext");
        this.ksqlConfigNoPort = Objects.requireNonNull(ksqlConfig, "ksqlConfig");
        this.restConfig = Objects.requireNonNull(restConfig, "restConfig");
        this.ksqlEngine = Objects.requireNonNull(ksqlEngine, "ksqlEngine");
        this.commandRunner = Objects.requireNonNull(commandRunner, "commandRunner");
        this.statusResource = Objects.requireNonNull(statusResource, "statusResource");
        this.streamedQueryResource = Objects.requireNonNull(streamedQueryResource, "streamedQueryResource");
        this.ksqlResource = Objects.requireNonNull(ksqlResource, "ksqlResource");
        this.commandStore = Objects.requireNonNull(commandStore, "commandStore");
        this.serverState = Objects.requireNonNull(serverState, "serverState");
        this.processingLogContext = Objects.requireNonNull(processingLogContext, "processingLogContext");
        this.versionCheckerAgent = Objects.requireNonNull(versionCheckerAgent, "versionCheckerAgent");
        this.ksqlSecurityContextProvider = Objects.requireNonNull(ksqlSecurityContextProvider, "ksqlSecurityContextProvider");
        this.securityExtension = Objects.requireNonNull(securityExtension, "securityExtension");
        this.ksqlResourceExtension = Objects.requireNonNull(ksqlResourceExtension);
        this.authenticationPlugin = Objects.requireNonNull(authenticationPlugin, "authenticationPlugin");
        this.configurables = Objects.requireNonNull(configurables, "configurables");
        this.rocksDBConfigSetterHandler = Objects.requireNonNull(rocksDBConfigSetterHandler, "rocksDBConfigSetterHandler");
        this.heartbeatAgent = Objects.requireNonNull(heartbeatAgent, "heartbeatAgent");
        this.lagReportingAgent = Objects.requireNonNull(lagReportingAgent, "lagReportingAgent");
        this.vertx = Objects.requireNonNull(vertx, "vertx");
        this.denyListPropertyValidator = Objects.requireNonNull(denyListPropertyValidator, "denyListPropertyValidator");
        this.serverInfoResource = new ServerInfoResource(serviceContext, this.ksqlConfigNoPort, commandRunner);
        if (heartbeatAgent.isPresent()) {
            this.heartbeatResource = Optional.of(new HeartbeatResource(heartbeatAgent.get()));
            this.clusterStatusResource = Optional.of(new ClusterStatusResource(ksqlEngine, heartbeatAgent.get(), lagReportingAgent));
        } else {
            this.heartbeatResource = Optional.empty();
            this.clusterStatusResource = Optional.empty();
        }
        this.lagReportingResource = lagReportingAgent.map(LagReportingResource::new);
        this.healthCheckResource = HealthCheckResource.create(ksqlResource, serviceContext, this.restConfig, this.ksqlConfigNoPort, this.commandRunner, internalAdmin);
        metricCollectors.addConfigurableReporter(this.ksqlConfigNoPort);
        this.pullQueryMetrics = Objects.requireNonNull(pullQueryMetrics, "pullQueryMetrics");
        this.scalablePushQueryMetrics = Objects.requireNonNull(scalablePushQueryMetrics, "scalablePushQueryMetrics");
        log.debug("ksqlDB API server instance created");
        this.localCommands = Objects.requireNonNull(localCommands, "localCommands");
        this.queryExecutor = Objects.requireNonNull(queryExecutor, "queryExecutor");
        this.internalTopicClient = Objects.requireNonNull(internalTopicClient, "internalTopicClient");
        this.ksqlRestAppStartTime = Objects.requireNonNull(ksqlRestAppStartTime, "ksqlRestAppStartTime");
        this.restApplicationMetrics = new KsqlRestApplicationMetrics(metricCollectors.getMetrics());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startAsync() {
        log.debug("Starting the ksqlDB API server");
        this.serverMetadataResource = ServerMetadataResource.create(this.serviceContext, this.ksqlConfigNoPort);
        StatementParser statementParser = new StatementParser((KsqlExecutionContext)this.ksqlEngine);
        Optional authorizationValidator = KsqlAuthorizationValidatorFactory.create((KsqlConfig)this.ksqlConfigNoPort, (ServiceContext)this.serviceContext, (Optional)this.securityExtension.getAuthorizationProvider());
        Errors errorHandler = new Errors((ErrorMessages)this.restConfig.getConfiguredInstance("ksql.server.error.messages", ErrorMessages.class));
        KsqlRestConfig ksqlRestConfig = new KsqlRestConfig(this.ksqlConfigNoPort.originals());
        this.oldApiWebsocketExecutor = MoreExecutors.listeningDecorator((ScheduledExecutorService)Executors.newScheduledThreadPool(ksqlRestConfig.getInt("ksql.server.websockets.num.threads"), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("websockets-query-thread-%d").build()));
        this.wsQueryEndpoint = new WSQueryEndpoint(this.ksqlConfigNoPort, statementParser, this.ksqlEngine, this.commandStore, this.oldApiWebsocketExecutor, () -> ((VersionCheckerAgent)this.versionCheckerAgent).updateLastRequestTime(), Duration.ofMillis(ksqlRestConfig.getLong("ksql.server.command.response.timeout.ms")), authorizationValidator, errorHandler, this.denyListPropertyValidator, this.queryExecutor);
        this.startAsyncThreadRef.set(Thread.currentThread());
        try {
            KsqlServerEndpoints endpoints = new KsqlServerEndpoints(this.ksqlEngine, this.ksqlConfigNoPort, this.ksqlSecurityContextProvider, this.ksqlResource, this.streamedQueryResource, this.serverInfoResource, this.heartbeatResource, this.clusterStatusResource, this.statusResource, this.lagReportingResource, this.healthCheckResource, this.serverMetadataResource, this.wsQueryEndpoint, this.pullQueryMetrics, this.queryExecutor, this.securityExtension.getAuthTokenProvider());
            this.apiServer = new Server(this.vertx, ksqlRestConfig, endpoints, this.securityExtension, this.authenticationPlugin, this.serverState, this.pullQueryMetrics);
            this.apiServer.start();
            KsqlConfig ksqlConfigWithPort = this.buildConfigWithPort();
            this.configurables.forEach(c -> c.configure(ksqlConfigWithPort));
            this.startKsql(ksqlConfigWithPort);
            Properties metricsProperties = new Properties();
            metricsProperties.putAll(this.restConfig.getOriginals());
            this.versionCheckerAgent.start(KsqlModuleType.SERVER, metricsProperties);
            HashSet<URI> pp = new HashSet<URI>(this.apiServer.getProxyProtocolListeners());
            String allListenersDescription = this.apiServer.getListeners().stream().map(x -> pp.contains(x) ? x.toString() + " (PROXY protocol enabled)" : x.toString()).collect(Collectors.joining(", "));
            log.info("ksqlDB API server listening on {}", (Object)allListenersDescription);
            this.displayWelcomeMessage(allListenersDescription);
        }
        catch (AbortApplicationStartException e) {
            log.error("Aborting application start", (Throwable)((Object)e));
        }
        finally {
            this.startAsyncThreadRef.set(null);
        }
    }

    @VisibleForTesting
    void startKsql(KsqlConfig ksqlConfigWithPort) {
        this.cleanupOldState();
        this.initialize(ksqlConfigWithPort);
    }

    @VisibleForTesting
    KsqlEngine getEngine() {
        return this.ksqlEngine;
    }

    private void cleanupOldState() {
        this.localCommands.ifPresent(lc -> lc.processLocalCommandFiles(this.serviceContext));
    }

    private void initialize(KsqlConfig configWithApplicationServer) {
        this.rocksDBConfigSetterHandler.accept(this.ksqlConfigNoPort);
        this.registerCommandTopic();
        this.commandStore.start();
        ProcessingLogServerUtils.maybeCreateProcessingLogTopic(this.serviceContext.getTopicClient(), this.processingLogContext.getConfig(), this.ksqlConfigNoPort);
        this.commandRunner.processPriorCommands(new PersistentQueryCleanupImpl(configWithApplicationServer.getKsqlStreamConfigProps().getOrDefault("state.dir", StreamsConfig.configDef().defaultValues().get("state.dir")).toString(), this.serviceContext, configWithApplicationServer));
        this.commandRunner.start();
        KsqlRestApplication.maybeCreateProcessingLogStream(this.processingLogContext.getConfig(), this.ksqlConfigNoPort, this.restConfig, this.ksqlResource, this.serviceContext);
        if (this.heartbeatAgent.isPresent()) {
            this.heartbeatAgent.get().setLocalAddress((String)configWithApplicationServer.getKsqlStreamConfigProps().get("application.server"));
            this.heartbeatAgent.get().startAgent();
        }
        if (this.lagReportingAgent.isPresent()) {
            this.lagReportingAgent.get().setLocalAddress((String)configWithApplicationServer.getKsqlStreamConfigProps().get("application.server"));
            this.lagReportingAgent.get().startAgent();
        }
        this.serverState.setReady();
        this.restApplicationMetrics.recordServerStartLatency(Duration.between(this.ksqlRestAppStartTime, Instant.now()));
    }

    @Override
    public void notifyTerminated() {
        this.terminatedFuture.complete(null);
        Thread startAsyncThread = this.startAsyncThreadRef.get();
        if (startAsyncThread != null) {
            startAsyncThread.interrupt();
        }
    }

    @Override
    public void shutdown() {
        log.info("ksqlDB shutdown called");
        try {
            this.pullQueryMetrics.ifPresent(PullQueryExecutorMetrics::close);
        }
        catch (Exception e) {
            log.error("Exception while waiting for pull query metrics to close", (Throwable)e);
        }
        try {
            this.scalablePushQueryMetrics.ifPresent(ScalablePushQueryMetrics::close);
        }
        catch (Exception e) {
            log.error("Exception while waiting for scalable push query metrics to close", (Throwable)e);
        }
        this.localCommands.ifPresent(lc -> {
            try {
                lc.close();
            }
            catch (Exception e) {
                log.error("Exception while closing local commands", (Throwable)e);
            }
        });
        try {
            this.ksqlEngine.close();
        }
        catch (Exception e) {
            log.error("Exception while waiting for Ksql Engine to close", (Throwable)e);
        }
        try {
            this.commandRunner.close();
        }
        catch (Exception e) {
            log.error("Exception while waiting for CommandRunner thread to complete", (Throwable)e);
        }
        try {
            this.serviceContext.close();
        }
        catch (Exception e) {
            log.error("Exception while closing services", (Throwable)e);
        }
        try {
            this.securityExtension.close();
        }
        catch (Exception e) {
            log.error("Exception while closing security extension", (Throwable)e);
        }
        try {
            this.ksqlResourceExtension.ifPresent(KsqlResourceExtension::close);
        }
        catch (Exception e) {
            log.error("Exception while closing license validator extension", (Throwable)e);
        }
        if (this.apiServer != null) {
            this.apiServer.stop();
            this.apiServer = null;
        }
        if (this.vertx != null) {
            try {
                CountDownLatch latch = new CountDownLatch(1);
                this.vertx.close(ar -> latch.countDown());
                latch.await();
            }
            catch (InterruptedException e) {
                log.error("Exception while closing vertx", (Throwable)e);
            }
        }
        if (this.oldApiWebsocketExecutor != null) {
            this.oldApiWebsocketExecutor.shutdown();
        }
        this.shutdownAdditionalAgents();
        log.info("ksqlDB shutdown complete");
    }

    @Override
    public void awaitTerminated() throws InterruptedException {
        try {
            this.terminatedFuture.get();
        }
        catch (ExecutionException e) {
            log.error("Exception in awaitTerminated", (Throwable)e);
            throw new KsqlException(e.getCause());
        }
    }

    private void shutdownAdditionalAgents() {
        if (this.heartbeatAgent.isPresent()) {
            try {
                this.heartbeatAgent.get().stopAgent();
            }
            catch (Exception e) {
                log.error("Exception while shutting down HeartbeatAgent", (Throwable)e);
            }
        }
        if (this.lagReportingAgent.isPresent()) {
            try {
                this.lagReportingAgent.get().stopAgent();
            }
            catch (Exception e) {
                log.error("Exception while shutting down LagReportingAgent", (Throwable)e);
            }
        }
    }

    List<URL> getListeners() {
        return this.apiServer.getListeners().stream().map(uri -> {
            try {
                return uri.toURL();
            }
            catch (MalformedURLException e) {
                throw new KsqlException((Throwable)e);
            }
        }).collect(Collectors.toList());
    }

    Optional<URL> getInternalListener() {
        return this.apiServer.getInternalListener().map(uri -> {
            try {
                return uri.toURL();
            }
            catch (MalformedURLException e) {
                throw new KsqlException((Throwable)e);
            }
        });
    }

    public static KsqlRestApplication buildApplication(KsqlRestConfig restConfig, ServerState serverState, MetricCollectors metricCollectors, FunctionRegistry functionRegistry, Instant ksqlRestAppStartTime) {
        Map<String, Object> updatedRestProps = restConfig.getOriginals();
        KsqlConfig ksqlConfig = new KsqlConfig(restConfig.getKsqlConfigProperties());
        Vertx vertx = Vertx.vertx((VertxOptions)new VertxOptions().setMaxWorkerExecuteTimeUnit(TimeUnit.MILLISECONDS).setMaxWorkerExecuteTime(Long.MAX_VALUE).setMetricsOptions((MetricsOptions)KsqlRestApplication.setUpHttpMetrics(ksqlConfig)));
        vertx.exceptionHandler(t -> log.error("Unhandled exception in Vert.x", t));
        KsqlClient sharedClient = InternalKsqlClientFactory.createInternalClient(PropertiesUtil.toMapStrings((Map)ksqlConfig.originals()), SocketAddress::inetSocketAddress, vertx);
        Supplier<SchemaRegistryClient> schemaRegistryClientFactory = () -> ((KsqlSchemaRegistryClientFactory)new KsqlSchemaRegistryClientFactory(ksqlConfig, Collections.emptyMap())).get();
        DefaultConnectClientFactory connectClientFactory = new DefaultConnectClientFactory(ksqlConfig);
        LazyServiceContext tempServiceContext = new LazyServiceContext(() -> KsqlRestApplication.lambda$buildApplication$8(ksqlConfig, schemaRegistryClientFactory, (ConnectClientFactory)connectClientFactory, sharedClient));
        String kafkaClusterId = KafkaClusterUtil.getKafkaClusterId((ServiceContext)tempServiceContext);
        String ksqlServerId = ksqlConfig.getString("ksql.service.id");
        updatedRestProps.putAll(metricCollectors.addConfluentMetricsContextConfigs(ksqlServerId, kafkaClusterId));
        KsqlRestConfig updatedRestConfig = new KsqlRestConfig(updatedRestProps);
        LazyServiceContext serviceContext = new LazyServiceContext(() -> KsqlRestApplication.lambda$buildApplication$9(updatedRestConfig, schemaRegistryClientFactory, (ConnectClientFactory)connectClientFactory, sharedClient));
        return KsqlRestApplication.buildApplication("", updatedRestConfig, serverState, KsqlVersionCheckerAgent::new, Integer.MAX_VALUE, (ServiceContext)serviceContext, schemaRegistryClientFactory, (ConnectClientFactory)connectClientFactory, vertx, sharedClient, RestServiceContextFactory::create, RestServiceContextFactory::create, metricCollectors, functionRegistry, ksqlRestAppStartTime);
    }

    static KsqlRestApplication buildApplication(String metricsPrefix, KsqlRestConfig restConfig, ServerState serverState, Function<Supplier<Boolean>, VersionCheckerAgent> versionCheckerFactory, int maxStatementRetries, ServiceContext serviceContext, Supplier<SchemaRegistryClient> schemaRegistryClientFactory, ConnectClientFactory connectClientFactory, Vertx vertx, KsqlClient sharedClient, RestServiceContextFactory.DefaultServiceContextFactory defaultServiceContextFactory, RestServiceContextFactory.UserServiceContextFactory userServiceContextFactory, MetricCollectors metricCollectors, FunctionRegistry functionRegistry, Instant ksqlRestAppStartTime) {
        KsqlConfig ksqlConfig = new KsqlConfig(restConfig.getKsqlConfigProperties());
        ProcessingLogConfig processingLogConfig = new ProcessingLogConfig(restConfig.getOriginals());
        ProcessingLogContext processingLogContext = ProcessingLogContext.create((ProcessingLogConfig)processingLogConfig, (Metrics)metricCollectors.getMetrics(), (Map)ksqlConfig.getStringAsMap("ksql.metrics.tags.custom"));
        if (restConfig.getBoolean("ksql.server.exception.uncaught.handler.enable").booleanValue()) {
            Thread.setDefaultUncaughtExceptionHandler(new KsqlUncaughtExceptionHandler(LogManager::shutdown));
        }
        SpecificQueryIdGenerator specificQueryIdGenerator = new SpecificQueryIdGenerator();
        String stateDir = ksqlConfig.getKsqlStreamConfigProps().getOrDefault("state.dir", StreamsConfig.configDef().defaultValues().get("state.dir")).toString();
        ServiceInfo serviceInfo = ServiceInfo.create((KsqlConfig)ksqlConfig, (String)metricsPrefix);
        ImmutableMap metricsTags = ImmutableMap.builder().putAll(serviceInfo.customMetricsTags()).put((Object)"ksql_service_id", (Object)serviceInfo.serviceId()).build();
        StorageUtilizationMetricsReporter.configureShared((File)new File(stateDir), (Metrics)metricCollectors.getMetrics(), (Map)ksqlConfig.getStringAsMap("ksql.metrics.tags.custom"));
        ScheduledExecutorService executorService = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat("ksql-csu-metrics-reporter-%d").build());
        ScheduledExecutorService leakedResourcesReporter = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat("ksql-leaked-resources-metrics-reporter-%d").build());
        KsqlEngine ksqlEngine = new KsqlEngine(serviceContext, processingLogContext, functionRegistry, serviceInfo, (QueryIdGenerator)specificQueryIdGenerator, new KsqlConfig(restConfig.getKsqlConfigProperties()), Collections.emptyList(), metricCollectors);
        PersistentQuerySaturationMetrics saturation = new PersistentQuerySaturationMetrics(ksqlEngine, (MetricsReporter)new JmxDataPointsReporter(metricCollectors.getMetrics(), "ksqldb_utilization", Duration.ofMinutes(1L)), Duration.ofMinutes(5L), Duration.ofSeconds(30L), ksqlConfig.getStringAsMap("ksql.metrics.tags.custom"));
        executorService.scheduleAtFixedRate((Runnable)saturation, 0L, Duration.ofMinutes(1L).toMillis(), TimeUnit.MILLISECONDS);
        int transientQueryCleanupServicePeriod = ksqlConfig.getInt("ksql.transient.query.cleanup.service.period.seconds");
        LeakedResourcesMetrics leaked = new LeakedResourcesMetrics(ksqlEngine, new JmxDataPointsReporter(metricCollectors.getMetrics(), "_confluent-ksql-" + ksqlConfig.getString("ksql.service.id") + ".leaked_resources_metrics", Duration.ofSeconds(transientQueryCleanupServicePeriod)), ksqlConfig.getStringAsMap("ksql.metrics.tags.custom"));
        leakedResourcesReporter.scheduleAtFixedRate((Runnable)leaked, 0L, transientQueryCleanupServicePeriod, TimeUnit.SECONDS);
        String commandTopicName = ReservedInternalTopics.commandTopic((KsqlConfig)ksqlConfig);
        Admin internalAdmin = KsqlRestApplication.createCommandTopicAdminClient(restConfig, ksqlConfig);
        KafkaTopicClientImpl internalTopicClient = new KafkaTopicClientImpl(() -> internalAdmin);
        CommandStore commandStore = CommandStore.Factory.create(ksqlConfig, commandTopicName, Duration.ofMillis(restConfig.getLong("ksql.server.command.response.timeout.ms")), ksqlConfig.addConfluentMetricsContextConfigsKafka(restConfig.getCommandConsumerProperties()), ksqlConfig.addConfluentMetricsContextConfigsKafka(restConfig.getCommandProducerProperties()), (KafkaTopicClient)internalTopicClient);
        InteractiveStatementExecutor statementExecutor = new InteractiveStatementExecutor(serviceContext, ksqlEngine, specificQueryIdGenerator);
        StatusResource statusResource = new StatusResource(statementExecutor);
        VersionCheckerAgent versionChecker = versionCheckerFactory.apply(() -> ((KsqlEngine)ksqlEngine).hasActiveQueries());
        KsqlSecurityExtension securityExtension = KsqlRestApplication.loadSecurityExtension(ksqlConfig);
        DefaultKsqlSecurityContextProvider ksqlSecurityContextProvider = new DefaultKsqlSecurityContextProvider(securityExtension, defaultServiceContextFactory, userServiceContextFactory, ksqlConfig, schemaRegistryClientFactory, connectClientFactory, sharedClient);
        Optional<KsqlResourceExtension> ksqlResourceExtension = KsqlRestApplication.loadKsqlResourceExtension(ksqlConfig);
        Optional<AuthenticationPlugin> securityHandlerPlugin = KsqlRestApplication.loadAuthenticationPlugin(restConfig);
        Optional authorizationValidator = KsqlAuthorizationValidatorFactory.create((KsqlConfig)ksqlConfig, (ServiceContext)serviceContext, (Optional)securityExtension.getAuthorizationProvider());
        Errors errorHandler = new Errors((ErrorMessages)restConfig.getConfiguredInstance("ksql.server.error.messages", ErrorMessages.class));
        Optional<LagReportingAgent> lagReportingAgent = KsqlRestApplication.initializeLagReportingAgent(restConfig, ksqlEngine, serviceContext);
        Optional<HeartbeatAgent> heartbeatAgent = KsqlRestApplication.initializeHeartbeatAgent(restConfig, ksqlEngine, serviceContext, lagReportingAgent);
        RoutingFilter.RoutingFilterFactory routingFilterFactory = KsqlRestApplication.initializeRoutingFilterFactory(ksqlConfig, heartbeatAgent, lagReportingAgent);
        RateLimiter pullQueryRateLimiter = new RateLimiter(ksqlConfig.getInt("ksql.query.pull.max.qps").intValue(), "pull", metricCollectors.getMetrics(), (Map<String, String>)metricsTags);
        ConcurrencyLimiter pullQueryConcurrencyLimiter = new ConcurrencyLimiter(ksqlConfig.getInt("ksql.query.pull.max.concurrent.requests"), "pull", metricCollectors.getMetrics(), (Map<String, String>)metricsTags);
        SlidingWindowRateLimiter pullBandRateLimiter = new SlidingWindowRateLimiter(ksqlConfig.getInt("ksql.query.pull.max.hourly.bandwidth.megabytes"), 3600000L, "pull", metricCollectors.getMetrics(), (Map<String, String>)metricsTags);
        SlidingWindowRateLimiter scalablePushBandRateLimiter = new SlidingWindowRateLimiter(ksqlConfig.getInt("ksql.query.push.v2.max.hourly.bandwidth.megabytes"), 3600000L, "push", metricCollectors.getMetrics(), (Map<String, String>)metricsTags);
        DenyListPropertyValidator denyListPropertyValidator = new DenyListPropertyValidator((Collection)ksqlConfig.getList("ksql.properties.overrides.denylist"));
        Optional<PullQueryExecutorMetrics> pullQueryMetrics = ksqlConfig.getBoolean("ksql.query.pull.metrics.enabled") != false ? Optional.of(new PullQueryExecutorMetrics(ksqlEngine.getServiceId(), ksqlConfig.getStringAsMap("ksql.metrics.tags.custom"), Time.SYSTEM, metricCollectors.getMetrics())) : Optional.empty();
        Optional<ScalablePushQueryMetrics> scalablePushQueryMetrics = ksqlConfig.getBoolean("ksql.query.push.v2.metrics.enabled") != false ? Optional.of(new ScalablePushQueryMetrics(ksqlEngine.getServiceId(), ksqlConfig.getStringAsMap("ksql.metrics.tags.custom"), Time.SYSTEM, metricCollectors.getMetrics())) : Optional.empty();
        HARouting pullQueryRouting = new HARouting(routingFilterFactory, pullQueryMetrics, ksqlConfig);
        PushRouting pushQueryRouting = new PushRouting();
        Optional<LocalCommands> localCommands = KsqlRestApplication.createLocalCommands(restConfig, ksqlEngine);
        QueryExecutor queryExecutor = new QueryExecutor(ksqlEngine, restConfig, ksqlConfig, pullQueryMetrics, scalablePushQueryMetrics, pullQueryRateLimiter, pullQueryConcurrencyLimiter, pullBandRateLimiter, scalablePushBandRateLimiter, pullQueryRouting, pushQueryRouting, localCommands);
        StreamedQueryResource streamedQueryResource = new StreamedQueryResource((KsqlExecutionContext)ksqlEngine, restConfig, commandStore, Duration.ofMillis(restConfig.getLong("query.stream.disconnect.check")), Duration.ofMillis(restConfig.getLong("ksql.server.command.response.timeout.ms")), () -> ((VersionCheckerAgent)versionChecker).updateLastRequestTime(), authorizationValidator, errorHandler, denyListPropertyValidator, queryExecutor);
        LinkedList<String> managedTopics = new LinkedList<String>();
        managedTopics.add(commandTopicName);
        if (processingLogConfig.getBoolean(ProcessingLogConfig.TOPIC_AUTO_CREATE).booleanValue()) {
            managedTopics.add(ProcessingLogServerUtils.getTopicName(processingLogConfig, ksqlConfig));
        }
        CommandRunner commandRunner = new CommandRunner(statementExecutor, commandStore, maxStatementRetries, new ClusterTerminator(ksqlEngine, serviceContext, managedTopics), serverState, ksqlConfig.getString("ksql.service.id"), Duration.ofMillis(restConfig.getLong("ksql.server.command.blocked.threshold.error.ms")), metricsPrefix, InternalTopicSerdes.deserializer(Command.class), errorHandler, (KafkaTopicClient)internalTopicClient, commandTopicName, metricCollectors.getMetrics());
        KsqlResource ksqlResource = new KsqlResource(ksqlEngine, commandRunner, Duration.ofMillis(restConfig.getLong("ksql.server.command.response.timeout.ms")), () -> ((VersionCheckerAgent)versionChecker).updateLastRequestTime(), authorizationValidator, errorHandler, denyListPropertyValidator);
        ImmutableList configurables = ImmutableList.of((Object)ksqlResource, (Object)ksqlEngine);
        Consumer<KsqlConfig> rocksDBConfigSetterHandler = RocksDBConfigSetterHandler::maybeConfigureRocksDBConfigSetter;
        return new KsqlRestApplication(serviceContext, ksqlEngine, ksqlConfig, restConfig, commandRunner, commandStore, statusResource, streamedQueryResource, ksqlResource, versionChecker, ksqlSecurityContextProvider, securityExtension, ksqlResourceExtension, securityHandlerPlugin, serverState, processingLogContext, (List<KsqlConfigurable>)configurables, rocksDBConfigSetterHandler, heartbeatAgent, lagReportingAgent, vertx, denyListPropertyValidator, pullQueryMetrics, scalablePushQueryMetrics, localCommands, queryExecutor, metricCollectors, (KafkaTopicClient)internalTopicClient, internalAdmin, ksqlRestAppStartTime);
    }

    private static Optional<HeartbeatAgent> initializeHeartbeatAgent(KsqlRestConfig restConfig, KsqlEngine ksqlEngine, ServiceContext serviceContext, Optional<LagReportingAgent> lagReportingAgent) {
        if (restConfig.getBoolean("ksql.heartbeat.enable").booleanValue()) {
            HeartbeatAgent.Builder builder = HeartbeatAgent.builder();
            builder.heartbeatSendInterval(restConfig.getLong("ksql.heartbeat.send.interval.ms")).heartbeatCheckInterval(restConfig.getLong("ksql.heartbeat.check.interval.ms")).heartbeatMissedThreshold(restConfig.getLong("ksql.heartbeat.missed.threshold.ms")).heartbeatWindow(restConfig.getLong("ksql.heartbeat.window.ms")).discoverClusterInterval(restConfig.getLong("ksql.heartbeat.discover.interval.ms")).threadPoolSize(restConfig.getInt("ksql.heartbeat.thread.pool.size"));
            lagReportingAgent.ifPresent(builder::addHostStatusListener);
            return Optional.of(builder.build(ksqlEngine, serviceContext));
        }
        return Optional.empty();
    }

    private static Optional<LagReportingAgent> initializeLagReportingAgent(KsqlRestConfig restConfig, KsqlEngine ksqlEngine, ServiceContext serviceContext) {
        if (restConfig.getBoolean("ksql.lag.reporting.enable").booleanValue() && restConfig.getBoolean("ksql.heartbeat.enable").booleanValue()) {
            LagReportingAgent.Builder builder = LagReportingAgent.builder();
            return Optional.of(builder.lagSendIntervalMs(restConfig.getLong("ksql.lag.reporting.send.interval.ms")).build(ksqlEngine, serviceContext));
        }
        return Optional.empty();
    }

    private static RoutingFilter.RoutingFilterFactory initializeRoutingFilterFactory(KsqlConfig configWithApplicationServer, Optional<HeartbeatAgent> heartbeatAgent, Optional<LagReportingAgent> lagReportingAgent) {
        return (routingOptions, hosts, active, queryId, storeName, partition) -> {
            ImmutableList.Builder filterBuilder = ImmutableList.builder();
            if (routingOptions.getIsSkipForwardRequest()) {
                MaximumLagFilter.create(lagReportingAgent, routingOptions, hosts, queryId, storeName, partition).map(arg_0 -> ((ImmutableList.Builder)filterBuilder).add(arg_0));
            } else {
                if (!configWithApplicationServer.getBoolean("ksql.query.pull.enable.standby.reads").booleanValue()) {
                    filterBuilder.add((Object)new ActiveHostFilter(active));
                }
                filterBuilder.add((Object)new LivenessFilter(heartbeatAgent));
                MaximumLagFilter.create(lagReportingAgent, routingOptions, hosts, queryId, storeName, partition).map(arg_0 -> ((ImmutableList.Builder)filterBuilder).add(arg_0));
            }
            return new RoutingFilters(filterBuilder.build());
        };
    }

    private void registerCommandTopic() {
        String commandTopic = this.commandStore.getCommandTopicName();
        if (this.checkMigrationConditions(commandTopic)) {
            log.warn("Migrating command topic from the service context Kafka to the command producer/consumer Kafka for ksql with id {}.", (Object)this.ksqlConfigNoPort.getString("ksql.service.id"));
            KsqlInternalTopicUtils.ensureTopic(commandTopic, this.ksqlConfigNoPort, this.internalTopicClient);
            try {
                CommandTopicMigrationUtil.commandTopicMigration(commandTopic, this.restConfig, this.ksqlConfigNoPort);
            }
            catch (Exception e) {
                log.warn("Failed to migrate command topic from the service context Kafka to the command producer/consumer Kafka for ksql with id {}.", (Object)this.ksqlConfigNoPort.getString("ksql.service.id"), (Object)e);
                throw e;
            }
        } else if (this.restConfig.getString("ksql.server.command.topic.migration.enabled").equals("MIGRATING")) {
            RetryUtil.retryWithBackoff((int)Integer.MAX_VALUE, (int)10000, (int)10000, () -> {
                if (!this.internalTopicClient.isTopicExists(commandTopic)) {
                    throw new RuntimeException("command topic migration still in process, no new command topic on command producer/consumer Kafka.");
                }
                Map commandTopicEndOffset = this.internalTopicClient.listTopicsEndOffsets(Collections.singletonList(commandTopic));
                if ((Long)commandTopicEndOffset.get(new TopicPartition(commandTopic, 0)) == 0L) {
                    throw new RuntimeException("command topic migration still in process, empty command topic on command producer/consumer Kafka.");
                }
            }, (Class[])new Class[]{WakeupException.class});
        }
        if (CommandTopicBackupUtil.commandTopicMissingWithValidBackup(commandTopic, this.internalTopicClient, this.ksqlConfigNoPort)) {
            log.warn("Command topic is not found and it is not in sync with backup. Use backup to recover the command topic.");
            return;
        }
        KsqlInternalTopicUtils.ensureTopic(commandTopic, this.ksqlConfigNoPort, this.internalTopicClient);
    }

    private boolean checkMigrationConditions(String commandTopic) {
        Map commandTopicEndOffset;
        boolean emptyCommandTopic = this.internalTopicClient.isTopicExists(commandTopic) ? (Long)(commandTopicEndOffset = this.internalTopicClient.listTopicsEndOffsets(Collections.singletonList(commandTopic))).get(new TopicPartition(commandTopic, 0)) == 0L : true;
        return emptyCommandTopic && this.serviceContext.getTopicClient().isTopicExists(commandTopic) && this.restConfig.getString("ksql.server.command.topic.migration.enabled").equals("MIGRATOR");
    }

    private static KsqlSecurityExtension loadSecurityExtension(KsqlConfig ksqlConfig) {
        KsqlSecurityExtension securityExtension = Optional.ofNullable((KsqlSecurityExtension)ksqlConfig.getConfiguredInstance("ksql.security.extension.class", KsqlSecurityExtension.class)).orElse((KsqlSecurityExtension)new KsqlDefaultSecurityExtension());
        securityExtension.initialize(ksqlConfig);
        return securityExtension;
    }

    private static Optional<KsqlResourceExtension> loadKsqlResourceExtension(KsqlConfig ksqlConfig) {
        String extensionClassName = ksqlConfig.getString("ksql.resource.extension.class");
        if (StringUtils.isBlank((CharSequence)extensionClassName) || !extensionClassName.toLowerCase().matches("io\\.confluent\\.ksql\\.security\\.license\\.ksqllicensevalidatorextension")) {
            log.warn("No Enterprise license detected. Confluent does not offer Enterprise support any self-managed(Confluent Platform) components without a valid Enterprise license");
            return Optional.empty();
        }
        try {
            log.info("Loading KSQL resource extension: {}", (Object)extensionClassName);
            List extensions = ksqlConfig.getConfiguredInstances(Collections.singletonList(extensionClassName), KsqlResourceExtension.class, ksqlConfig.originals());
            if (extensions.isEmpty()) {
                throw new KsqlException("No Enterprise license detected. Confluent does not offer Enterprise support any self-managed(Confluent Platform) components without a valid Enterprise license");
            }
            KsqlResourceExtension extension = (KsqlResourceExtension)extensions.get(0);
            if (extension == null) {
                throw new KsqlException("No Enterprise license detected. Confluent does not offer Enterprise support any self-managed(Confluent Platform) components without a valid Enterprise license");
            }
            extension.register(ksqlConfig);
            log.info("Successfully loaded and registered KSQL resource extension: {}", (Object)extensionClassName);
            return Optional.of(extension);
        }
        catch (Throwable t) {
            log.warn("No Enterprise license detected. Confluent does not offer Enterprise support any self-managed(Confluent Platform) components without a valid Enterprise license");
            return Optional.empty();
        }
    }

    private static Optional<AuthenticationPlugin> loadAuthenticationPlugin(KsqlRestConfig ksqlRestConfig) {
        Optional<AuthenticationPlugin> authenticationPlugin = Optional.ofNullable((AuthenticationPlugin)ksqlRestConfig.getConfiguredInstance("ksql.authentication.plugin.class", AuthenticationPlugin.class));
        authenticationPlugin.ifPresent(securityHandlerPlugin -> securityHandlerPlugin.configure(ksqlRestConfig.originals()));
        return authenticationPlugin;
    }

    private void displayWelcomeMessage(String allListenersDescription) {
        Console console = System.console();
        if (console == null) {
            return;
        }
        PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)System.out, StandardCharsets.UTF_8));
        WelcomeMsgUtils.displayWelcomeMessage((int)80, (PrintWriter)writer);
        String version = AppInfo.getVersion();
        writer.printf("Server %s listening on %s%n", version, allListenersDescription);
        writer.println();
        writer.println("To access the KSQL CLI, run:");
        writer.println("ksql " + String.valueOf(this.getListeners().get(0)));
        writer.println();
        writer.flush();
    }

    private static void maybeCreateProcessingLogStream(ProcessingLogConfig processingLogConfig, KsqlConfig ksqlConfig, KsqlRestConfig restConfig, KsqlResource ksqlResource, ServiceContext serviceContext) {
        if (!processingLogConfig.getBoolean(ProcessingLogConfig.STREAM_AUTO_CREATE).booleanValue()) {
            return;
        }
        try {
            RestResponse response;
            ServerInternalKsqlClient internalClient = new ServerInternalKsqlClient(ksqlResource, new KsqlSecurityContext(Optional.empty(), serviceContext));
            URI serverEndpoint = ServerUtil.getServerAddress(restConfig);
            String processingLogStreamName = processingLogConfig.getString(ProcessingLogConfig.STREAM_NAME);
            if (!KsqlRestApplication.processingLogStreamExists(internalClient, serverEndpoint, processingLogStreamName) && (response = internalClient.makeKsqlRequest(serverEndpoint, ProcessingLogServerUtils.processingLogStreamCreateStatement(processingLogConfig, ksqlConfig), (Map)ImmutableMap.of())).isSuccessful()) {
                log.info("Successfully created processing log stream.");
            }
        }
        catch (Exception e) {
            log.error("Error while sending processing log CreateStream request to KsqlResource: ", (Throwable)e);
        }
    }

    private static boolean processingLogStreamExists(SimpleKsqlClient internalClient, URI serverEndpoint, String processingLogStreamName) {
        RestResponse listStreamsResponse = internalClient.makeKsqlRequest(serverEndpoint, "list streams;", (Map)ImmutableMap.of());
        List streams = ((StreamsList)((KsqlEntityList)listStreamsResponse.getResponse()).get(0)).getStreams();
        return streams.stream().anyMatch(stream -> stream.getName().equals(processingLogStreamName));
    }

    private static Optional<LocalCommands> createLocalCommands(KsqlRestConfig restConfig, KsqlEngine ksqlEngine) {
        if (!restConfig.getString("ksql.local.commands.location").isEmpty()) {
            File file = new File(restConfig.getString("ksql.local.commands.location"));
            return Optional.of(LocalCommands.open(ksqlEngine, file));
        }
        return Optional.empty();
    }

    @VisibleForTesting
    KsqlConfig buildConfigWithPort() {
        Map props = this.ksqlConfigNoPort.originals();
        props.put("ksql.streams.application.server", this.restConfig.getInterNodeListener(this::resolvePort).toString());
        return new KsqlConfig(props);
    }

    private int resolvePort(URL listener) {
        return this.getListeners().stream().filter(l -> l.getProtocol().equals(listener.getProtocol()) && l.getHost().equals(listener.getHost())).map(URL::getPort).findFirst().orElseThrow(() -> new IllegalStateException("Failed resolve port for listener: " + String.valueOf(listener)));
    }

    private static DropwizardMetricsOptions setUpHttpMetrics(KsqlConfig ksqlConfig) {
        String serviceId = ksqlConfig.getString("ksql.service.id");
        DropwizardMetricsOptions metricsOptions = new DropwizardMetricsOptions().setJmxEnabled(true).setBaseName("_confluent-ksql-" + serviceId).setJmxDomain("io.confluent.ksql.metrics");
        List<Match> matches = MonitoredEndpoints.getMonitoredEndpoints();
        for (Match match : matches) {
            metricsOptions.addMonitoredHttpServerUri(match);
        }
        return metricsOptions;
    }

    private static Admin createCommandTopicAdminClient(KsqlRestConfig ksqlRestConfig, KsqlConfig ksqlConfig) {
        HashMap<String, Object> adminClientConfigs = new HashMap<String, Object>(ksqlConfig.getKsqlAdminClientConfigProps());
        adminClientConfigs.putAll(ksqlRestConfig.getCommandProducerProperties());
        return new DefaultKafkaClientSupplier().getAdmin(adminClientConfigs);
    }

    private static /* synthetic */ ServiceContext lambda$buildApplication$9(KsqlRestConfig updatedRestConfig, Supplier schemaRegistryClientFactory, ConnectClientFactory connectClientFactory, KsqlClient sharedClient) {
        return RestServiceContextFactory.create(new KsqlConfig(updatedRestConfig.getKsqlConfigProperties()), Optional.empty(), schemaRegistryClientFactory, connectClientFactory, sharedClient, Collections.emptyList(), Optional.empty());
    }

    private static /* synthetic */ ServiceContext lambda$buildApplication$8(KsqlConfig ksqlConfig, Supplier schemaRegistryClientFactory, ConnectClientFactory connectClientFactory, KsqlClient sharedClient) {
        return RestServiceContextFactory.create(ksqlConfig, Optional.empty(), schemaRegistryClientFactory, connectClientFactory, sharedClient, Collections.emptyList(), Optional.empty());
    }

    static final class AbortApplicationStartException
    extends KsqlServerException {
        private AbortApplicationStartException(String message) {
            super(message);
        }
    }

    private static final class KsqlFailedPrecondition
    extends RuntimeException {
        private KsqlFailedPrecondition(String message) {
            super(message);
        }
    }
}

