/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.server;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.KsqlExecutionContext;
import io.confluent.ksql.api.auth.ApiSecurityContext;
import io.confluent.ksql.api.impl.InsertsStreamEndpoint;
import io.confluent.ksql.api.impl.KsqlSecurityContextProvider;
import io.confluent.ksql.api.impl.QueryEndpoint;
import io.confluent.ksql.api.server.InsertResult;
import io.confluent.ksql.api.server.InsertsStreamSubscriber;
import io.confluent.ksql.api.server.MetricsCallbackHolder;
import io.confluent.ksql.api.spi.Endpoints;
import io.confluent.ksql.engine.KsqlEngine;
import io.confluent.ksql.internal.PullQueryExecutorMetrics;
import io.confluent.ksql.reactive.BasePublisher;
import io.confluent.ksql.rest.EndpointResponse;
import io.confluent.ksql.rest.entity.ClusterTerminateRequest;
import io.confluent.ksql.rest.entity.HeartbeatMessage;
import io.confluent.ksql.rest.entity.KsqlMediaType;
import io.confluent.ksql.rest.entity.KsqlRequest;
import io.confluent.ksql.rest.entity.LagReportingMessage;
import io.confluent.ksql.rest.server.query.QueryExecutor;
import io.confluent.ksql.rest.server.resources.ClusterStatusResource;
import io.confluent.ksql.rest.server.resources.HealthCheckResource;
import io.confluent.ksql.rest.server.resources.HeartbeatResource;
import io.confluent.ksql.rest.server.resources.KsqlResource;
import io.confluent.ksql.rest.server.resources.LagReportingResource;
import io.confluent.ksql.rest.server.resources.ServerInfoResource;
import io.confluent.ksql.rest.server.resources.ServerMetadataResource;
import io.confluent.ksql.rest.server.resources.StatusResource;
import io.confluent.ksql.rest.server.resources.streaming.StreamedQueryResource;
import io.confluent.ksql.rest.server.resources.streaming.WSQueryEndpoint;
import io.confluent.ksql.rest.util.AuthenticationUtil;
import io.confluent.ksql.security.KsqlAuthTokenProvider;
import io.confluent.ksql.security.KsqlSecurityContext;
import io.confluent.ksql.util.KsqlConfig;
import io.confluent.ksql.util.ReservedInternalTopics;
import io.confluent.ksql.util.VertxCompletableFuture;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.WorkerExecutor;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.json.JsonObject;
import java.time.Clock;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

public class KsqlServerEndpoints
implements Endpoints {
    private final KsqlEngine ksqlEngine;
    private final KsqlConfig ksqlConfig;
    private final ReservedInternalTopics reservedInternalTopics;
    private final KsqlSecurityContextProvider ksqlSecurityContextProvider;
    private final KsqlResource ksqlResource;
    private final StreamedQueryResource streamedQueryResource;
    private final ServerInfoResource serverInfoResource;
    private final Optional<HeartbeatResource> heartbeatResource;
    private final Optional<ClusterStatusResource> clusterStatusResource;
    private final StatusResource statusResource;
    private final Optional<LagReportingResource> lagReportingResource;
    private final HealthCheckResource healthCheckResource;
    private final ServerMetadataResource serverMetadataResource;
    private final WSQueryEndpoint wsQueryEndpoint;
    private final Optional<PullQueryExecutorMetrics> pullQueryMetrics;
    private final QueryExecutor queryExecutor;
    private final Optional<KsqlAuthTokenProvider> authTokenProvider;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public KsqlServerEndpoints(KsqlEngine ksqlEngine, KsqlConfig ksqlConfig, KsqlSecurityContextProvider ksqlSecurityContextProvider, KsqlResource ksqlResource, StreamedQueryResource streamedQueryResource, ServerInfoResource serverInfoResource, Optional<HeartbeatResource> heartbeatResource, Optional<ClusterStatusResource> clusterStatusResource, StatusResource statusResource, Optional<LagReportingResource> lagReportingResource, HealthCheckResource healthCheckResource, ServerMetadataResource serverMetadataResource, WSQueryEndpoint wsQueryEndpoint, Optional<PullQueryExecutorMetrics> pullQueryMetrics, QueryExecutor queryExecutor, Optional<KsqlAuthTokenProvider> authTokenProvider) {
        this.ksqlEngine = Objects.requireNonNull(ksqlEngine);
        this.ksqlConfig = Objects.requireNonNull(ksqlConfig);
        this.reservedInternalTopics = new ReservedInternalTopics(ksqlConfig);
        this.ksqlSecurityContextProvider = Objects.requireNonNull(ksqlSecurityContextProvider);
        this.ksqlResource = Objects.requireNonNull(ksqlResource);
        this.streamedQueryResource = Objects.requireNonNull(streamedQueryResource);
        this.serverInfoResource = Objects.requireNonNull(serverInfoResource);
        this.heartbeatResource = Objects.requireNonNull(heartbeatResource);
        this.clusterStatusResource = Objects.requireNonNull(clusterStatusResource);
        this.statusResource = Objects.requireNonNull(statusResource);
        this.lagReportingResource = Objects.requireNonNull(lagReportingResource);
        this.healthCheckResource = Objects.requireNonNull(healthCheckResource);
        this.serverMetadataResource = Objects.requireNonNull(serverMetadataResource);
        this.wsQueryEndpoint = Objects.requireNonNull(wsQueryEndpoint);
        this.pullQueryMetrics = Objects.requireNonNull(pullQueryMetrics);
        this.queryExecutor = queryExecutor;
        this.authTokenProvider = authTokenProvider;
    }

    @Override
    public CompletableFuture<Publisher<?>> createQueryPublisher(String sql, Map<String, Object> properties, Map<String, Object> sessionVariables, Map<String, Object> requestProperties, Context context, WorkerExecutor workerExecutor, ApiSecurityContext apiSecurityContext, MetricsCallbackHolder metricsCallbackHolder, Optional<Boolean> isInternalRequest) {
        KsqlSecurityContext ksqlSecurityContext = this.ksqlSecurityContextProvider.provide(apiSecurityContext);
        return this.executeOnWorker(() -> {
            try {
                BasePublisher<?> basePublisher = new QueryEndpoint((KsqlExecutionContext)this.ksqlEngine, this.ksqlConfig, this.pullQueryMetrics, this.queryExecutor).createQueryPublisher(sql, properties, sessionVariables, requestProperties, context, workerExecutor, ksqlSecurityContext.getServiceContext(), metricsCallbackHolder, isInternalRequest);
                return basePublisher;
            }
            finally {
                ksqlSecurityContext.getServiceContext().close();
            }
        }, workerExecutor);
    }

    @Override
    public CompletableFuture<InsertsStreamSubscriber> createInsertsSubscriber(String target, JsonObject properties, Subscriber<InsertResult> acksSubscriber, Context context, WorkerExecutor workerExecutor, ApiSecurityContext apiSecurityContext) {
        return this.executeOnWorker(() -> new InsertsStreamEndpoint(this.ksqlEngine, this.ksqlConfig, this.reservedInternalTopics).createInsertsSubscriber(target, properties, acksSubscriber, context, workerExecutor, this.ksqlSecurityContextProvider.provide(apiSecurityContext).getServiceContext()), workerExecutor);
    }

    @Override
    public CompletableFuture<EndpointResponse> executeKsqlRequest(KsqlRequest request, WorkerExecutor workerExecutor, ApiSecurityContext apiSecurityContext) {
        return this.executeOldApiEndpointOnWorker(apiSecurityContext, ksqlSecurityContext -> this.ksqlResource.handleKsqlStatements((KsqlSecurityContext)ksqlSecurityContext, request), workerExecutor);
    }

    @Override
    public CompletableFuture<EndpointResponse> executeQueryRequest(KsqlRequest request, WorkerExecutor workerExecutor, CompletableFuture<Void> connectionClosedFuture, ApiSecurityContext apiSecurityContext, Optional<Boolean> isInternalRequest, KsqlMediaType mediaType, MetricsCallbackHolder metricsCallbackHolder, Context context) {
        return this.executeOldApiEndpointOnWorker(apiSecurityContext, ksqlSecurityContext -> this.streamedQueryResource.streamQuery((KsqlSecurityContext)ksqlSecurityContext, request, connectionClosedFuture, isInternalRequest, metricsCallbackHolder, context), workerExecutor);
    }

    @Override
    public CompletableFuture<EndpointResponse> executeTerminate(ClusterTerminateRequest request, WorkerExecutor workerExecutor, ApiSecurityContext apiSecurityContext) {
        return this.executeOldApiEndpointOnWorker(apiSecurityContext, ksqlSecurityContext -> this.ksqlResource.terminateCluster((KsqlSecurityContext)ksqlSecurityContext, request), workerExecutor);
    }

    @Override
    public CompletableFuture<EndpointResponse> executeInfo(ApiSecurityContext apiSecurityContext) {
        return this.executeOldApiEndpoint(apiSecurityContext, ksqlSecurityContext -> this.serverInfoResource.get());
    }

    @Override
    public CompletableFuture<EndpointResponse> executeHeartbeat(HeartbeatMessage heartbeatMessage, ApiSecurityContext apiSecurityContext) {
        return this.heartbeatResource.map(resource -> this.executeOldApiEndpoint(apiSecurityContext, ksqlSecurityContext -> resource.registerHeartbeat(heartbeatMessage))).orElseGet(() -> CompletableFuture.completedFuture(EndpointResponse.failed((int)HttpResponseStatus.NOT_FOUND.code())));
    }

    @Override
    public CompletableFuture<EndpointResponse> executeClusterStatus(ApiSecurityContext apiSecurityContext) {
        return this.clusterStatusResource.map(resource -> this.executeOldApiEndpoint(apiSecurityContext, ksqlSecurityContext -> resource.checkClusterStatus())).orElseGet(() -> CompletableFuture.completedFuture(EndpointResponse.failed((int)HttpResponseStatus.NOT_FOUND.code())));
    }

    @Override
    public CompletableFuture<EndpointResponse> executeStatus(String type, String entity, String action, ApiSecurityContext apiSecurityContext) {
        return this.executeOldApiEndpoint(apiSecurityContext, ksqlSecurityContext -> this.statusResource.getStatus(type, entity, action));
    }

    @Override
    public CompletableFuture<EndpointResponse> executeIsValidProperty(String property, WorkerExecutor workerExecutor, ApiSecurityContext apiSecurityContext) {
        return this.executeOldApiEndpointOnWorker(apiSecurityContext, ksqlSecurityContext -> this.ksqlResource.isValidProperty(property), workerExecutor);
    }

    @Override
    public CompletableFuture<EndpointResponse> executeAllStatuses(ApiSecurityContext apiSecurityContext) {
        return this.executeOldApiEndpoint(apiSecurityContext, ksqlSecurityContext -> this.statusResource.getAllStatuses());
    }

    @Override
    public CompletableFuture<EndpointResponse> executeLagReport(LagReportingMessage lagReportingMessage, ApiSecurityContext apiSecurityContext) {
        return this.lagReportingResource.map(resource -> this.executeOldApiEndpoint(apiSecurityContext, ksqlSecurityContext -> resource.receiveHostLag(lagReportingMessage))).orElseGet(() -> CompletableFuture.completedFuture(EndpointResponse.failed((int)HttpResponseStatus.NOT_FOUND.code())));
    }

    @Override
    public CompletableFuture<EndpointResponse> executeCheckHealth(ApiSecurityContext apiSecurityContext) {
        return this.executeOldApiEndpoint(apiSecurityContext, ksqlSecurityContext -> this.healthCheckResource.checkHealth());
    }

    @Override
    public CompletableFuture<EndpointResponse> executeServerMetadata(ApiSecurityContext apiSecurityContext) {
        return this.executeOldApiEndpoint(apiSecurityContext, ksqlSecurityContext -> this.serverMetadataResource.getServerMetadata());
    }

    @Override
    public CompletableFuture<EndpointResponse> executeServerMetadataClusterId(ApiSecurityContext apiSecurityContext) {
        return this.executeOldApiEndpoint(apiSecurityContext, ksqlSecurityContext -> this.serverMetadataResource.getServerClusterId());
    }

    @Override
    public void executeWebsocketStream(ServerWebSocket webSocket, MultiMap requestParams, WorkerExecutor workerExecutor, ApiSecurityContext apiSecurityContext, Context context) {
        this.executeOnWorker(() -> {
            KsqlSecurityContext ksqlSecurityContext = this.ksqlSecurityContextProvider.provide(apiSecurityContext);
            try {
                this.wsQueryEndpoint.executeStreamQuery(webSocket, requestParams, ksqlSecurityContext, context, new AuthenticationUtil(Clock.systemUTC()).getTokenTimeout(apiSecurityContext.getAuthHeader(), this.ksqlConfig, this.authTokenProvider));
            }
            finally {
                ksqlSecurityContext.getServiceContext().close();
            }
            return null;
        }, workerExecutor);
    }

    @Override
    public CompletableFuture<EndpointResponse> executeTest(String test, ApiSecurityContext apiSecurityContext) {
        return this.executeOldApiEndpoint(apiSecurityContext, ksqlSecurityContext -> this.ksqlResource.runTest(test));
    }

    private <R> CompletableFuture<R> executeOnWorker(Supplier<R> supplier, WorkerExecutor workerExecutor) {
        VertxCompletableFuture vcf = new VertxCompletableFuture();
        workerExecutor.executeBlocking(promise -> promise.complete(supplier.get()), false, (Handler)vcf);
        return vcf;
    }

    private CompletableFuture<EndpointResponse> executeOldApiEndpointOnWorker(ApiSecurityContext apiSecurityContext, Function<KsqlSecurityContext, EndpointResponse> functionCall, WorkerExecutor workerExecutor) {
        KsqlSecurityContext ksqlSecurityContext = this.ksqlSecurityContextProvider.provide(apiSecurityContext);
        return this.executeOnWorker(() -> {
            try {
                EndpointResponse endpointResponse = (EndpointResponse)functionCall.apply(ksqlSecurityContext);
                return endpointResponse;
            }
            finally {
                ksqlSecurityContext.getServiceContext().close();
            }
        }, workerExecutor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<EndpointResponse> executeOldApiEndpoint(ApiSecurityContext apiSecurityContext, Function<KsqlSecurityContext, EndpointResponse> functionCall) {
        KsqlSecurityContext ksqlSecurityContext = this.ksqlSecurityContextProvider.provide(apiSecurityContext);
        try {
            CompletableFuture<EndpointResponse> completableFuture = CompletableFuture.completedFuture(functionCall.apply(ksqlSecurityContext));
            return completableFuture;
        }
        finally {
            ksqlSecurityContext.getServiceContext().close();
        }
    }
}

