/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.server;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.AbstractScheduledService;
import com.google.common.util.concurrent.ServiceManager;
import io.confluent.ksql.engine.KsqlEngine;
import io.confluent.ksql.rest.entity.HostStoreLags;
import io.confluent.ksql.rest.entity.KsqlHostInfoEntity;
import io.confluent.ksql.rest.entity.LagInfoEntity;
import io.confluent.ksql.rest.entity.LagReportingMessage;
import io.confluent.ksql.rest.entity.QueryStateStoreId;
import io.confluent.ksql.rest.entity.StateStoreLags;
import io.confluent.ksql.rest.server.HeartbeatAgent;
import io.confluent.ksql.rest.server.ServerUtil;
import io.confluent.ksql.services.ServiceContext;
import io.confluent.ksql.util.HostStatus;
import io.confluent.ksql.util.KsqlHostInfo;
import io.confluent.ksql.util.Pair;
import io.confluent.ksql.util.PersistentQueryMetadata;
import java.net.URI;
import java.net.URL;
import java.time.Clock;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.kafka.streams.LagInfo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class LagReportingAgent
implements HeartbeatAgent.HostStatusListener {
    private static final int SERVICE_TIMEOUT_SEC = 2;
    private static final int NUM_THREADS_EXECUTOR = 1;
    private static final int SEND_LAG_DELAY_MS = 100;
    private static final Logger LOG = LogManager.getLogger(LagReportingAgent.class);
    private final KsqlEngine engine;
    private final ScheduledExecutorService scheduledExecutorService;
    private final ServiceContext serviceContext;
    private final LagReportingConfig config;
    private final ServiceManager serviceManager;
    private final Clock clock;
    private final Map<KsqlHostInfo, HostStoreLags> receivedLagInfo;
    private final AtomicReference<Set<KsqlHostInfo>> aliveHostsRef;
    private URL localUrl;

    public static Builder builder() {
        return new Builder();
    }

    private LagReportingAgent(KsqlEngine engine, ScheduledExecutorService scheduledExecutorService, ServiceContext serviceContext, LagReportingConfig config, Clock clock) {
        this.engine = Objects.requireNonNull(engine, "engine");
        this.scheduledExecutorService = scheduledExecutorService;
        this.serviceContext = Objects.requireNonNull(serviceContext, "serviceContext");
        this.config = Objects.requireNonNull(config, "configuration parameters");
        this.clock = clock;
        this.serviceManager = new ServiceManager(Arrays.asList(new SendLagService()));
        this.receivedLagInfo = new ConcurrentHashMap<KsqlHostInfo, HostStoreLags>();
        this.aliveHostsRef = new AtomicReference(Collections.emptySet());
    }

    void setLocalAddress(String applicationServer) {
        try {
            this.localUrl = new URL(applicationServer);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to convert remote host info to URL. remoteInfo: " + applicationServer);
        }
    }

    void startAgent() {
        try {
            this.serviceManager.startAsync().awaitHealthy(2L, TimeUnit.SECONDS);
        }
        catch (IllegalStateException | TimeoutException e) {
            LOG.error("Failed to start heartbeat services with exception " + e.getMessage(), (Throwable)e);
        }
    }

    void stopAgent() {
        try {
            this.serviceManager.stopAsync().awaitStopped(2L, TimeUnit.SECONDS);
        }
        catch (IllegalStateException | TimeoutException e) {
            LOG.error("Failed to stop heartbeat services with exception " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.scheduledExecutorService.shutdownNow();
        }
    }

    public void receiveHostLag(LagReportingMessage lagReportingMessage) {
        HostStoreLags hostStoreLags = lagReportingMessage.getHostStoreLags();
        long updateTimeMs = hostStoreLags.getUpdateTimeMs();
        KsqlHostInfoEntity KsqlHostInfoEntity2 = lagReportingMessage.getKsqlHost();
        KsqlHostInfo KsqlHostInfo2 = KsqlHostInfoEntity2.toKsqlHost();
        LOG.debug("Receive lag at: {} from host: {} lag: {} ", (Object)updateTimeMs, (Object)KsqlHostInfoEntity2, (Object)hostStoreLags.getStateStoreLags());
        this.receivedLagInfo.compute(KsqlHostInfo2, (hi, previousHostLagInfo) -> previousHostLagInfo != null && previousHostLagInfo.getUpdateTimeMs() > updateTimeMs ? previousHostLagInfo : hostStoreLags);
    }

    public Optional<LagInfoEntity> getLagInfoForHost(KsqlHostInfo host, QueryStateStoreId queryStateStoreId, int partition) {
        return this.getLagPerHost(host).flatMap(hostStoreLags -> hostStoreLags.getStateStoreLags(queryStateStoreId)).flatMap(stateStoreLags -> stateStoreLags.getLagByPartition(partition));
    }

    public ImmutableMap<KsqlHostInfoEntity, HostStoreLags> getAllLags() {
        return (ImmutableMap)this.receivedLagInfo.entrySet().stream().collect(ImmutableMap.toImmutableMap(e -> new KsqlHostInfoEntity(((KsqlHostInfo)e.getKey()).host(), ((KsqlHostInfo)e.getKey()).port()), Map.Entry::getValue));
    }

    public Optional<HostStoreLags> getLagPerHost(KsqlHostInfo host) {
        return Optional.ofNullable(this.receivedLagInfo.get(host));
    }

    @Override
    public void onHostStatusUpdated(Map<KsqlHostInfo, HostStatus> hostsStatusMap) {
        this.aliveHostsRef.set((Set)hostsStatusMap.entrySet().stream().filter(entry -> ((HostStatus)entry.getValue()).isHostAlive()).map(Map.Entry::getKey).collect(ImmutableSet.toImmutableSet()));
    }

    public static class Builder {
        private long nestedLagSendIntervalMs = 500L;
        private Clock nestedClock = Clock.systemUTC();

        Builder lagSendIntervalMs(long interval) {
            this.nestedLagSendIntervalMs = interval;
            return this;
        }

        Builder clock(Clock clock) {
            this.nestedClock = clock;
            return this;
        }

        public LagReportingAgent build(KsqlEngine engine, ServiceContext serviceContext) {
            ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1);
            return new LagReportingAgent(engine, scheduledExecutorService, serviceContext, new LagReportingConfig(this.nestedLagSendIntervalMs), this.nestedClock);
        }
    }

    static class LagReportingConfig {
        private final long lagSendIntervalMs;

        LagReportingConfig(long lagSendIntervalMs) {
            this.lagSendIntervalMs = lagSendIntervalMs;
        }
    }

    class SendLagService
    extends AbstractScheduledService {
        SendLagService() {
        }

        protected void runOneIteration() {
            try {
                this.sendLagsToAliveHosts();
            }
            catch (Throwable t) {
                LOG.error("Failed to send lags", t);
            }
        }

        protected void sendLagsToAliveHosts() {
            List currentQueries = LagReportingAgent.this.engine.getPersistentQueries();
            if (currentQueries.isEmpty()) {
                return;
            }
            Map<QueryStateStoreId, Map<Integer, LagInfo>> localLagMap = currentQueries.stream().map(qm -> Pair.of((Object)qm, (Object)qm.getAllLocalStorePartitionLags())).map(pair -> ((Map)pair.getRight()).entrySet().stream().collect(Collectors.toMap(e -> QueryStateStoreId.of((String)((PersistentQueryMetadata)pair.getLeft()).getQueryId().toString(), (String)((String)e.getKey())), Map.Entry::getValue))).flatMap(map -> map.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            LagReportingMessage message = this.createLagReportingMessage(localLagMap);
            Set<KsqlHostInfo> aliveHosts = LagReportingAgent.this.aliveHostsRef.get();
            for (KsqlHostInfo host : aliveHosts) {
                try {
                    URI remoteUri = ServerUtil.buildRemoteUri(LagReportingAgent.this.localUrl, host.host(), host.port());
                    LOG.debug("Sending lag to host {} at {}", (Object)host.host(), (Object)LagReportingAgent.this.clock.millis());
                    LagReportingAgent.this.serviceContext.getKsqlClient().makeAsyncLagReportRequest(remoteUri, message);
                }
                catch (Throwable t) {
                    LOG.error("Request to server: " + host.host() + ":" + host.port() + " failed with exception: " + t.getMessage(), t);
                }
            }
        }

        private LagReportingMessage createLagReportingMessage(Map<QueryStateStoreId, Map<Integer, LagInfo>> lagMap) {
            ImmutableMap.Builder map = ImmutableMap.builder();
            for (Map.Entry<QueryStateStoreId, Map<Integer, LagInfo>> storeEntry : lagMap.entrySet()) {
                ImmutableMap partitionMap = (ImmutableMap)storeEntry.getValue().entrySet().stream().map(partitionEntry -> {
                    LagInfo lagInfo = (LagInfo)partitionEntry.getValue();
                    return Pair.of((Object)((Integer)partitionEntry.getKey()), (Object)new LagInfoEntity(lagInfo.currentOffsetPosition(), lagInfo.endOffsetPosition(), lagInfo.offsetLag()));
                }).collect(ImmutableMap.toImmutableMap(Pair::getLeft, Pair::getRight));
                map.put((Object)storeEntry.getKey(), (Object)new StateStoreLags((Map)partitionMap));
            }
            return new LagReportingMessage(new KsqlHostInfoEntity(LagReportingAgent.this.localUrl.getHost(), LagReportingAgent.this.localUrl.getPort()), new HostStoreLags((Map)map.build(), LagReportingAgent.this.clock.millis()));
        }

        protected AbstractScheduledService.Scheduler scheduler() {
            return AbstractScheduledService.Scheduler.newFixedRateSchedule((long)100L, (long)LagReportingAgent.this.config.lagSendIntervalMs, (TimeUnit)TimeUnit.MILLISECONDS);
        }

        protected ScheduledExecutorService executor() {
            return LagReportingAgent.this.scheduledExecutorService;
        }
    }
}

