/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.server;

import com.github.rvesse.airline.HelpOption;
import com.github.rvesse.airline.annotations.Arguments;
import com.github.rvesse.airline.annotations.Command;
import com.github.rvesse.airline.annotations.Option;
import com.github.rvesse.airline.annotations.restrictions.Required;
import io.confluent.ksql.rest.util.OptionsParser;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

@Command(name="server", description="KSQL Cluster")
public class ServerOptions {
    static final String QUERIES_FILE_CONFIG = "ksql.queries.file";
    @Inject
    public HelpOption<?> help;
    @Required
    @Arguments(title={"config-file"}, description="A file specifying configs for the KSQL Server, KSQL, and its underlying Kafka Streams instance(s). Refer to KSQL documentation for a list of available configs.")
    private List<String> propertiesFile;
    @Option(name={"--queries-file"}, description="Path to the query file on the local machine.")
    private String queriesFile;

    List<File> getPropertiesFile() {
        return this.propertiesFile.stream().map(File::new).collect(Collectors.toList());
    }

    Optional<String> getQueriesFile(Map<String, String> properties) {
        if (this.queriesFile != null) {
            return Optional.of(this.queriesFile);
        }
        return Optional.ofNullable(properties.get(QUERIES_FILE_CONFIG));
    }

    public static ServerOptions parse(String ... args) throws IOException {
        return OptionsParser.parse(args, ServerOptions.class);
    }
}

