/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.server;

import io.confluent.ksql.rest.server.KsqlRestConfig;
import io.confluent.ksql.util.KsqlException;
import java.net.URI;
import java.net.URL;
import java.util.List;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.processor.internals.StreamsMetadataState;
import org.apache.kafka.streams.state.HostInfo;

public final class ServerUtil {
    private ServerUtil() {
    }

    public static URI getServerAddress(KsqlRestConfig restConfig) {
        List listeners = restConfig.getList("listeners");
        String address = listeners.stream().map(String::trim).findFirst().orElseThrow(() -> new ConfigException("listeners", (Object)listeners, "value cannot be empty"));
        try {
            return new URL(address).toURI();
        }
        catch (Exception e) {
            throw new ConfigException("listeners", (Object)listeners, e.getMessage());
        }
    }

    public static HostInfo parseHostInfo(String applicationServerId) {
        if (applicationServerId == null || applicationServerId.trim().isEmpty()) {
            return StreamsMetadataState.UNKNOWN_HOST;
        }
        String serverId = applicationServerId.endsWith("/") ? applicationServerId.substring(0, applicationServerId.lastIndexOf("/")) : applicationServerId;
        String host = Utils.getHost((String)serverId);
        Integer port = Utils.getPort((String)serverId);
        if (host == null || port == null) {
            throw new KsqlException(String.format("Error parsing host address %s. Expected format host:port.", applicationServerId));
        }
        return new HostInfo(host, port.intValue());
    }

    public static URI buildRemoteUri(URL localHost, String remoteHost, int remotePort) {
        try {
            return new URL(localHost.getProtocol(), remoteHost, remotePort, "/").toURI();
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to convert remote host info to URL. remoteInfo: " + remoteHost + ":" + remotePort);
        }
    }
}

