/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.server.computation;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.config.SessionConfig;
import io.confluent.ksql.engine.KsqlPlan;
import io.confluent.ksql.planner.plan.ConfiguredKsqlPlan;
import io.confluent.ksql.properties.PropertiesUtil;
import io.confluent.ksql.rest.server.resources.IncompatibleKsqlCommandVersionException;
import io.confluent.ksql.statement.ConfiguredStatement;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonSubTypes(value={})
public class Command {
    @VisibleForTesting
    public static final int VERSION = 18;
    private final String statement;
    private final Map<String, Object> overwriteProperties;
    private final Map<String, String> originalProperties;
    private final Optional<KsqlPlan> plan;
    private final Optional<Integer> version;

    @JsonCreator
    public Command(@JsonProperty(value="statement", required=true) String statement, @JsonProperty(value="streamsProperties") Optional<Map<String, Object>> overwriteProperties, @JsonProperty(value="originalProperties") Optional<Map<String, String>> originalProperties, @JsonProperty(value="plan") Optional<KsqlPlan> plan, @JsonProperty(value="version") Optional<Integer> version) {
        this(statement, overwriteProperties.orElseGet(ImmutableMap::of), originalProperties.orElseGet(ImmutableMap::of), plan, version, 18);
    }

    @VisibleForTesting
    public Command(String statement, Map<String, Object> overwriteProperties, Map<String, String> originalProperties, Optional<KsqlPlan> plan) {
        this(statement, overwriteProperties, originalProperties, plan, Optional.of(18), 18);
    }

    @VisibleForTesting
    public Command(String statement, Map<String, Object> overwriteProperties, Map<String, String> originalProperties, Optional<KsqlPlan> plan, Optional<Integer> version, int expectedVersion) {
        this.statement = Objects.requireNonNull(statement, "statement");
        this.overwriteProperties = Collections.unmodifiableMap(Objects.requireNonNull(overwriteProperties, "overwriteProperties"));
        this.originalProperties = Collections.unmodifiableMap(Objects.requireNonNull(originalProperties, "originalProperties"));
        this.plan = Objects.requireNonNull(plan, "plan");
        this.version = Objects.requireNonNull(version, "version");
        if (expectedVersion < version.orElse(0)) {
            throw new IncompatibleKsqlCommandVersionException("Received a command from an incompatible command topic version. Expected version less than or equal to " + expectedVersion + " but got " + String.valueOf(version.orElse(0)));
        }
    }

    public String getStatement() {
        return this.statement;
    }

    @JsonProperty(value="streamsProperties")
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="overwriteProperties is unmodifiableMap()")
    public Map<String, Object> getOverwriteProperties() {
        return PropertiesUtil.coerceTypes(this.overwriteProperties, (boolean)true);
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="originalProperties is unmodifiableMap()")
    public Map<String, String> getOriginalProperties() {
        return this.originalProperties;
    }

    public Optional<KsqlPlan> getPlan() {
        return this.plan;
    }

    public Optional<Integer> getVersion() {
        return this.version;
    }

    public static Command of(ConfiguredKsqlPlan configuredPlan) {
        return new Command(configuredPlan.getPlan().getStatementText(), configuredPlan.getConfig().getOverrides(), configuredPlan.getConfig().getConfig(false).getAllConfigPropsWithSecretsObfuscated(), Optional.of(configuredPlan.getPlan()), Optional.of(18), 18);
    }

    public static Command of(ConfiguredStatement<?> configuredStatement) {
        SessionConfig sessionConfig = configuredStatement.getSessionConfig();
        return new Command(configuredStatement.getUnMaskedStatementText(), sessionConfig.getOverrides(), sessionConfig.getConfig(false).getAllConfigPropsWithSecretsObfuscated(), Optional.empty(), Optional.of(18), 18);
    }

    public boolean equals(Object o) {
        return o instanceof Command && Objects.equals(this.statement, ((Command)o).statement) && Objects.equals(this.overwriteProperties, ((Command)o).overwriteProperties) && Objects.equals(this.originalProperties, ((Command)o).originalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.statement, this.overwriteProperties, this.originalProperties);
    }

    public String toString() {
        return "Command{statement='" + this.statement + "', overwriteProperties=" + String.valueOf(this.overwriteProperties) + ", version=" + String.valueOf(this.version) + "}";
    }
}

