/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.server.computation;

import io.confluent.ksql.analyzer.Analysis;
import io.confluent.ksql.engine.rewrite.DataSourceExtractor;
import io.confluent.ksql.metastore.MetaStore;
import io.confluent.ksql.metastore.model.DataSource;
import io.confluent.ksql.parser.tree.AstNode;
import io.confluent.ksql.parser.tree.CreateAsSelect;
import io.confluent.ksql.parser.tree.Join;
import io.confluent.ksql.parser.tree.JoinedSource;
import io.confluent.ksql.parser.tree.Query;
import io.confluent.ksql.parser.tree.Relation;
import io.confluent.ksql.parser.tree.Statement;
import io.confluent.ksql.parser.tree.WithinExpression;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DeprecatedStatementsChecker {
    private static final Logger LOG = LogManager.getLogger(DeprecatedStatementsChecker.class);
    final MetaStore metaStore;

    DeprecatedStatementsChecker(MetaStore metaStore) {
        this.metaStore = Objects.requireNonNull(metaStore, "metaStore");
    }

    public Optional<Deprecations> checkStatement(Statement statement) {
        if (this.isStreamStreamJoinWithoutGraceStatement(statement)) {
            return Optional.of(Deprecations.DEPRECATED_STREAM_STREAM_JOIN_WITH_NO_GRACE);
        }
        return Optional.empty();
    }

    private boolean isStreamStreamJoinWithoutGraceStatement(Statement statement) {
        if (statement instanceof CreateAsSelect) {
            return this.isStreamStreamJoinWithoutGraceQuery(((CreateAsSelect)statement).getQuery());
        }
        if (statement instanceof Query) {
            return this.isStreamStreamJoinWithoutGraceQuery((Query)statement);
        }
        return false;
    }

    private boolean isStreamStreamJoinWithoutGraceQuery(Query query) {
        if (query.getFrom() instanceof Join) {
            Join join = (Join)query.getFrom();
            if (!this.isStream(join.getLeft())) {
                return false;
            }
            for (JoinedSource joinedSource : join.getRights()) {
                if (!this.isStream(joinedSource.getRelation()) || joinedSource.getWithinExpression().flatMap(WithinExpression::getGrace).isPresent()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isStream(Relation relation) {
        DataSourceExtractor dataSourceExtractor = new DataSourceExtractor(this.metaStore);
        Set sources = dataSourceExtractor.extractDataSources((AstNode)relation);
        if (sources.size() > 1) {
            LOG.warn("The deprecation statement checker has detected an internal join source with more than one relation. This might be a bug in the deprecation checker or other part of  the code. Report this bug to the ksqlDB support team.");
        }
        for (Analysis.AliasedDataSource source : sources) {
            if (source.getDataSource().getDataSourceType() == DataSource.DataSourceType.KSTREAM) continue;
            return false;
        }
        return true;
    }

    public static enum Deprecations {
        DEPRECATED_STREAM_STREAM_JOIN_WITH_NO_GRACE("DEPRECATION NOTICE: Stream-stream joins statements without a GRACE PERIOD will not be accepted in a future ksqlDB version.\nPlease use the GRACE PERIOD clause as specified in https://docs.ksqldb.io/en/latest/developer-guide/ksqldb-reference/select-push-query/");

        private final String noticeMessage;

        private Deprecations(String noticeMessage) {
            this.noticeMessage = noticeMessage;
        }

        public String getNoticeMessage() {
            return this.noticeMessage;
        }
    }
}

