/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.server.computation;

import io.confluent.ksql.rest.entity.CommandId;
import io.confluent.ksql.rest.entity.CommandStatus;
import io.confluent.ksql.rest.server.computation.CommandStatusFuture;
import java.time.Duration;
import java.util.Objects;

public class QueuedCommandStatus {
    private final CommandStatusFuture commandStatusFuture;
    private final long commandSequenceNumber;

    public QueuedCommandStatus(long commandSequenceNumber, CommandStatusFuture commandStatusFuture) {
        this.commandSequenceNumber = Objects.requireNonNull(Long.valueOf(commandSequenceNumber), "commandSequenceNumber");
        this.commandStatusFuture = Objects.requireNonNull(commandStatusFuture, "commandStatusFuture");
    }

    public CommandStatus getStatus() {
        return this.commandStatusFuture.getStatus();
    }

    public CommandId getCommandId() {
        return this.commandStatusFuture.getCommandId();
    }

    public long getCommandSequenceNumber() {
        return this.commandSequenceNumber;
    }

    public CommandStatus tryWaitForFinalStatus(Duration timeout) throws InterruptedException {
        return this.commandStatusFuture.tryWaitForFinalStatus(timeout);
    }
}

