/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.server.computation;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.collect.ImmutableMap;
import io.confluent.ksql.KsqlExecutionContext;
import io.confluent.ksql.config.ConfigItem;
import io.confluent.ksql.config.KsqlConfigResolver;
import io.confluent.ksql.config.SessionConfig;
import io.confluent.ksql.engine.KsqlPlan;
import io.confluent.ksql.execution.json.PlanJsonMapper;
import io.confluent.ksql.parser.tree.AlterSystemProperty;
import io.confluent.ksql.parser.tree.PauseQuery;
import io.confluent.ksql.parser.tree.ResumeQuery;
import io.confluent.ksql.parser.tree.Statement;
import io.confluent.ksql.parser.tree.TerminateQuery;
import io.confluent.ksql.planner.plan.ConfiguredKsqlPlan;
import io.confluent.ksql.query.QueryId;
import io.confluent.ksql.rest.entity.PropertiesList;
import io.confluent.ksql.rest.server.computation.Command;
import io.confluent.ksql.services.ServiceContext;
import io.confluent.ksql.statement.ConfiguredStatement;
import io.confluent.ksql.util.KsqlConstants;
import io.confluent.ksql.util.KsqlServerException;
import io.confluent.ksql.util.KsqlStatementException;
import io.confluent.ksql.util.PersistentQueryMetadata;
import io.confluent.ksql.util.PersistentQueryMetadataImpl;
import io.confluent.ksql.util.QueryMetadata;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.kafka.common.config.ConfigException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ValidatedCommandFactory {
    private static final Logger LOG = LogManager.getLogger(ValidatedCommandFactory.class);

    public Command create(ConfiguredStatement<? extends Statement> statement, KsqlExecutionContext context) {
        return this.create(statement, context.getServiceContext(), context);
    }

    public Command create(ConfiguredStatement<? extends Statement> statement, ServiceContext serviceContext, KsqlExecutionContext context) {
        return ValidatedCommandFactory.ensureDeserializable(ValidatedCommandFactory.createCommand(statement, serviceContext, context));
    }

    private static Command ensureDeserializable(Command command) {
        try {
            String json = PlanJsonMapper.INSTANCE.get().writeValueAsString((Object)command);
            PlanJsonMapper.INSTANCE.get().readValue(json, Command.class);
            return command;
        }
        catch (JsonProcessingException e) {
            throw new KsqlServerException("Did not write the command to the command topic as it could not be deserialized. This is a bug! Please raise a Github issue containing the series of commands you ran to get to this point." + System.lineSeparator() + e.getMessage());
        }
    }

    private static Command createCommand(ConfiguredStatement<? extends Statement> statement, ServiceContext serviceContext, KsqlExecutionContext context) {
        if (statement.getUnMaskedStatementText().equals("TERMINATE CLUSTER;")) {
            return ValidatedCommandFactory.createForTerminateCluster(statement);
        }
        if (statement.getStatement() instanceof PauseQuery) {
            return ValidatedCommandFactory.createForPauseQuery(statement, context);
        }
        if (statement.getStatement() instanceof ResumeQuery) {
            return ValidatedCommandFactory.createForResumeQuery(statement, context);
        }
        if (statement.getStatement() instanceof TerminateQuery) {
            return ValidatedCommandFactory.createForTerminateQuery(statement, context);
        }
        if (statement.getStatement() instanceof AlterSystemProperty) {
            return ValidatedCommandFactory.createForAlterSystemQuery(statement, context);
        }
        return ValidatedCommandFactory.createForPlannedQuery((ConfiguredStatement<? extends Statement>)statement.withConfig(context.getKsqlConfig()), serviceContext, context);
    }

    private static Command createForAlterSystemQuery(ConfiguredStatement<? extends Statement> statement, KsqlExecutionContext context) {
        AlterSystemProperty alterSystemProperty = (AlterSystemProperty)statement.getStatement();
        String propertyName = alterSystemProperty.getPropertyName();
        String propertyValue = alterSystemProperty.getPropertyValue();
        if (!context.getKsqlConfig().getBoolean("ksql.runtime.feature.shared.enabled").booleanValue()) {
            throw new KsqlServerException("Cannot alter system configs when KSQL_SHARED_RUNTIME_ENABLED is turned off.");
        }
        context.alterSystemProperty(propertyName, propertyValue);
        if (!PropertiesList.Property.isEditable((String)propertyName)) {
            throw new ConfigException(String.format("Failed to set %s to %s. Caused by: Not recognizable as ksql, streams, consumer, or producer property: %s %n", propertyName, propertyValue, propertyName), null);
        }
        KsqlConfigResolver resolver = new KsqlConfigResolver();
        Optional resolvedItem = resolver.resolve(propertyName, false);
        if (resolvedItem.isPresent() && Objects.equals(((ConfigItem)resolvedItem.get()).getPropertyName(), "processing.guarantee") && !context.getPersistentQueries().isEmpty()) {
            Collection runningQueries = context.getPersistentQueries().stream().map(QueryMetadata::getQueryId).collect(Collectors.toList());
            LOG.error("Failed to set {} to {} due to the {} persistent queries currently running: {}", (Object)propertyName, (Object)propertyValue, (Object)runningQueries.size(), (Object)runningQueries);
            throw new ConfigException(String.format("Unable to set %s to %s, as the %s may not be changed for running persistent queries which have already processed data under a different %s. To modify %s you must first terminate all running persistent queries.", propertyName, propertyValue, propertyName, propertyName, propertyName));
        }
        return Command.of(statement);
    }

    private static Command createForPauseQuery(ConfiguredStatement<? extends Statement> statement, KsqlExecutionContext context) {
        PauseQuery pauseQuery = (PauseQuery)statement.getStatement();
        Optional queryId = pauseQuery.getQueryId();
        if (!queryId.isPresent()) {
            context.getPersistentQueries().forEach(QueryMetadata::pause);
            return Command.of(statement);
        }
        if (((QueryId)queryId.get()).toString().toLowerCase().contains("transient_")) {
            return Command.of(statement);
        }
        PersistentQueryMetadata queryMetadata = (PersistentQueryMetadata)context.getPersistentQuery((QueryId)queryId.get()).orElseThrow(() -> new KsqlStatementException("Unknown queryId: " + String.valueOf(queryId.get()), statement.getMaskedStatementText()));
        if (queryMetadata.getPersistentQueryType() == KsqlConstants.PersistentQueryType.CREATE_SOURCE) {
            throw new KsqlStatementException(String.format("Cannot pause query '%s' because it is linked to a source table.", queryId.get()), statement.getMaskedStatementText());
        }
        queryMetadata.pause();
        return Command.of(statement);
    }

    private static Command createForResumeQuery(ConfiguredStatement<? extends Statement> statement, KsqlExecutionContext context) {
        ResumeQuery resumeQuery = (ResumeQuery)statement.getStatement();
        Optional queryId = resumeQuery.getQueryId();
        if (!queryId.isPresent()) {
            context.getPersistentQueries().forEach(QueryMetadata::resume);
            return Command.of(statement);
        }
        if (((QueryId)queryId.get()).toString().toLowerCase().contains("transient_")) {
            return Command.of(statement);
        }
        PersistentQueryMetadata queryMetadata = (PersistentQueryMetadata)context.getPersistentQuery((QueryId)queryId.get()).orElseThrow(() -> new KsqlStatementException("Unknown queryId: " + String.valueOf(queryId.get()), statement.getMaskedStatementText()));
        if (queryMetadata.getPersistentQueryType() == KsqlConstants.PersistentQueryType.CREATE_SOURCE) {
            throw new KsqlStatementException(String.format("Cannot resume query '%s' because it is linked to a source table.", queryId.get()), statement.getMaskedStatementText());
        }
        queryMetadata.resume();
        return Command.of(statement);
    }

    private static Command createForTerminateQuery(ConfiguredStatement<? extends Statement> statement, KsqlExecutionContext context) {
        TerminateQuery terminateQuery = (TerminateQuery)statement.getStatement();
        Optional queryId = terminateQuery.getQueryId();
        if (!queryId.isPresent()) {
            context.getPersistentQueries().forEach(QueryMetadata::close);
            return Command.of(statement);
        }
        if (((QueryId)queryId.get()).toString().toLowerCase().contains("transient_")) {
            return Command.of(statement);
        }
        PersistentQueryMetadata queryMetadata = (PersistentQueryMetadata)context.getPersistentQuery((QueryId)queryId.get()).orElseThrow(() -> new KsqlStatementException("Unknown queryId: " + String.valueOf(queryId.get()), statement.getMaskedStatementText()));
        if (queryMetadata.getPersistentQueryType() == KsqlConstants.PersistentQueryType.CREATE_SOURCE) {
            throw new KsqlStatementException(String.format("Cannot terminate query '%s' because it is linked to a source table.", queryId.get()), statement.getMaskedStatementText());
        }
        queryMetadata.close();
        return Command.of(statement);
    }

    public static Command createForTerminateCluster(ConfiguredStatement statement) {
        return Command.of(statement);
    }

    private static Command createForPlannedQuery(ConfiguredStatement<? extends Statement> statement, ServiceContext serviceContext, KsqlExecutionContext context) {
        KsqlPlan plan = context.plan(serviceContext, statement);
        ConfiguredKsqlPlan configuredPlan = ConfiguredKsqlPlan.of((KsqlPlan)plan, (SessionConfig)statement.getSessionConfig());
        KsqlExecutionContext.ExecuteResult result = context.execute(serviceContext, configuredPlan);
        if (result.getQuery().isPresent() && result.getQuery().get() instanceof PersistentQueryMetadataImpl && configuredPlan.getConfig().getConfig(false).getBoolean("ksql.runtime.feature.shared.enabled").booleanValue()) {
            configuredPlan = ConfiguredKsqlPlan.of((KsqlPlan)plan, (SessionConfig)statement.getSessionConfig().copyWith((Map)ImmutableMap.of((Object)"ksql.runtime.feature.shared.enabled", (Object)false)));
        }
        return Command.of(configuredPlan);
    }
}

