/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.server.execution;

import com.google.common.collect.ImmutableList;
import io.confluent.ksql.KsqlExecutionContext;
import io.confluent.ksql.function.AggregateFunctionFactory;
import io.confluent.ksql.function.ParameterInfo;
import io.confluent.ksql.function.TableFunctionFactory;
import io.confluent.ksql.function.UdfFactory;
import io.confluent.ksql.function.types.ArrayType;
import io.confluent.ksql.function.types.ParamType;
import io.confluent.ksql.function.udf.UdfMetadata;
import io.confluent.ksql.name.FunctionName;
import io.confluent.ksql.parser.tree.DescribeFunction;
import io.confluent.ksql.rest.SessionProperties;
import io.confluent.ksql.rest.entity.ArgumentInfo;
import io.confluent.ksql.rest.entity.FunctionDescriptionList;
import io.confluent.ksql.rest.entity.FunctionInfo;
import io.confluent.ksql.rest.entity.FunctionType;
import io.confluent.ksql.rest.server.execution.StatementExecutorResponse;
import io.confluent.ksql.schema.connect.SqlSchemaFormatter;
import io.confluent.ksql.services.ServiceContext;
import io.confluent.ksql.statement.ConfiguredStatement;
import io.confluent.ksql.util.IdentifierUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public final class DescribeFunctionExecutor {
    private static final SqlSchemaFormatter FORMATTER = new SqlSchemaFormatter(IdentifierUtil::needsQuotes, new SqlSchemaFormatter.Option[0]);

    private DescribeFunctionExecutor() {
    }

    public static StatementExecutorResponse execute(ConfiguredStatement<DescribeFunction> statement, SessionProperties sessionProperties, KsqlExecutionContext executionContext, ServiceContext serviceContext) {
        DescribeFunction describeFunction = (DescribeFunction)statement.getStatement();
        FunctionName functionName = FunctionName.of((String)describeFunction.getFunctionName());
        if (executionContext.getMetaStore().isAggregate(functionName)) {
            return StatementExecutorResponse.handled(Optional.of(DescribeFunctionExecutor.describeAggregateFunction(executionContext, functionName, statement.getMaskedStatementText())));
        }
        if (executionContext.getMetaStore().isTableFunction(functionName)) {
            return StatementExecutorResponse.handled(Optional.of(DescribeFunctionExecutor.describeTableFunction(executionContext, functionName, statement.getMaskedStatementText())));
        }
        return StatementExecutorResponse.handled(Optional.of(DescribeFunctionExecutor.describeNonAggregateFunction(executionContext, functionName, statement.getMaskedStatementText())));
    }

    private static FunctionDescriptionList describeAggregateFunction(KsqlExecutionContext ksqlEngine, FunctionName functionName, String statementText) {
        AggregateFunctionFactory aggregateFactory = ksqlEngine.getMetaStore().getAggregateFactory(functionName);
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        aggregateFactory.eachFunction((func, description) -> listBuilder.add((Object)DescribeFunctionExecutor.getFunctionInfo(func.parameterInfo(), func.declaredReturnType(), description)));
        return DescribeFunctionExecutor.createFunctionDescriptionList(statementText, aggregateFactory.getMetadata(), (List<FunctionInfo>)listBuilder.build(), FunctionType.AGGREGATE);
    }

    private static FunctionDescriptionList describeTableFunction(KsqlExecutionContext executionContext, FunctionName functionName, String statementText) {
        TableFunctionFactory tableFunctionFactory = executionContext.getMetaStore().getTableFunctionFactory(functionName);
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        tableFunctionFactory.eachFunction(func -> listBuilder.add((Object)DescribeFunctionExecutor.getFunctionInfo(func.parameterInfo(), func.declaredReturnType(), func.getDescription())));
        return DescribeFunctionExecutor.createFunctionDescriptionList(statementText, tableFunctionFactory.getMetadata(), (List<FunctionInfo>)listBuilder.build(), FunctionType.TABLE);
    }

    private static FunctionDescriptionList describeNonAggregateFunction(KsqlExecutionContext executionContext, FunctionName functionName, String statementText) {
        UdfFactory udfFactory = executionContext.getMetaStore().getUdfFactory(functionName);
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        udfFactory.eachFunction(func -> listBuilder.add((Object)DescribeFunctionExecutor.getFunctionInfo(func.parameterInfo(), func.declaredReturnType(), func.getDescription())));
        return DescribeFunctionExecutor.createFunctionDescriptionList(statementText, udfFactory.getMetadata(), (List<FunctionInfo>)listBuilder.build(), FunctionType.SCALAR);
    }

    private static FunctionInfo getFunctionInfo(List<ParameterInfo> argTypes, ParamType returnTypeSchema, String description) {
        ArrayList<ArgumentInfo> args = new ArrayList<ArgumentInfo>();
        for (ParameterInfo param : argTypes) {
            String type = param.isVariadic() ? ((ArrayType)param.type()).element().toString() : param.type().toString();
            args.add(new ArgumentInfo(param.name(), type, param.description(), Boolean.valueOf(param.isVariadic())));
        }
        return new FunctionInfo(args, returnTypeSchema.toString(), description);
    }

    private static FunctionDescriptionList createFunctionDescriptionList(String statementText, UdfMetadata metadata, List<FunctionInfo> functionInfos, FunctionType functionType) {
        return new FunctionDescriptionList(statementText, metadata.getName().toUpperCase(), metadata.getDescription(), metadata.getAuthor(), metadata.getVersion(), metadata.getPath(), functionInfos, functionType);
    }
}

