/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.server.query;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.KsqlExecutionContext;
import io.confluent.ksql.analyzer.ImmutableAnalysis;
import io.confluent.ksql.analyzer.PullQueryValidator;
import io.confluent.ksql.api.server.MetricsCallbackHolder;
import io.confluent.ksql.api.server.SlidingWindowRateLimiter;
import io.confluent.ksql.config.SessionConfig;
import io.confluent.ksql.engine.KsqlEngine;
import io.confluent.ksql.execution.pull.HARouting;
import io.confluent.ksql.execution.pull.PullQueryResult;
import io.confluent.ksql.execution.scalablepush.PushRouting;
import io.confluent.ksql.execution.scalablepush.PushRoutingOptions;
import io.confluent.ksql.execution.streams.RoutingOptions;
import io.confluent.ksql.internal.PullQueryExecutorMetrics;
import io.confluent.ksql.internal.ScalablePushQueryMetrics;
import io.confluent.ksql.logging.query.QueryLogger;
import io.confluent.ksql.metastore.model.DataSource;
import io.confluent.ksql.parser.KsqlParser;
import io.confluent.ksql.parser.tree.Query;
import io.confluent.ksql.planner.QueryPlannerOptions;
import io.confluent.ksql.rest.server.KsqlRestConfig;
import io.confluent.ksql.rest.server.LocalCommands;
import io.confluent.ksql.rest.server.query.QueryMetadataHolder;
import io.confluent.ksql.rest.server.resources.streaming.PullQueryConfigPlannerOptions;
import io.confluent.ksql.rest.server.resources.streaming.PullQueryConfigRoutingOptions;
import io.confluent.ksql.rest.server.resources.streaming.PushQueryConfigPlannerOptions;
import io.confluent.ksql.rest.server.resources.streaming.PushQueryConfigRoutingOptions;
import io.confluent.ksql.rest.util.ConcurrencyLimiter;
import io.confluent.ksql.rest.util.QueryCapacityUtil;
import io.confluent.ksql.rest.util.QueryMetricsUtil;
import io.confluent.ksql.rest.util.RateLimiter;
import io.confluent.ksql.rest.util.ScalablePushUtil;
import io.confluent.ksql.services.ServiceContext;
import io.confluent.ksql.statement.ConfiguredStatement;
import io.confluent.ksql.util.ConsistencyOffsetVector;
import io.confluent.ksql.util.KsqlConfig;
import io.confluent.ksql.util.KsqlConstants;
import io.confluent.ksql.util.KsqlStatementException;
import io.confluent.ksql.util.ScalablePushQueryMetadata;
import io.confluent.ksql.util.StreamPullQueryMetadata;
import io.confluent.ksql.util.TransientQueryMetadata;
import io.vertx.core.Context;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class QueryExecutor {
    private static final Logger log = LogManager.getLogger(QueryExecutor.class);
    private final KsqlExecutionContext ksqlEngine;
    private final KsqlRestConfig ksqlRestConfig;
    private final Optional<PullQueryExecutorMetrics> pullQueryMetrics;
    private final Optional<ScalablePushQueryMetrics> scalablePushQueryMetrics;
    private final RateLimiter rateLimiter;
    private final ConcurrencyLimiter concurrencyLimiter;
    private final SlidingWindowRateLimiter pullBandRateLimiter;
    private final SlidingWindowRateLimiter scalablePushBandRateLimiter;
    private final HARouting routing;
    private final PushRouting pushRouting;
    private final Optional<LocalCommands> localCommands;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public QueryExecutor(KsqlEngine ksqlEngine, KsqlRestConfig ksqlRestConfig, KsqlConfig ksqlConfig, Optional<PullQueryExecutorMetrics> pullQueryMetrics, Optional<ScalablePushQueryMetrics> scalablePushQueryMetrics, RateLimiter rateLimiter, ConcurrencyLimiter concurrencyLimiter, SlidingWindowRateLimiter pullBandRateLimiter, SlidingWindowRateLimiter scalablePushBandRateLimiter, HARouting routing, PushRouting pushRouting, Optional<LocalCommands> localCommands) {
        this.ksqlEngine = ksqlEngine;
        this.ksqlRestConfig = ksqlRestConfig;
        this.pullQueryMetrics = pullQueryMetrics;
        this.scalablePushQueryMetrics = scalablePushQueryMetrics;
        this.rateLimiter = rateLimiter;
        this.concurrencyLimiter = concurrencyLimiter;
        this.pullBandRateLimiter = pullBandRateLimiter;
        this.scalablePushBandRateLimiter = scalablePushBandRateLimiter;
        this.routing = routing;
        this.pushRouting = pushRouting;
        this.localCommands = localCommands;
    }

    public QueryMetadataHolder handleStatement(ServiceContext serviceContext, Map<String, Object> configOverrides, Map<String, Object> requestProperties, KsqlParser.PreparedStatement<?> statement, Optional<Boolean> isInternalRequest, MetricsCallbackHolder metricsCallbackHolder, Context context, boolean excludeTombstones) {
        if (statement.getStatement() instanceof Query) {
            return this.handleQuery(serviceContext, statement, isInternalRequest, metricsCallbackHolder, configOverrides, requestProperties, context, excludeTombstones);
        }
        return QueryMetadataHolder.unhandled();
    }

    private QueryMetadataHolder handleQuery(ServiceContext serviceContext, KsqlParser.PreparedStatement<Query> statement, Optional<Boolean> isInternalRequest, MetricsCallbackHolder metricsCallbackHolder, Map<String, Object> configOverrides, Map<String, Object> requestProperties, Context context, boolean excludeTombstones) {
        if (((Query)statement.getStatement()).isPullQuery()) {
            ImmutableAnalysis analysis = this.ksqlEngine.analyzeQueryWithNoOutputTopic((Query)statement.getStatement(), statement.getMaskedStatementText(), configOverrides);
            DataSource dataSource = analysis.getFrom().getDataSource();
            DataSource.DataSourceType dataSourceType = dataSource.getDataSourceType();
            if (!this.ksqlEngine.getKsqlConfig().getBoolean("ksql.pull.queries.enable").booleanValue()) {
                throw new KsqlStatementException("Pull queries are disabled." + PullQueryValidator.PULL_QUERY_SYNTAX_HELP + System.lineSeparator() + "Please set ksql.pull.queries.enable=true to enable this feature." + System.lineSeparator(), statement.getMaskedStatementText());
            }
            switch (dataSourceType) {
                case KTABLE: {
                    AtomicReference<Object> resultForMetrics = new AtomicReference<Object>(null);
                    metricsCallbackHolder.setCallback(QueryMetricsUtil.initializePullTableMetricsCallback(this.pullQueryMetrics, this.pullBandRateLimiter, resultForMetrics));
                    SessionConfig sessionConfig = SessionConfig.of((KsqlConfig)this.ksqlEngine.getKsqlConfig(), configOverrides);
                    ConfiguredStatement configured = ConfiguredStatement.of(statement, (SessionConfig)sessionConfig);
                    return this.handleTablePullQuery(analysis, serviceContext, (ConfiguredStatement<Query>)configured, requestProperties, isInternalRequest, this.pullBandRateLimiter, resultForMetrics, Optional.empty());
                }
                case KSTREAM: {
                    AtomicReference<Object> resultForMetrics = new AtomicReference<Object>(null);
                    AtomicReference<Object> refDecrementer = new AtomicReference<Object>(null);
                    metricsCallbackHolder.setCallback(QueryMetricsUtil.initializePullStreamMetricsCallback(this.pullQueryMetrics, this.pullBandRateLimiter, analysis, resultForMetrics, refDecrementer));
                    SessionConfig sessionConfig = SessionConfig.of((KsqlConfig)this.ksqlEngine.getKsqlConfig(), configOverrides);
                    ConfiguredStatement configured = ConfiguredStatement.of(statement, (SessionConfig)sessionConfig);
                    return this.handleStreamPullQuery(analysis, serviceContext, (ConfiguredStatement<Query>)configured, resultForMetrics, refDecrementer);
                }
            }
            throw new KsqlStatementException("Unexpected data source type for pull query: " + String.valueOf(dataSourceType), statement.getMaskedStatementText());
        }
        if (ScalablePushUtil.isScalablePushQuery(statement.getStatement(), this.ksqlEngine, this.ksqlEngine.getKsqlConfig(), configOverrides)) {
            AtomicReference<Object> resultForMetrics = new AtomicReference<Object>(null);
            metricsCallbackHolder.setCallback(QueryMetricsUtil.initializeScalablePushMetricsCallback(this.scalablePushQueryMetrics, this.scalablePushBandRateLimiter, resultForMetrics));
            ImmutableAnalysis analysis = this.ksqlEngine.analyzeQueryWithNoOutputTopic((Query)statement.getStatement(), statement.getMaskedStatementText(), configOverrides);
            QueryLogger.info((Object)"Scalable push query created", (String)statement.getMaskedStatementText());
            return this.handleScalablePushQuery(analysis, serviceContext, statement, configOverrides, requestProperties, context, this.scalablePushBandRateLimiter, resultForMetrics);
        }
        QueryLogger.info((Object)"Transient query created", (String)statement.getMaskedStatementText());
        return this.handlePushQuery(serviceContext, statement, configOverrides, excludeTombstones);
    }

    private QueryMetadataHolder handleTablePullQuery(ImmutableAnalysis analysis, ServiceContext serviceContext, ConfiguredStatement<Query> configured, Map<String, Object> requestProperties, Optional<Boolean> isInternalRequest, SlidingWindowRateLimiter pullBandRateLimiter, AtomicReference<PullQueryResult> resultForMetrics, Optional<ConsistencyOffsetVector> consistencyOffsetVector) {
        PullQueryConfigRoutingOptions routingOptions = new PullQueryConfigRoutingOptions(configured.getSessionConfig().getConfig(false), configured.getSessionConfig().getOverrides(), requestProperties);
        PullQueryConfigPlannerOptions plannerOptions = new PullQueryConfigPlannerOptions(configured.getSessionConfig().getConfig(false), configured.getSessionConfig().getOverrides());
        boolean isAlreadyForwarded = routingOptions.getIsSkipForwardRequest() && isInternalRequest.orElse(true) != false;
        ConcurrencyLimiter.Decrementer decrementer = null;
        try {
            if (!isAlreadyForwarded) {
                this.rateLimiter.checkLimit();
                decrementer = this.concurrencyLimiter.increment();
            }
            pullBandRateLimiter.allow(KsqlConstants.KsqlQueryType.PULL);
            Optional<ConcurrencyLimiter.Decrementer> optionalDecrementer = Optional.ofNullable(decrementer);
            PullQueryResult result = this.ksqlEngine.executeTablePullQuery(analysis, serviceContext, configured, this.routing, (RoutingOptions)routingOptions, (QueryPlannerOptions)plannerOptions, this.pullQueryMetrics, false, consistencyOffsetVector);
            resultForMetrics.set(result);
            result.onCompletionOrException((v, t) -> optionalDecrementer.ifPresent(ConcurrencyLimiter.Decrementer::decrementAtMostOnce));
            return QueryMetadataHolder.of(result);
        }
        catch (Throwable t2) {
            if (decrementer != null) {
                decrementer.decrementAtMostOnce();
            }
            throw t2;
        }
    }

    private QueryMetadataHolder handleScalablePushQuery(ImmutableAnalysis analysis, ServiceContext serviceContext, KsqlParser.PreparedStatement<Query> statement, Map<String, Object> configOverrides, Map<String, Object> requestProperties, Context context, SlidingWindowRateLimiter scalablePushBandRateLimiter, AtomicReference<ScalablePushQueryMetadata> resultForMetrics) {
        ConfiguredStatement configured = ConfiguredStatement.of(statement, (SessionConfig)SessionConfig.of((KsqlConfig)this.ksqlEngine.getKsqlConfig(), configOverrides));
        PushQueryConfigRoutingOptions routingOptions = new PushQueryConfigRoutingOptions(this.ksqlEngine.getKsqlConfig(), configOverrides, requestProperties);
        PushQueryConfigPlannerOptions plannerOptions = new PushQueryConfigPlannerOptions(this.ksqlEngine.getKsqlConfig(), configOverrides);
        scalablePushBandRateLimiter.allow(KsqlConstants.KsqlQueryType.PUSH);
        ScalablePushQueryMetadata query = this.ksqlEngine.executeScalablePushQuery(analysis, serviceContext, configured, this.pushRouting, (PushRoutingOptions)routingOptions, (QueryPlannerOptions)plannerOptions, context, this.scalablePushQueryMetrics);
        query.prepare();
        resultForMetrics.set(query);
        QueryLogger.info((Object)"Streaming scalable push query", (String)statement.getMaskedStatementText());
        return QueryMetadataHolder.of(query);
    }

    private QueryMetadataHolder handleStreamPullQuery(ImmutableAnalysis analysis, ServiceContext serviceContext, ConfiguredStatement<Query> configured, AtomicReference<StreamPullQueryMetadata> resultForMetrics, AtomicReference<ConcurrencyLimiter.Decrementer> refDecrementer) {
        this.rateLimiter.checkLimit();
        this.pullBandRateLimiter.allow(KsqlConstants.KsqlQueryType.PULL);
        refDecrementer.set(this.concurrencyLimiter.increment());
        StreamPullQueryMetadata streamPullQueryMetadata = this.ksqlEngine.createStreamPullQuery(serviceContext, analysis, configured, false);
        resultForMetrics.set(streamPullQueryMetadata);
        this.localCommands.ifPresent(lc -> lc.write(streamPullQueryMetadata.getTransientQueryMetadata()));
        return QueryMetadataHolder.of(streamPullQueryMetadata);
    }

    private QueryMetadataHolder handlePushQuery(ServiceContext serviceContext, KsqlParser.PreparedStatement<Query> statement, Map<String, Object> streamsProperties, boolean excludeTombstones) {
        ConfiguredStatement configured = ConfiguredStatement.of(statement, (SessionConfig)SessionConfig.of((KsqlConfig)this.ksqlEngine.getKsqlConfig(), streamsProperties));
        if (QueryCapacityUtil.exceedsPushQueryCapacity(this.ksqlEngine, this.ksqlRestConfig)) {
            QueryCapacityUtil.throwTooManyActivePushQueriesException(this.ksqlEngine, this.ksqlRestConfig, statement.getMaskedStatementText());
        }
        TransientQueryMetadata query = this.ksqlEngine.executeTransientQuery(serviceContext, configured, excludeTombstones);
        this.localCommands.ifPresent(lc -> lc.write(query));
        QueryLogger.info((Object)"Streaming query", (String)statement.getMaskedStatementText());
        return QueryMetadataHolder.of(query);
    }
}

