/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.server.resources;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.confluent.ksql.rest.EndpointResponse;
import io.confluent.ksql.rest.entity.HealthCheckResponse;
import io.confluent.ksql.rest.healthcheck.HealthCheckAgent;
import io.confluent.ksql.rest.server.KsqlRestConfig;
import io.confluent.ksql.rest.server.computation.CommandRunner;
import io.confluent.ksql.rest.server.resources.KsqlResource;
import io.confluent.ksql.rest.server.services.ServerInternalKsqlClient;
import io.confluent.ksql.security.KsqlSecurityContext;
import io.confluent.ksql.services.ServiceContext;
import io.confluent.ksql.util.KsqlConfig;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.apache.kafka.clients.admin.Admin;

public class HealthCheckResource {
    private static final Boolean KEY = Boolean.TRUE;
    private final LoadingCache<Boolean, HealthCheckResponse> responseCache;

    @VisibleForTesting
    HealthCheckResource(HealthCheckAgent healthCheckAgent, Duration healthCheckInterval) {
        Objects.requireNonNull(healthCheckAgent, "healthCheckAgent");
        Objects.requireNonNull(healthCheckInterval, "healthCheckInterval");
        this.responseCache = HealthCheckResource.createResponseCache(healthCheckAgent, healthCheckInterval);
    }

    public EndpointResponse checkHealth() {
        return EndpointResponse.ok((Object)this.getResponse());
    }

    private HealthCheckResponse getResponse() {
        return (HealthCheckResponse)this.responseCache.getUnchecked((Object)KEY);
    }

    public static HealthCheckResource create(KsqlResource ksqlResource, ServiceContext serviceContext, KsqlRestConfig restConfig, KsqlConfig ksqlConfig, CommandRunner commandRunner, Admin adminClient) {
        return new HealthCheckResource(new HealthCheckAgent(new ServerInternalKsqlClient(ksqlResource, new KsqlSecurityContext(Optional.empty(), serviceContext)), restConfig, ksqlConfig, commandRunner, adminClient), Duration.ofMillis(restConfig.getLong("ksql.healthcheck.interval.ms")));
    }

    private static LoadingCache<Boolean, HealthCheckResponse> createResponseCache(final HealthCheckAgent healthCheckAgent, Duration cacheDuration) {
        CacheLoader<Boolean, HealthCheckResponse> loader = new CacheLoader<Boolean, HealthCheckResponse>(){

            public HealthCheckResponse load(@Nonnull Boolean key) {
                if (!key.equals(KEY)) {
                    throw new IllegalArgumentException("Unexpected response cache key: " + key);
                }
                return healthCheckAgent.checkHealth();
            }
        };
        return CacheBuilder.newBuilder().expireAfterWrite(cacheDuration.toMillis(), TimeUnit.MILLISECONDS).build((CacheLoader)loader);
    }
}

