/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.server.resources.streaming;

import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.planner.QueryPlannerOptions;
import io.confluent.ksql.util.KsqlConfig;
import java.util.Map;
import java.util.Optional;

public class PullQueryConfigPlannerOptions
implements QueryPlannerOptions {
    private final KsqlConfig ksqlConfig;
    private final ImmutableMap<String, ?> configOverrides;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public PullQueryConfigPlannerOptions(KsqlConfig ksqlConfig, Map<String, ?> configOverrides) {
        this.ksqlConfig = ksqlConfig;
        this.configOverrides = ImmutableMap.copyOf(configOverrides);
    }

    public boolean getTableScansEnabled() {
        return Optional.ofNullable((Boolean)this.configOverrides.get((Object)"ksql.query.pull.table.scan.enabled")).orElse(this.ksqlConfig.getBoolean("ksql.query.pull.table.scan.enabled"));
    }

    public boolean getInterpreterEnabled() {
        return Optional.ofNullable((Boolean)this.configOverrides.get((Object)"ksql.query.pull.interpreter.enabled")).orElse(this.ksqlConfig.getBoolean("ksql.query.pull.interpreter.enabled"));
    }

    public boolean getRangeScansEnabled() {
        return Optional.ofNullable((Boolean)this.configOverrides.get((Object)"ksql.query.pull.range.scan.enabled")).orElse(this.ksqlConfig.getBoolean("ksql.query.pull.range.scan.enabled"));
    }

    public boolean getLimitClauseEnabled() {
        return Optional.ofNullable((Boolean)this.configOverrides.get((Object)"ksql.query.pull.limit.clause.enabled")).orElse(this.ksqlConfig.getBoolean("ksql.query.pull.limit.clause.enabled"));
    }
}

